#include MUT_H
#include MPH_H
#include "mbk_extern.h"

#include "v_view.h"
#include "v_menu.h"
#include "g_visu.h"
#include "g_extern.c"
#include "v_extern.h"

/************************************************************************/
/*	Scan objects and test mask					*/
/************************************************************************/

V_peek_it(state, xp, yp, dxp, dyp)
int state;
int xp, yp, dxp, dyp;
{
X_RECTPEEK *ptdesc;
unsigned char layer;

	XSetForeground (display, V_gcCao[GC_FGND], V_colors[COLOR_BGND]);
	XFillRectangle (display, V_PixSave, V_gcCao[GC_FGND],
			(int)(xp - 1), (int)(yp - 1), (int)(dxp + 2), (int)(dyp + 2));
	for (layer = 0; layer <= GC_DEFAULT; layer++) {
		if (((C_Config_List.C_VISIBLE >> layer) & 1) == 0)
			continue;
		ptdesc = peek_db[layer];
		if ((layer > GC_TALU1 && layer < GC_ALU2) || layer == GC_CONT_VIA
				|| layer == GC_CONT_VIA2)
			DrawCont(layer, ptdesc, V_PixSave);
		else
			DrawObject(layer, ptdesc, V_PixSave);
	}
	if (state == ON)
		XCopyArea(display, V_PixSave, V_window, V_gcCao[GC_FGND],
						xp, yp, dxp, dyp, xp, yp);
	XSetForeground(display, V_gcCao[GC_FGND], V_colors[COLOR_FGND]);
}

DrawObject(layer, ptdesc, drawable)
unsigned char layer;
X_RECTPEEK *ptdesc;
Drawable drawable;
{
	switch (C_Config_List.C_PEEK) {
		case FILL:
			DrawObjectFill(layer, ptdesc, drawable);
			break;
		case OUTLINE:
			DrawObjectWire(layer, ptdesc, drawable);
			break;
		case PATTERN:
			DrawObjectPattern(layer, ptdesc, drawable);
			break;
		default:
			DrawObjectPattern(layer, ptdesc, drawable);
	}
}


DrawCont(layer, ptdesc, drawable)
unsigned char layer;
X_RECTPEEK *ptdesc;
Drawable drawable;
{
	switch (C_Config_List.C_PEEK) {
		case FILL:
			DrawContFill(layer, ptdesc, drawable);
			break;
		case OUTLINE:
			DrawContWire(layer, ptdesc, drawable);
			break;
		case PATTERN:
			DrawContPattern(layer, ptdesc, drawable);
			break;
		default:
			DrawContPattern(layer, ptdesc, drawable);
	}
}

DrawObjectPattern(layer, ptdesc, drawable)
unsigned char layer;
X_RECTPEEK *ptdesc;
Drawable drawable;
{
GC gc;
long x, y, dx, dy;

	gc = V_gcCao[layer];
	while (ptdesc) {
		dx = (ptdesc->DX) * scale;
		dy = (ptdesc->DY) * scale;
		x = (long)((ptdesc->X - xscreen) * scale);
		y = YMENU - 1 + (long)((yscreen - ptdesc->Y + dyscreen) * scale);
		if (dx != 0 || dy != 0) {
			XSetFillStyle(display, gc, FillStippled);
			XFillRectangle(display, drawable, gc, (int)x, (int)y,
								(int)dx + 1, (int)dy + 1);
			XSetFillStyle(display, gc, FillSolid);
			XDrawRectangle(display, drawable, gc, (int)x, (int)y,
								(int)dx, (int)dy);
		}
		ptdesc = ptdesc->NEXT;
	}
}

DrawObjectWire(layer, ptdesc, drawable)
unsigned char layer;
X_RECTPEEK *ptdesc;
Drawable drawable;
{
GC gc;
long x, y, dx, dy;

	gc = V_gcCao[layer];
	while (ptdesc) {
		dx = (ptdesc->DX) * scale;
		dy = (ptdesc->DY) * scale;
		x = (long) ((ptdesc->X - xscreen) * scale);
		y = YMENU - 1 + (long) ((yscreen - ptdesc->Y + dyscreen) * scale);
		if (dx != 0 || dy != 0) {
			XSetFillStyle(display, gc, FillSolid);
			XDrawRectangle(display, drawable, gc, (int)x, (int)y,
								(int)dx, (int)dy);
		}
		ptdesc = ptdesc->NEXT;
	}
}

DrawObjectFill(layer, ptdesc, drawable)
unsigned char layer;
X_RECTPEEK *ptdesc;
Drawable drawable;
{
GC gc;
long x, y, dx, dy;

	gc = V_gcCao[layer];
	while (ptdesc) {
		dx = (ptdesc->DX) * scale;
		dy = (ptdesc->DY) * scale;
		x = (long)((ptdesc->X - xscreen) * scale);
		y = YMENU - 1 + (long)((yscreen - ptdesc->Y + dyscreen) * scale);
		if (dx != 0 || dy != 0) {
			XSetFillStyle(display, gc, FillSolid);
			XFillRectangle(display, drawable, gc, (int) x, (int) y,
								(int) dx + 1, (int) dy + 1);
		}
		ptdesc = ptdesc->NEXT;
	}
}

DrawContPattern(layer, ptdesc, drawable)
unsigned char layer;
X_RECTPEEK *ptdesc;
Drawable drawable;
{
GC gc;
long x, y, dx, dy;
int sf;
int dxc, dyc;

	gc = V_gcCao[layer];
	sf = (int)scale;
	while (ptdesc) {
		dx = (ptdesc->DX) * scale;
		dy = (ptdesc->DY) * scale;
		x = (long)((ptdesc->X - xscreen) * scale);
		y = YMENU - 1 + (long) ((yscreen - ptdesc->Y + dyscreen) * scale);
		if (dx && dy) {
			XSetFillStyle(display, gc, FillStippled);
			XFillRectangle(display, drawable, gc, (int)(x - sf), (int)(y - sf),
								(int)(dx + 1 + (sf << 1)), (int)(dy + 1 + (sf << 1)));
			XSetFillStyle(display, gc, FillSolid);
			XDrawRectangle(display, drawable, gc, (int)(x - sf), (int)(y - sf),
								(int)(dx + (sf << 1)), (int)(dy + (sf << 1)));
			if (((dxc = (int)(dx + 1 - 2 * sf)) > 2 * sf) &&
					((dyc = (int)(dy + 1 - 2 * sf)) > 2 * sf))
				XFillRectangle(display, drawable, V_gcCao[GC_FGND],
									(int)(x + sf), (int)(y + sf), dxc, dyc);
		}
		ptdesc = ptdesc->NEXT;
	}
}

DrawContWire(layer, ptdesc, drawable)
unsigned char layer;
X_RECTPEEK *ptdesc;
Drawable drawable;
{
GC gc;
long x, y, dx, dy;
int sf;
int dxc, dyc;

	gc = V_gcCao[layer];
	XSetFillStyle (display, gc, FillSolid);
	sf = (int) scale;
	while (ptdesc) {
		dx = (ptdesc->DX) * scale;
		dy = (ptdesc->DY) * scale;
		x = (long) ((ptdesc->X - xscreen) * scale);
		y = YMENU - 1 + (long) ((yscreen - ptdesc->Y + dyscreen) * scale);
		if (dx != 0 && dy != 0) {
			XDrawRectangle(display, drawable, gc, (int)(x - sf), (int)(y - sf),
								(int)(dx + (sf << 1)), (int)(dy + (sf << 1)));
			XDrawLine(display, drawable, gc, (int)(x - sf), (int)(y - sf),
							(int)(x + dx + sf), (int)(y + dy + sf));
			XDrawLine(display, drawable, gc, (int)(x + dx + sf), (int)(y - sf),
							(int)(x - sf), (int)(y + dy + sf));
		}
		ptdesc = ptdesc->NEXT;
	}
}

DrawContFill(layer, ptdesc, drawable)
unsigned char layer;
X_RECTPEEK *ptdesc;
Drawable drawable;
{
GC gc;
long x, y, dx, dy;
int sf;
int dxc, dyc;

	gc = V_gcCao[layer];
	sf = (int) scale;
	while (ptdesc) {
		dx = (ptdesc->DX) * scale;
		dy = (ptdesc->DY) * scale;
		x = (long)((ptdesc->X - xscreen) * scale);
		y = YMENU - 1 + (long)((yscreen - ptdesc->Y + dyscreen) * scale);
		if (dx != 0 && dy != 0) {
			XSetFillStyle(display, gc, FillSolid);
			XFillRectangle(display, drawable, gc, (int)(x - sf), (int)(y - sf),
								(int)(dx + 1 + (sf << 1)), (int)(dy + 1 + (sf << 1)));
			if (((dxc = (int) (dx + 1 - 2 * sf)) > 2 * sf) &&
					((dyc = (int) (dy + 1 - 2 * sf)) > 2 * sf))
				XFillRectangle(display, drawable, V_gcCao[GC_FGND],
									(int) (x + sf), (int) (y + sf), dxc, dyc);
		}
		ptdesc = ptdesc->NEXT;
	}
}
