/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Panel.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>
 
# include MPH_H
# include RDS_H
# include RPR_H
# include GTB_H
# include GSB_H
# include GMX_H
# include GRM_H
# include GMC_H

# include "GMC_panel.h"
# include "GMC_dialog.h"
# include "GMC_create.h"
# include "GMC_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Create Panel                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       Segment Panel                         |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalCreateSegmentButtonName[] =

   {
     "Width",
     "Name",
     "Simple",
     "Close"
   };

   static GraalPanelButtonItem GraalCreateSegmentButton[] =

         {
           {
             &GRAAL_SEGMENT_NAME_TABLE[NWELL][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[NWELL][1],
             &GRAAL_SEGMENT_NAME_TABLE[NWELL][2],
             0, 0,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)NWELL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[PWELL][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[PWELL][1],
             &GRAAL_SEGMENT_NAME_TABLE[PWELL][2],
             1, 0,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)PWELL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[NDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[NDIF][1],
             &GRAAL_SEGMENT_NAME_TABLE[NDIF][2],
             0, 1,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)NDIF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[PDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[PDIF][1],
             &GRAAL_SEGMENT_NAME_TABLE[PDIF][2],
             1, 1,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)PDIF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[NTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[NTIE][1],
             &GRAAL_SEGMENT_NAME_TABLE[NTIE][2],
             0, 2,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)NTIE,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[PTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[PTIE][1],
             &GRAAL_SEGMENT_NAME_TABLE[PTIE][2],
             1, 2,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)PTIE,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[POLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[POLY][1],
             &GRAAL_SEGMENT_NAME_TABLE[POLY][2],
             0, 3,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)POLY,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_SEGMENT_NAME_TABLE[TPOLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[TPOLY][1],
             &GRAAL_SEGMENT_NAME_TABLE[TPOLY][2],
             1, 3,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)TPOLY,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[ALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ALU1][1],
             &GRAAL_SEGMENT_NAME_TABLE[ALU1][2],
             0, 4,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)ALU1,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_SEGMENT_NAME_TABLE[TALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[TALU1][1],
             &GRAAL_SEGMENT_NAME_TABLE[TALU1][2],
             1, 4,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)TALU1,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[ALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ALU2][1],
             &GRAAL_SEGMENT_NAME_TABLE[ALU2][2],
             0, 5,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)ALU2,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_SEGMENT_NAME_TABLE[TALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[TALU2][1],
             &GRAAL_SEGMENT_NAME_TABLE[TALU2][2],
             1, 5,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)TALU2,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[ALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ALU3][1],
             &GRAAL_SEGMENT_NAME_TABLE[ALU3][2],
             0, 6,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)ALU3,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_SEGMENT_NAME_TABLE[TALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[TALU3][1],
             &GRAAL_SEGMENT_NAME_TABLE[TALU3][2],
             1, 6,
             1, 1,
             CallbackChangeSegmentLayer,
             (XtPointer)TALU3,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateSegmentButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 7,
             2, 1,
             CallbackChangeSegmentWidth,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateSegmentButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 8,
             2, 1,
             CallbackChangeSegmentName,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateSegmentButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 9,
             2, 1,
             CallbackChangeSegmentWire,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateSegmentButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 10,
             2, 1,
             CallbackChangeSegmentClose,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalCreateSegmentPanel  =

         {
           "Segment",
           1,
           GRAAL_CREATE_SEGMENT_X,
           GRAAL_CREATE_SEGMENT_Y, 
           90,
           275,
           2,  
           11,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalCreateSegmentButton
         };

   int GraalCreateSegmentDefaultValues[ 4 ] =

         {
           GRAAL_CREATE_SEGMENT_X,
           GRAAL_CREATE_SEGMENT_Y, 
           90, 275
         };

/*------------------------------------------------------------\
|                                                             |
|                          Via Panel                          |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalCreateViaButtonName [] =

   {
     "Close"
   };

   static GraalPanelButtonItem GraalCreateViaButton[] =

         {
           {
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_N][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_N][1],
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_N][2],
             0, 0,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)CONT_DIF_N,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_P][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_P][1],
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_P][2],
             0, 1,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)CONT_DIF_P,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_N][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_N][1],
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_N][2],
             0, 2,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)CONT_BODY_N,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_P][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_P][1],
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_P][2],
             0, 3,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)CONT_BODY_P,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[C_X_N][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[C_X_N][1],
             &GRAAL_VIA_NAME_TABLE[C_X_N][2],
             0, 4,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)C_X_N,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[C_X_P][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[C_X_P][1],
             &GRAAL_VIA_NAME_TABLE[C_X_P][2],
             0, 5,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)C_X_P,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_POLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_POLY][1],
             &GRAAL_VIA_NAME_TABLE[CONT_POLY][2],
             0, 6,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)CONT_POLY,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_VIA][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_VIA][1],
             &GRAAL_VIA_NAME_TABLE[CONT_VIA][2],
             0, 7,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)CONT_VIA,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_VIA2][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_VIA2][1],
             &GRAAL_VIA_NAME_TABLE[CONT_VIA2][2],
             0, 8,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)CONT_VIA2,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_VIA3][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_VIA3][1],
             &GRAAL_VIA_NAME_TABLE[CONT_VIA3][2],
             0, 9,
             1, 1,
             CallbackChangeViaType,
             (XtPointer)CONT_VIA3,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateViaButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 10,
             1, 1,
             CallbackChangeViaClose,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalCreateViaPanel  =

         {
           "Via",
           1,
           GRAAL_CREATE_VIA_X,
           GRAAL_CREATE_VIA_Y,
           90,
           275,
           1,
           11,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalCreateViaButton
         };

   int GraalCreateViaDefaultValues[ 4 ] =

         {
           GRAAL_CREATE_VIA_X,
           GRAAL_CREATE_VIA_Y,
           90, 275
         };

/*------------------------------------------------------------\
|                                                             |
|                        Transistor Panel                     |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalCreateTransistorButtonName [] =

   {
     "Length",
     "Simple",
     "Close"
   };

   static GraalPanelButtonItem GraalCreateTransistorButton[] =

         {
           {
             &GRAAL_SEGMENT_NAME_TABLE[ NTRANS ][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ NTRANS ][1],
             &GRAAL_SEGMENT_NAME_TABLE[ NTRANS ][2],
             0, 0,
             1, 1,
             CallbackChangeTransistorType,
             (XtPointer)NTRANS,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[ PTRANS ][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ PTRANS ][1],
             &GRAAL_SEGMENT_NAME_TABLE[ PTRANS ][2],
             0, 1,
             1, 1,
             CallbackChangeTransistorType,
             (XtPointer)PTRANS,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateTransistorButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackChangeTransistorLength,
             (XtPointer) NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateTransistorButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 3,
             1, 1,
             CallbackChangeTransistorWire,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateTransistorButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 4,
             1, 1,
             CallbackChangeTransistorClose,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalCreateTransistorPanel  =

         {
           "Transistor",
           1,
           GRAAL_CREATE_TRANSISTOR_X,
           GRAAL_CREATE_TRANSISTOR_Y,
           90, 
           125,
           1,  
           5,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalCreateTransistorButton
         };

   int GraalCreateTransistorDefaultValues[ 4 ] =

         {
           GRAAL_CREATE_TRANSISTOR_X,
           GRAAL_CREATE_TRANSISTOR_Y,
           90, 125
         };

/*------------------------------------------------------------\
|                                                             |
|                       Connector Panel                       |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalCreateConnectorButtonName[] =

   {
     "Width",
     "Close"
   };

   static GraalPanelButtonItem GraalCreateConnectorButton[] =

         {
           {
             &GRAAL_CONNECTOR_NAME_TABLE[NWELL][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[NWELL][1],
             &GRAAL_CONNECTOR_NAME_TABLE[NWELL][2],
             0, 0,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)NWELL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[PWELL][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[PWELL][1],
             &GRAAL_CONNECTOR_NAME_TABLE[PWELL][2],
             1, 0,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)PWELL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[NDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[NDIF][1],
             &GRAAL_CONNECTOR_NAME_TABLE[NDIF][2],
             0, 1,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)NDIF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[PDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[PDIF][1],
             &GRAAL_CONNECTOR_NAME_TABLE[PDIF][2],
             1, 1,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)PDIF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[NTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[NTIE][1],
             &GRAAL_CONNECTOR_NAME_TABLE[NTIE][2],
             0, 2,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)NTIE,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[PTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[PTIE][1],
             &GRAAL_CONNECTOR_NAME_TABLE[PTIE][2],
             1, 2,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)PTIE,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[POLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[POLY][1],
             &GRAAL_CONNECTOR_NAME_TABLE[POLY][2],
             0, 3,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)POLY,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_CONNECTOR_NAME_TABLE[TPOLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[TPOLY][1],
             &GRAAL_CONNECTOR_NAME_TABLE[TPOLY][2],
             1, 3,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)TPOLY,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[ALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[ALU1][1],
             &GRAAL_CONNECTOR_NAME_TABLE[ALU1][2],
             0, 4,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)ALU1,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_CONNECTOR_NAME_TABLE[TALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[TALU1][1],
             &GRAAL_CONNECTOR_NAME_TABLE[TALU1][2],
             1, 4,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)TALU1,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[ALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[ALU2][1],
             &GRAAL_CONNECTOR_NAME_TABLE[ALU2][2],
             0, 5,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)ALU2,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_CONNECTOR_NAME_TABLE[TALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[TALU2][1],
             &GRAAL_CONNECTOR_NAME_TABLE[TALU2][2],
             1, 5,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)TALU2,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[ALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[ALU3][1],
             &GRAAL_CONNECTOR_NAME_TABLE[ALU3][2],
             0, 6,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)ALU3,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_CONNECTOR_NAME_TABLE[TALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[TALU3][1],
             &GRAAL_CONNECTOR_NAME_TABLE[TALU3][2],
             1, 6,
             1, 1,
             CallbackChangeConnectorLayer,
             (XtPointer)TALU3,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateConnectorButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 7,
             2, 1,
             CallbackChangeConnectorWidth,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_NORTH][0],
             NULL, NULL, 0, 0,
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_NORTH][1],
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_NORTH][2],
             0, 8,
             2, 1,
             CallbackChangeConnectorOrient,
             (XtPointer)GRAAL_NORTH,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_SOUTH][0],
             NULL, NULL, 0, 0,
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_SOUTH][1],
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_SOUTH][2],
             0, 9,
             2, 1,
             CallbackChangeConnectorOrient,
             (XtPointer)GRAAL_SOUTH,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_EAST][0], 
             NULL, NULL, 0, 0,
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_EAST][1], 
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_EAST][2], 
             0, 10,
             2, 1,
             CallbackChangeConnectorOrient,
             (XtPointer)GRAAL_EAST,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_WEST][0], 
             NULL, NULL, 0, 0,
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_WEST][1], 
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_WEST][2], 
             0, 11,
             2, 1,
             CallbackChangeConnectorOrient,
             (XtPointer)GRAAL_WEST,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateConnectorButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 12,
             2, 1,
             CallbackChangeConnectorClose,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalCreateConnectorPanel  =

         {
           "Connector",
           1,
           GRAAL_CREATE_CONNECTOR_X,
           GRAAL_CREATE_CONNECTOR_Y,
           90, 
           325,
           2,  
           13,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalCreateConnectorButton
         };

   int GraalCreateConnectorDefaultValues[ 4 ] =

         {
           GRAAL_CREATE_CONNECTOR_X,
           GRAAL_CREATE_CONNECTOR_Y,
           90, 325
         };

/*------------------------------------------------------------\
|                                                             |
|                        Reference Panel                      |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalCreateReferenceButtonName[] =

   {
     "Close"
   };
 
   static GraalPanelButtonItem GraalCreateReferenceButton[] =

         {
           {
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_REF][0],
             NULL, NULL, 0, 0,
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_REF][1],
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_REF][2],
             0, 0,
             1, 1,
             CallbackChangeReferenceType,
             (XtPointer)MBK_REF_REF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_CON][0],
             NULL, NULL, 0, 0,
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_CON][1],
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_CON][2],
             0, 1,
             1, 1,
             CallbackChangeReferenceType,
             (XtPointer)MBK_REF_CON,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateReferenceButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackChangeReferenceClose,
             (XtPointer)NULL,
             (Widget)NULL
           }
           , 
           NULL
        };

   GraalPanelItem GraalCreateReferencePanel  =

         {
           "Reference",
           1,
           GRAAL_CREATE_REFERENCE_X,
           GRAAL_CREATE_REFERENCE_Y,
           90, 
           75,
           1,  
           3,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalCreateReferenceButton
         };

   int GraalCreateReferenceDefaultValues[ 4 ] =

         {
           GRAAL_CREATE_REFERENCE_X,
           GRAAL_CREATE_REFERENCE_Y,
           90, 75
         };

/*------------------------------------------------------------\
|                                                             |
|                        Instance  Panel                      |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalCreateInstanceButtonName[] =

   {
     "Close"
   };

   static GraalPanelButtonItem GraalCreateInstanceButton[] =

         {
           {
             &GRAAL_SYMMETRY_NAME_TABLE[NOSYM][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[NOSYM][1],
             &GRAAL_SYMMETRY_NAME_TABLE[NOSYM][2],
             0, 0,
             1, 1,
             CallbackChangeInstanceSym,
             (XtPointer)NOSYM,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_X][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_X][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_X][2],
             0, 1,
             1, 1,
             CallbackChangeInstanceSym,
             (XtPointer)SYM_X,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_Y][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_Y][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_Y][2],
             0, 2,
             1, 1,
             CallbackChangeInstanceSym,
             (XtPointer)SYM_Y,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SYMXY][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SYMXY][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SYMXY][2],
             0, 3,
             1, 1,
             CallbackChangeInstanceSym,
             (XtPointer)SYMXY,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_P][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_P][1],
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_P][2],
             0, 4,
             1, 1,
             CallbackChangeInstanceSym,
             (XtPointer)ROT_P,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_M][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_M][1],
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_M][2],
             0, 5,
             1, 1,
             CallbackChangeInstanceSym,
             (XtPointer)ROT_M,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RP][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RP][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RP][2],
             0, 6,
             1, 1,
             CallbackChangeInstanceSym,
             (XtPointer)SY_RP,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RM][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RM][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RM][2],
             0, 7,
             1, 1,
             CallbackChangeInstanceSym,
             (XtPointer)SY_RM,
             (Widget)NULL
           }
           ,
           {
             &GraalCreateInstanceButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 8,
             1, 1,
             CallbackChangeInstanceClose,
             (XtPointer)NULL,
             (Widget)NULL
           }
           , 
           NULL
        };  

   GraalPanelItem GraalCreateInstancePanel  =

         {
           "Instance",
           1,
           GRAAL_CREATE_INSTANCE_X,
           GRAAL_CREATE_INSTANCE_Y,
           90, 
           225,
           1,  
           9,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalCreateInstanceButton
         };

   int GraalCreateInstanceDefaultValues[ 4 ] =

         {
           GRAAL_CREATE_INSTANCE_X,
           GRAAL_CREATE_INSTANCE_Y,
           90, 225
         };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    Callback For Segment                     |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeSegmentLayer                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeSegmentLayer( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalSegmentLayer = (int)ClientData;
    GraalSegmentWidth = GRAAL_SEGMENT_VALUE_TABLE[ GraalSegmentLayer ][0];

    if ( GraalSegmentWire == GRAAL_FALSE )
    {
      GraalChangeEditMode( GRAAL_CREATE_SEGMENT,
                           GraalPromptCreateSegment );
    }
    else
    {
      GraalChangeEditMode( GRAAL_CREATE_SEGMENT_WIRE,
                           GraalPromptCreateSegment );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeSegmentWire                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeSegmentWire( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XmString Label;

    GraalSegmentWire = ! GraalSegmentWire;

    if ( GraalSegmentWire == GRAAL_FALSE )
    {
      Label = XmStringCreateSimple( "Simple" );

      GraalChangeEditMode( GRAAL_CREATE_SEGMENT,
                           GraalPromptCreateSegment );
    }
    else
    {   
      Label = XmStringCreateSimple( "Wire" );

      GraalChangeEditMode( GRAAL_CREATE_SEGMENT_WIRE,
                           GraalPromptCreateSegment );
    }

    XtVaSetValues( MyWidget, XmNlabelString, Label,
                             XmNresizable  , False,
                             NULL );
 
    XmStringFree( Label );
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeSegmentWidth                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeSegmentWidth( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalChangeSegmentWidthDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeSegmentName                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeSegmentName( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalChangeSegmentNameDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeSegmentClose                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeSegmentClose( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalCreateSegmentPanel.PANEL );

    GraalChangeEditMode( GRAAL_EDIT_MEASURE,
                         GraalPromptEditMeasure );
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Via                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackChangeViaType                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeViaType( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalViaType = (int)ClientData;

    GraalChangeEditMode( GRAAL_CREATE_VIA,
                         GraalPromptCreateVia );
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackChangeViaClose                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeViaClose( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalCreateViaPanel.PANEL );

    GraalChangeEditMode( GRAAL_EDIT_MEASURE,
                         GraalPromptEditMeasure );
  }

/*------------------------------------------------------------\
|                                                             |
|                    Callback For Transistor                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackChangeTransistorType             |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeTransistorType( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalTransistorType   = (int)ClientData;
    GraalTransistorLength = GRAAL_SEGMENT_VALUE_TABLE[ GraalTransistorType ][0];

    if ( GraalTransistorWire == GRAAL_FALSE )
    {
      GraalChangeEditMode( GRAAL_CREATE_TRANSISTOR,
                           GraalPromptCreateTransistor );
    }
    else
    {   
      GraalChangeEditMode( GRAAL_CREATE_TRANSISTOR_WIRE,
                           GraalPromptCreateTransistor );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeTransistorLength               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeTransistorLength( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalChangeTransistorLengthDialog );
  }    

/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeTransistorWire                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeTransistorWire( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XmString Label;

    GraalTransistorWire = ! GraalTransistorWire;

    if ( GraalTransistorWire == GRAAL_FALSE )
    {
      Label = XmStringCreateSimple( "Simple" );

      GraalChangeEditMode( GRAAL_CREATE_TRANSISTOR,
                           GraalPromptCreateTransistor );
    }
    else
    {   
      Label = XmStringCreateSimple( "Wire" );

      GraalChangeEditMode( GRAAL_CREATE_TRANSISTOR_WIRE,
                           GraalPromptCreateTransistor );
    }

    XtVaSetValues( MyWidget, XmNlabelString, Label,
                             XmNresizable  , False,
                             NULL );

    XmStringFree( Label );
  }


/*------------------------------------------------------------\
|                                                             |
|                   CallbackChangeTransistorClose             |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeTransistorClose( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalCreateTransistorPanel.PANEL );

    GraalChangeEditMode( GRAAL_EDIT_MEASURE,
                         GraalPromptEditMeasure );
  }

/*------------------------------------------------------------\
|                                                             |
|                      Callback For Connector                 |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackChangeConnectorLayer             |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeConnectorLayer( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalConnectorLayer = (int)ClientData;
    GraalConnectorWidth = GRAAL_SEGMENT_VALUE_TABLE[ GraalConnectorLayer ][0];

    GraalChangeEditMode( GRAAL_CREATE_CONNECTOR,
                         GraalPromptCreateConnector );
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackChangeConnectorWidth                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeConnectorWidth( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalChangeConnectorWidthDialog );
  }    

/*------------------------------------------------------------\
|                                                             |
|                 CallbackChangeConnectorOrient               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeConnectorOrient( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalConnectorOrient = (int)ClientData;

    GraalChangeEditMode( GRAAL_CREATE_CONNECTOR,
                         GraalPromptCreateConnector );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackChangeConnectorClose             |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeConnectorClose( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalCreateConnectorPanel.PANEL );

    GraalChangeEditMode( GRAAL_EDIT_MEASURE,
                         GraalPromptEditMeasure );
  }

/*------------------------------------------------------------\
|                                                             |
|                      Callback For Reference                 |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackChangeReferenceType              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeReferenceType( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalReferenceType = (int)ClientData;

    GraalChangeEditMode( GRAAL_CREATE_REFERENCE,
                         GraalPromptCreateReference );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackChangeReferenceClose             |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeReferenceClose( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalCreateReferencePanel.PANEL );

    GraalChangeEditMode( GRAAL_EDIT_MEASURE,
                         GraalPromptEditMeasure );
  }

/*------------------------------------------------------------\
|                                                             |
|                      Callback For Instance                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackChangeInstanceSym                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeInstanceSym( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalInstanceSym = (int)ClientData;

    GraalChangeEditMode( GRAAL_CREATE_INSTANCE,
                         GraalPromptCreateInstance );
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackChangeInstanceClose             |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeInstanceClose( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalCreateInstancePanel.PANEL );

    GraalChangeEditMode( GRAAL_EDIT_MEASURE,
                         GraalPromptEditMeasure );
  }
