/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                 Dialog.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>
# include <Xm/FileSB.h>
# include <Xm/SelectioB.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GSB_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GME_H

# include "GME_dialog.h"
# include "GME_modify.h"
# include "GME_search.h"
# include "GME_edit.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Search Dialog                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    Search Connector Dialog                  |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalSearchConnectorDialog =

  {
    "Connector name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackSearchConnectorOk,
    (XtPointer)NULL,
    (void *)CallbackSearchConnectorCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                    Search Instance  Dialog                  |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalSearchInstanceDialog =

  {
    "Instance name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackSearchInstanceOk,
    (XtPointer)NULL,
    (void *)CallbackSearchInstanceCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                    Search Reference Dialog                  |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalSearchReferenceDialog =

  {
    "Reference name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackSearchReferenceOk,
    (XtPointer)NULL,
    (void *)CallbackSearchReferenceCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                      Search Segment Dialog                  |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalSearchSegmentDialog =

  {
    "Segment name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackSearchSegmentOk,
    (XtPointer)NULL,
    (void *)CallbackSearchSegmentCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                        Modify Dialog                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Segment Dialog                      |
|                                                             |
\------------------------------------------------------------*/
 
  GraalDialogItem GraalModifySegmentWidthDialog =

  {
    "Segment width",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackModifySegmentWidthOk,
    (XtPointer)NULL,
    (void *)CallbackModifySegmentWidthCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalModifySegmentNameDialog =

  {
    "Segment name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackModifySegmentNameOk,
    (XtPointer)NULL,
    (void *)CallbackModifySegmentNameCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                       Transistor Dialog                     |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalModifyTransistorLengthDialog =

  {
    "Transistor length",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackModifyTransistorLengthOk,
    (XtPointer)NULL,
    (void *)CallbackModifyTransistorLengthCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                        Connector Dialog                     |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalModifyConnectorWidthDialog =

  {
    "Connector width",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackModifyConnectorWidthOk,
    (XtPointer)NULL,
    (void *)CallbackModifyConnectorWidthCancel,
    (XtPointer)NULL
  };
    
  GraalDialogItem GraalModifyConnectorNameDialog =
 
  {
    "Connector name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackModifyConnectorNameOk,
    (XtPointer)NULL,
    (void *)CallbackModifyConnectorNameCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                        Reference Dialog                     |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalModifyReferenceNameDialog =

  {
    "Reference name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackModifyReferenceNameOk,
    (XtPointer)NULL,
    (void *)CallbackModifyReferenceNameCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                        Instance  Dialog                     |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalModifyInstanceNameDialog =

  {
    "Instance name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackModifyInstanceNameOk,
    (XtPointer)NULL,
    (void *)CallbackModifyInstanceNameCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalModifyInstanceModelDialog =

  {
    "Instance model",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackModifyInstanceModelOk,
    (XtPointer)NULL,
    (void *)CallbackModifyInstanceModelCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     GraalBuildEditDialog                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalBuildEditDialog()

  {
    GraalBuildDialog( GraalMainWindow, &GraalSearchConnectorDialog        );
    GraalBuildDialog( GraalMainWindow, &GraalSearchInstanceDialog         );
    GraalBuildDialog( GraalMainWindow, &GraalSearchReferenceDialog        );
    GraalBuildDialog( GraalMainWindow, &GraalSearchSegmentDialog          );
    GraalBuildDialog( GraalMainWindow, &GraalModifySegmentWidthDialog     );
    GraalBuildDialog( GraalMainWindow, &GraalModifySegmentNameDialog      );
    GraalBuildDialog( GraalMainWindow, &GraalModifyTransistorLengthDialog );
    GraalBuildDialog( GraalMainWindow, &GraalModifyConnectorWidthDialog   );
    GraalBuildDialog( GraalMainWindow, &GraalModifyConnectorNameDialog    );
    GraalBuildDialog( GraalMainWindow, &GraalModifyReferenceNameDialog    );
    GraalBuildDialog( GraalMainWindow, &GraalModifyInstanceNameDialog     );
    GraalBuildDialog( GraalMainWindow, &GraalModifyInstanceModelDialog    );
    GraalBuildDialog( GraalMainWindow, &GraalSearchConnectorDialog        );
    GraalBuildDialog( GraalMainWindow, &GraalSearchInstanceDialog         );
    GraalBuildDialog( GraalMainWindow, &GraalSearchReferenceDialog        );
    GraalBuildDialog( GraalMainWindow, &GraalSearchSegmentDialog          );
  }

/*------------------------------------------------------------\
|                                                             |
|                      Callback For Dialog                    |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      Callback For Modify                    |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifySegmentWidthOk               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifySegmentWidthOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *WidthSet;
    long  NewWidth;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &WidthSet );

    XtUnmanageChild( GraalModifySegmentWidthDialog.WIDGET );

    GraalExitDialog();

    if ( WidthSet != (char *)NULL )
    {
      NewWidth = atoi( WidthSet );

      if ( NewWidth >=  GRAAL_SEGMENT_VALUE_TABLE[ GraalSegmentMLayer ][0] )    
      {
        GraalSegmentMWidth = NewWidth;
      }
      else
      {  
        GraalErrorMessage( GraalMainWindow, "Incorrect segment width !" );
      }

      GraalPromptModifySegment();
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackModifySegmentWidthCancel             |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackModifySegmentWidthCancel( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalModifySegmentWidthDialog.WIDGET );
 
    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackModifySegmentNameOk               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifySegmentNameOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );

    XtUnmanageChild( GraalModifySegmentNameDialog.WIDGET );

    GraalExitDialog();

    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL )
    {
      NameSet = namealloc( NameSet );
    }

    GraalSegmentMName = NameSet;

    GraalPromptModifySegment();
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackModifySegmentNameCancel             |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackModifySegmentNameCancel( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalModifySegmentNameDialog.WIDGET );
 
    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                    Callback For Transistor                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                 CallbackModifyTransistorLengthOk            |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyTransistorLengthOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *LengthSet;
    long  NewLength;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &LengthSet );

    XtUnmanageChild( GraalModifyTransistorLengthDialog.WIDGET );

    GraalExitDialog();

    if ( LengthSet != (char *)NULL )
    {
      NewLength = atoi( LengthSet );

      if ( NewLength >=  GRAAL_SEGMENT_VALUE_TABLE[ GraalTransistorMType ][0] )
      {
        GraalTransistorMLength = NewLength;
      }
      else
      {   
        GraalErrorMessage( GraalMainWindow, "Incorrect transistor length !" );
      }

      GraalPromptModifyTransistor();
    }
  }  

/*------------------------------------------------------------\
|                                                             |
|               CallbackModifyTransistorLengthCancel          |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackModifyTransistorLengthCancel( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalModifyTransistorLengthDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Connector                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                 CallbackModifyConnectorWidthOk              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyConnectorWidthOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *WidthSet;
    long  NewWidth;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &WidthSet );
 
    XtUnmanageChild( GraalModifyConnectorWidthDialog.WIDGET );
 
    GraalExitDialog();
 
    if ( WidthSet != (char *)NULL )
    {
      NewWidth = atoi( WidthSet );

      if ( NewWidth >=  GRAAL_SEGMENT_VALUE_TABLE[ GraalConnectorMLayer ][0] )
      {
        GraalConnectorMWidth = NewWidth;
      }
      else
      {   
        GraalErrorMessage( GraalMainWindow, "Incorrect connector width !" );
      }
 
      GraalPromptModifyConnector();
    }
  }

/*------------------------------------------------------------\
|                                                             |
|               CallbackModifyConnectorWidthCancel            |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyConnectorWidthCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalModifyConnectorWidthDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyConnectorNameOk              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyConnectorNameOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalModifyConnectorNameDialog.WIDGET );
 
    GraalExitDialog();

    NameSet = GraalPostTreatString( NameSet );
 
    if ( NameSet != (char *)NULL )
    {
      NameSet = namealloc( NameSet );

      GraalConnectorMName = NameSet;

      GraalPromptModifyConnector();
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackModifyConnectorNameCancel            |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackModifyConnectorNameCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalModifyConnectorNameDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Reference                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyReferenceNameOk              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyReferenceNameOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalModifyReferenceNameDialog.WIDGET );
 
    GraalExitDialog();

    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL ) 
    {
      NameSet = namealloc( NameSet );

      GraalReferenceMName = NameSet;

      GraalPromptModifyReference();
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackModifyReferenceNameCancel            |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackModifyReferenceNameCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalModifyReferenceNameDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Instance                   |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                   CallbackModifyInstanceNameOk              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyInstanceNameOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalModifyInstanceNameDialog.WIDGET );
 
    GraalExitDialog();

    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL ) 
    {
      NameSet = namealloc( NameSet );

      GraalInstanceMName = NameSet;
    }

    GraalPromptModifyInstance();
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackModifyInstanceNameCancel            |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackModifyInstanceNameCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalModifyInstanceNameDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyInstanceModelOk              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyInstanceModelOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *ModelSet;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &ModelSet );

    XtUnmanageChild( GraalModifyInstanceModelDialog.WIDGET );

    GraalExitDialog();

    ModelSet = GraalPostTreatString( ModelSet );

    if ( ModelSet != (char *)NULL )
    {
      ModelSet = namealloc( ModelSet );

      GraalInstanceMModel = ModelSet;
    }

    GraalPromptModifyInstance();
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackModifyInstanceModelCancel            |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyInstanceModelCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalModifyInstanceModelDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                        Search Callback                      |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     Callback For Connector                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                   CallbackSearchConnectorOk                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackSearchConnectorOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalSearchConnectorDialog.WIDGET );
 
    GraalExitDialog();

    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL ) 
    {
      NameSet = namealloc( NameSet );

      GraalEditSearchConnector( NameSet );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackSearchConnectorCancel               |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackSearchConnectorCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalSearchConnectorDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Instance                   |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackSearchInstanceOk                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackSearchInstanceOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalSearchInstanceDialog.WIDGET );
 
    GraalExitDialog();

    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL ) 
    {
      NameSet = namealloc( NameSet );

      GraalEditSearchInstance( NameSet );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackSearchInstanceCancel               |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackSearchInstanceCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalSearchInstanceDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Reference                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                   CallbackSearchReferenceOk                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackSearchReferenceOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalSearchReferenceDialog.WIDGET );
 
    GraalExitDialog();

    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL ) 
    {
      NameSet = namealloc( NameSet );

      GraalEditSearchReference( NameSet );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackSearchReferenceCancel               |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackSearchReferenceCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalSearchReferenceDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Segment                    |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     CallbackSearchSegmentOk                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackSearchSegmentOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalSearchSegmentDialog.WIDGET );
 
    GraalExitDialog();

    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL ) 
    {
      NameSet = namealloc( NameSet );

      GraalEditSearchSegment( NameSet );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackSearchSegmentCancel               |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackSearchSegmentCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalSearchSegmentDialog.WIDGET );

    GraalExitDialog();
  }
