/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Message.c                        |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>
 

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GME_H
# include "GME_modify.h"
# include "GME_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  static char MessageBuffer[ 512 ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                 GraalPromptSelectPointIdentify              |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectPointIdentify()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE  , "Identify" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO  , "Select object" );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter select point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                GraalPromptSelectWindowIdentify              |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectWindowIdentify()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Identify" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter next corner" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                 GraalPromptSelectPointCopy                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectPointCopy()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE  , "Copy" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO  , "Select object" );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter select point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                GraalPromptSelectWindowCopy                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectWindowCopy()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Copy" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter next corner" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                  GraalPromptEditCopy                        |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptEditCopy()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Copy" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select vector" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter source point" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter target point" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                 GraalPromptSelectPointMove                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectPointMove()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE  , "Move" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO  , "Select object" );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter select point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                GraalPromptSelectWindowMove                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectWindowMove()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Move" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter next corner" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                  GraalPromptEditMove                        |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptEditMove()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Move" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select vector" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter source point" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter target point" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                 GraalPromptSelectPointDelete                |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectPointDelete()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE  , "Delete" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO  , "Select object" );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter select point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                GraalPromptSelectWindowDelete                |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectWindowDelete()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Delete" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter next corner" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                 GraalPromptSelectPointStretch               |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectPointStretch()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE  , "Stretch" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO  , "Select object" );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter select point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                  GraalPromptEditStretch                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptEditStretch()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Stretch" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select vector" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter source point" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter target point" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                 GraalPromptSelectPointModify                |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectPointModify()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE  , "Modify" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO  , "Select object" );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter select point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                GraalPromptSelectWindowModify                |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptSelectWindowModify()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Modify" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter next corner" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalPromptModifySegment                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptModifySegment()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Modify Segment" );

    if ( GraalSegmentMName == (char *)NULL )
    {
      sprintf( MessageBuffer, "Layer: %s   Width: %2d   Name: none",
               GRAAL_SEGMENT_NAME_TABLE[ GraalSegmentMLayer ][0] ,
               GraalSegmentMWidth );
    }
    else
    {   
      sprintf( MessageBuffer, "Layer: %s   Width: %2d   Name: %s",
               GRAAL_SEGMENT_NAME_TABLE[ GraalSegmentMLayer ][0] ,
               GraalSegmentMWidth, GraalSegmentMName );
    }

    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter new properties for this segment" );
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalPromptModifyConnector               |
|                                                             |
\------------------------------------------------------------*/
 
  void GraalPromptModifyConnector()
 
  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Modify Connector" );

    sprintf( MessageBuffer, "Layer: %s   Width: %2d   Orient: %s   Name: %s",
             GRAAL_CONNECTOR_NAME_TABLE[ GraalConnectorMLayer ][0],
             GraalConnectorMWidth,
             GRAAL_ORIENT_NAME_TABLE[ GraalConnectorMOrient ][0],
             GraalConnectorMName );

    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter new properties for this connector" );
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalPromptModifyReference               |
|                                                             |
\------------------------------------------------------------*/
 
  void GraalPromptModifyReference()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Modify Reference" );
 
    if ( GraalReferenceMName != (char *)NULL )
    {
      sprintf( MessageBuffer, "Type: %s   Name: %s",
               GRAAL_REFERENCE_NAME_TABLE[GraalReferenceMType][0],
               GraalReferenceMName );
    }
    else
    {   
      sprintf( MessageBuffer, "Type: %s   Name: none",
               GRAAL_REFERENCE_NAME_TABLE[GraalReferenceMType][0] );
    }

    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter new properties for this reference" );
  }  

/*------------------------------------------------------------\
|                                                             |
|                      GraalPromptModifyVia                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptModifyVia()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Modify Via" );

    sprintf( MessageBuffer, "Type: %s",
             GRAAL_VIA_NAME_TABLE[ GraalViaMType ][0] );

    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter new properties for this via" );
  }  

/*------------------------------------------------------------\
|                                                             |
|                      GraalPromptModifyTransistor            |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptModifyTransistor()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Modify Transistor" );

    sprintf( MessageBuffer, "Type: %s   Length: %2d",
             GRAAL_SEGMENT_NAME_TABLE[ GraalTransistorMType ][0],
             GraalTransistorMLength );

    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter new properties for this transistor" );
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalPromptModifyInstance              |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptModifyInstance()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Modify Instance" );

    sprintf( MessageBuffer, "Symmetry: %s   Model: %s   Name: %s",
             GRAAL_SYMMETRY_NAME_TABLE[ GraalInstanceMSym ][0],
             GraalInstanceMModel, GraalInstanceMName  );

    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter new properties for this instance" );
  }
