/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Search.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GSB_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GMV_H
# include GME_H

# include "GME_search.h"
# include "GME_panel.h"
# include "GME_edit.h"
# include "GME_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  char GraalSearchAbort;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      GraalEditSearchConnector               |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSearchConnector( ConnectorName )

    char *ConnectorName;
  {
    graalconrec *ScanCon;
    graalsearch *Search;
    rdsrec_list *Rec;
    long         X1;
    long         Y1;

    for ( ScanCon  = GraalHeadConRec;
          ScanCon != (graalconrec *)NULL;
          ScanCon  = ScanCon->NEXT )
    {
      Rec = ScanCon->RECTANGLE;

      if ( ( ! IsGraalDeleted( Rec )    ) &&
           ( Rec->NAME == ConnectorName ) )
      {
        GraalAddSearch( Rec );
      }
    }

    if ( GraalHeadSearch == (graalsearch *)NULL )
    {
      GraalWarningMessage( GraalMainWindow, "No connector found !" );
    }
    else
    {
      for ( Search  = GraalHeadSearch;
            Search != (graalsearch *)NULL;
            Search  = Search->NEXT )
      {
        Rec = Search->RECTANGLE;

        X1 = ( Rec->X + ( Rec->DX >> 1 ) ) / RDS_LAMBDA;
        Y1 = ( Rec->Y + ( Rec->DY >> 1 ) ) / RDS_LAMBDA;

        GraalZoomCenter( X1, Y1 );

        GraalSearchAbort = GRAAL_FALSE;

        GraalEnterPanel( &GraalEditSearchViewPanel ); 
        GraalLimitedLoop( GraalEditSearchViewPanel.PANEL );

        if ( GraalSearchAbort ) break;
      }

      GraalDelSearch();

      XtUnmanageChild( GraalEditSearchViewPanel.PANEL );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalEditSearchInstance                |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSearchInstance( InstanceName )

    char *InstanceName;
  {
    graalsearch *Search;
    rdsins_list *Instance;
    rdsrec_list *Rec;
    long         X1;
    long         Y1;

    if ( GraalFigureMbk == (phfig_list *)NULL ) return;

    for ( Instance  = GraalFigureRds->INSTANCE;
          Instance != (rdsins_list *)NULL;
          Instance  = Instance->NEXT )
    {
      if ( ( ! IsGraalDeleted( Instance->LAYERTAB[ RDS_ABOX ] ) ) &&
           ( Instance->INSNAME == InstanceName                  ) )
      {
        GraalAddSearch( Instance->LAYERTAB[ RDS_ABOX ] );
      }
    }

    if ( GraalHeadSearch == (graalsearch *)NULL )
    {
      GraalWarningMessage( GraalMainWindow, "No instance found !" );
    }
    else
    {
      for ( Search  = GraalHeadSearch;
            Search != (graalsearch *)NULL;
            Search  = Search->NEXT )
      {
        Rec = Search->RECTANGLE;

        X1 = ( Rec->X + ( Rec->DX >> 1 ) ) / RDS_LAMBDA;
        Y1 = ( Rec->Y + ( Rec->DY >> 1 ) ) / RDS_LAMBDA;

        GraalZoomCenter( X1, Y1 );

        GraalSearchAbort = GRAAL_FALSE;

        GraalEnterPanel( &GraalEditSearchViewPanel ); 
        GraalLimitedLoop( GraalEditSearchViewPanel.PANEL );

        if ( GraalSearchAbort ) break;
      }

      GraalDelSearch();

      XtUnmanageChild( GraalEditSearchViewPanel.PANEL );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalEditSearchSegment                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSearchSegment( SegmentName )

    char *SegmentName;
  {
    graalsearch *Search;
    rdsins_list *Instance;
    rdsfig_list *Figure;
    rdsrec_list *Rec;
    char         Layer;
    long         X1;
    long         Y1;

    if ( GraalFigureMbk == (phfig_list *)NULL ) return;

    for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
    {
      for ( Rec  = GraalFigureRds->LAYERTAB[ Layer ];
            Rec != (rdsrec_list *)NULL;
            Rec  = Rec->NEXT )
      {
        if ( ( ! IsGraalDeleted( Rec )  ) &&
             ( IsRdsSegment( Rec )      ) &&
             ( Rec->NAME == SegmentName ) )
        {
          GraalAddSearch( Rec );
        }
      }
    }

    for ( Instance  = GraalFigureRds->INSTANCE;
          Instance != (rdsins_list *)NULL;
          Instance  = Instance->NEXT )
    {
      if ( IsGraalDeleted( Instance->LAYERTAB[ RDS_ABOX ] ) ) 

          continue;

      for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
      {
        for ( Rec  = Instance->LAYERTAB[ Layer ];
              Rec != (rdsrec_list *)NULL;
              Rec  = Rec->NEXT )
        {
          if ( ( IsRdsSegment( Rec )      ) &&
               ( Rec->NAME == SegmentName ) )
          {
            GraalAddSearch( Rec );
          }
        }  
      }  
    }

    if ( GraalHeadSearch == (graalsearch *)NULL )
    {
      GraalWarningMessage( GraalMainWindow, "No segment found !" );
    }
    else
    {
      for ( Search  = GraalHeadSearch;
            Search != (graalsearch *)NULL;
            Search  = Search->NEXT )
      {
        Rec = Search->RECTANGLE;

        X1 = ( Rec->X + ( Rec->DX >> 1 ) ) / RDS_LAMBDA;
        Y1 = ( Rec->Y + ( Rec->DY >> 1 ) ) / RDS_LAMBDA;

        GraalZoomCenter( X1, Y1 );

        GraalSearchAbort = GRAAL_FALSE;

        GraalEnterPanel( &GraalEditSearchViewPanel ); 
        GraalLimitedLoop( GraalEditSearchViewPanel.PANEL );

        if ( GraalSearchAbort ) break;
      }

      GraalDelSearch();

      XtUnmanageChild( GraalEditSearchViewPanel.PANEL );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalEditSearchReference               |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSearchReference( ReferenceName )

    char *ReferenceName;
  {
    graalsearch *Search;
    rdsins_list *Instance;
    rdsfig_list *Figure;
    rdsrec_list *Rec;
    char         Layer;
    long         X1;
    long         Y1;

    if ( GraalFigureMbk == (phfig_list *)NULL ) return;

    for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
    {
      for ( Rec  = GraalFigureRds->LAYERTAB[ Layer ];
            Rec != (rdsrec_list *)NULL;
            Rec  = Rec->NEXT )
      {
        if ( ( ! IsGraalDeleted( Rec )    ) &&
             ( IsRdsReference( Rec )      ) &&
             ( Rec->NAME == ReferenceName ) )
        {
          GraalAddSearch( Rec );
        }
      }
    }

    for ( Instance  = GraalFigureRds->INSTANCE;
          Instance != (rdsins_list *)NULL;
          Instance  = Instance->NEXT )
    {
      if ( IsGraalDeleted( Instance->LAYERTAB[ RDS_ABOX ] ) ) 

          continue;

      for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
      {
        for ( Rec  = Instance->LAYERTAB[ Layer ];
              Rec != (rdsrec_list *)NULL;
              Rec  = Rec->NEXT )
        {
          if ( ( IsRdsReference( Rec )      ) &&
               ( Rec->NAME == ReferenceName ) )
          {
            GraalAddSearch( Rec );
          }
        }  
      }  
    }

    if ( GraalHeadSearch == (graalsearch *)NULL )
    {
      GraalWarningMessage( GraalMainWindow, "No reference found !" );
    }
    else
    {
      for ( Search  = GraalHeadSearch;
            Search != (graalsearch *)NULL;
            Search  = Search->NEXT )
      {
        Rec = Search->RECTANGLE;

        X1 = ( Rec->X + ( Rec->DX >> 1 ) ) / RDS_LAMBDA;
        Y1 = ( Rec->Y + ( Rec->DY >> 1 ) ) / RDS_LAMBDA;

        GraalZoomCenter( X1, Y1 );

        GraalSearchAbort = GRAAL_FALSE;

        GraalEnterPanel( &GraalEditSearchViewPanel ); 
        GraalLimitedLoop( GraalEditSearchViewPanel.PANEL );

        if ( GraalSearchAbort ) break;
      }

      GraalDelSearch();

      XtUnmanageChild( GraalEditSearchViewPanel.PANEL );
    }
  }

