/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Select.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GME_H
# include GMT_H

# include "GME_select.h"
# include "GME_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Select Buffer                       |
|                                                             |
\------------------------------------------------------------*/

  static char GraalSelectBuffer [ GRAAL_SELECT_BUFFER_SIZE  ];
  static graalselect *GraalCurrentSelect = (graalselect *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      GraalAddSelectList                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalAddSelectList( Rectangle )
 
    rdsrec_list *Rectangle;
  {
    void *Pointer;

    GraalSelectBuffer[0] = '\0';
    Pointer = GRAAL_MBK( Rectangle );

    if ( IsRdsSegment( Rectangle ) )
    {
      if ( ( ((phseg_list *)Pointer)->LAYER == NTRANS ) || 
           ( ((phseg_list *)Pointer)->LAYER == PTRANS ) )
      {
        sprintf( GraalSelectBuffer, 
        "  TRANSISTOR : %s",
        GRAAL_SEGMENT_NAME_TABLE[ ((phseg_list *)Pointer)->LAYER ][0] );
      }
      else
      {
        sprintf( GraalSelectBuffer, 
        "  SEGMENT %s : %s",
          ( Rectangle->NAME != (char *)NULL ) ? Rectangle->NAME : "None",
          GRAAL_SEGMENT_NAME_TABLE[ ((phseg_list *)Pointer)->LAYER ][0] );
      }
    }
    else
    if ( IsRdsConnector( Rectangle ) )
    {
      sprintf( GraalSelectBuffer,
      "  CONNECTOR %s : %s",
      ( Rectangle->NAME != (char *)NULL ) ? Rectangle->NAME : "None",
      GRAAL_CONNECTOR_NAME_TABLE[ ((phcon_list *)Pointer)->LAYER ][0] );
    }
    else
    if ( IsRdsVia( Rectangle ) )
    {
      sprintf( GraalSelectBuffer,
      "  VIA : %s",
      GRAAL_VIA_NAME_TABLE[ ((phvia_list *)Pointer)->TYPE ][0] );
    }
    else
    if ( IsRdsReference( Rectangle ) )
    {
      sprintf( GraalSelectBuffer,
      "  REFERENCE %s : %s",
      ( Rectangle->NAME != (char *)NULL ) ? Rectangle->NAME : "None",
      ( ! strcmp( ((phref_list *)Pointer)->FIGNAME, "ref_ref" ) ) ? "Ref_Ref" : "Ref_Con" );
    }
    else
    if ( IsRdsInstance( Rectangle ) )
    {
      sprintf( GraalSelectBuffer,
      "  INSTANCE %s : %s",
      ((phins_list *)Pointer)->INSNAME,
      ((phins_list *)Pointer)->FIGNAME );
    }
    if ( IsRdsFigure( Rectangle ) )
    {
      sprintf( GraalSelectBuffer,
      "  ABUTMENT BOX : %s",
      ((phfig_list *)Pointer)->NAME );
    }

    GraalDisplaySelectList( GraalSelectBuffer );
  }

/*------------------------------------------------------------\
|                                                             |
|                 GraalEditSelectRectangle                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSelectRectangle( Number )

    int Number;
  {
    int          Counter;
    graalselect *Select;

    Select = GraalHeadSelect;

    for ( Counter = 0; Counter < Number; Counter++ )
    {
      Select = Select->NEXT;
    }

    if ( ( GraalCurrentSelect != (graalselect *)NULL ) &&
         ( GraalCurrentSelect != Select              ) )
    {
      GraalRejectRectangle( GraalCurrentSelect->RECTANGLE );
      GraalDisplayRectangle( GraalCurrentSelect->RECTANGLE );
    }

    GraalAcceptRectangle( Select->RECTANGLE );
    GraalDisplayRectangle( Select->RECTANGLE );

    GraalCurrentSelect = Select;
  }

/*------------------------------------------------------------\
|                                                             |
|                 GraalEditSelectAccept                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSelectAccept()
  {
    GraalPurgeSelect();
    GraalCurrentSelect = (graalselect *)NULL;
  }

/*------------------------------------------------------------\
|                                                             |
|                 GraalEditSelectCancel                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSelectCancel()
  {
    if ( GraalCurrentSelect != (graalselect *)NULL )
    {
      GraalRejectRectangle( GraalCurrentSelect->RECTANGLE );
      GraalDisplayRectangle( GraalCurrentSelect->RECTANGLE );
      GraalCurrentSelect = (graalselect *)NULL;
    }

    GraalDelSelect();
  }

/*------------------------------------------------------------\
|                                                             |
|                       Select Functions                      |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     GraalEditUnselectAll                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditUnselectAll()
  {
    rdsrec_list *Rectangle;

    if ( GraalHeadSelect != (graalselect *)NULL )
    {
      if ( GraalHeadSelect->NEXT == (graalselect *)NULL )
      {
        Rectangle = GraalHeadSelect->RECTANGLE;
        GraalDelSelect();
        GraalDisplayRectangle( Rectangle );
      }
      else
      {
        GraalDelSelect();
        GraalZoomRefresh();
      }
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalEditSelectPoint                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSelectPoint( LambdaX1, LambdaY1 )

     long LambdaX1;
     long LambdaY1;
  {
    long         Offset;
    graalwin    *ScanWin;
    graalwinrec *ScanWinRec;
    rdsrec_list *Rec;
    rdsrec_list *CheckRec;
    graalselect *Select;
    char         ScanRec;
    char         Layer;
    long         X;
    long         Y;

    if ( GraalFigureMbk != (phfig_list *)NULL ) 
    {
      LambdaX1 = LambdaX1 * RDS_LAMBDA; 
      LambdaY1 = LambdaY1 * RDS_LAMBDA; 

      X = ( LambdaX1 - GraalWindowXmin ) / GraalWindowSide;
      Y = ( LambdaY1 - GraalWindowYmin ) / GraalWindowSide;

      Offset = Y * GraalWindowDx + X;

      if ( ( ScanWin = GraalWindowTable[ Offset ] ) != (graalwin *)NULL )
      {
        for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ ) 
        {
          if ( GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] == 0 ) continue; 
  
          for ( ScanWinRec  = ScanWin->LAYERTAB[ Layer ];
                ScanWinRec != (graalwinrec *)NULL;
                ScanWinRec  = ScanWinRec->NEXT )
          {
            for ( ScanRec = 0; ScanRec < GRAAL_MAX_REC ; ScanRec++ )
            {
              Rec = ScanWinRec->RECTAB[ ScanRec ];
  
              if ( ( Rec != (rdsrec_list *)NULL        ) &&
                   ( ! IsGraalDeleted( Rec )           ) &&
                   ( ! IsGraalCut( Rec )               ) &&
                   ( ! IsGraalSelected( Rec )          ) &&
                   ( Rec->X               <=  LambdaX1 ) &&
                   ( Rec->Y               <=  LambdaY1 ) &&
                   ( ( Rec->X + Rec->DX ) >=  LambdaX1 ) &&
                   ( ( Rec->Y + Rec->DY ) >=  LambdaY1 ) )
              {
                if ( IsRdsFigRec( Rec ) )
                {
                  if ( Layer == RDS_ABOX )
                  {
                    if ( (   Rec->X             == LambdaX1 ) ||
                         ( ( Rec->X + Rec->DX ) == LambdaX1 ) )
                    {
                      if ( ( LambdaY1 <     Rec->Y           ) ||
                           ( LambdaY1 > ( Rec->Y + Rec->DY ) ) )
          
                        continue;
                    }
                    else
                    if ( (   Rec->Y             == LambdaY1 ) ||
                         ( ( Rec->Y + Rec->DY ) == LambdaY1 ) )
                    {
                      if ( ( LambdaX1 <   Rec->X             ) ||
                           ( LambdaX1 > ( Rec->X + Rec->DX ) ) )
          
                        continue;
                    }
                    else continue;
                  }

                  CheckRec = (rdsrec_list *)Rec->USER;

                  while ( Rec != CheckRec )
                  {
                    if ( GRAAL_RDS_ACTIVE_LAYER_TABLE[ GetRdsLayer( CheckRec ) ] == 0 )

                     break;
                    
                    CheckRec = (rdsrec_list *)CheckRec->USER;
                  }

                  if ( Rec == CheckRec )
                  {
                    GraalAddSelect( Rec );
                  }
                }
                else
                {
                  if ( Layer == RDS_ABOX )
                  {
                    GraalAddSelect( Rec );
                  }
                }
              }
            }
          }
        }
      }

      for ( Select  = GraalHeadSelect;
            Select != (graalselect *)NULL;
            Select  = Select->NEXT )
      {
        GraalUnselectRectangle( Select->RECTANGLE );
      }
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalEditSelectWindow                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSelectWindow( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

    long LambdaX1;
    long LambdaY1;
    long LambdaX2;
    long LambdaY2;
  {
    long         Offset;
    graalwin    *ScanWin;
    graalwinrec *ScanWinRec;
    rdsrec_list *Rec;
    rdsrec_list *CheckRec;
    graalselect *Select;
    char         ScanRec;
    char         Layer;
    long         Xmin;
    long         Ymin;
    long         Xmax;
    long         Ymax;
    long         X;
    long         Y;
    long         Swap;

    if ( ( LambdaX1 != LambdaX2 ) &&
         ( LambdaY1 != LambdaY2 ) )
    {
      if ( LambdaX1 > LambdaX2 )
      {
        Swap = LambdaX1; LambdaX1 = LambdaX2; LambdaX2 = Swap;
      }

      if ( LambdaY1 > LambdaY2 )
      {
        Swap = LambdaY1; LambdaY1 = LambdaY2; LambdaY2 = Swap;
      }
    }

    if ( GraalFigureMbk != (phfig_list *)NULL )
    {
      LambdaX1 = LambdaX1 * RDS_LAMBDA; 
      LambdaX2 = LambdaX2 * RDS_LAMBDA; 
      LambdaY1 = LambdaY1 * RDS_LAMBDA; 
      LambdaY2 = LambdaY2 * RDS_LAMBDA; 

      Xmin = ( LambdaX1 - GraalWindowXmin ) / GraalWindowSide;
      Xmax = ( LambdaX2 - GraalWindowXmin ) / GraalWindowSide;
      Ymin = ( LambdaY1 - GraalWindowYmin ) / GraalWindowSide;
      Ymax = ( LambdaY2 - GraalWindowYmin ) / GraalWindowSide;

      for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ ) 
      {
        if ( GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] == 0 ) continue; 

        Y = Ymin;

        while ( Y <= Ymax )
        {
          X = Xmin;

          while ( X <= Xmax )
          {
            Offset = ( Y * GraalWindowDx ) + X;

            if ( ( ScanWin = GraalWindowTable[ Offset ] ) != (graalwin *)NULL )
            {
              for ( ScanWinRec  = ScanWin->LAYERTAB[ Layer ];
                    ScanWinRec != (graalwinrec *)NULL;
                    ScanWinRec  = ScanWinRec->NEXT )
              {
                for ( ScanRec = 0; ScanRec < GRAAL_MAX_REC ; ScanRec++ )
                {
                  Rec = ScanWinRec->RECTAB[ ScanRec ];

                  if ( ( Rec != (rdsrec_list *)NULL        ) &&
                       ( ! IsGraalDeleted( Rec )           ) &&
                       ( ! IsGraalCut( Rec )               ) &&
                       ( ! IsGraalAccepted( Rec )          ) &&
                       ( ! IsGraalSelected( Rec )          ) &&
                       ( Rec->X               >=  LambdaX1 ) &&
                       ( Rec->Y               >=  LambdaY1 ) &&
                       ( ( Rec->X + Rec->DX ) <=  LambdaX2 ) &&
                       ( ( Rec->Y + Rec->DY ) <=  LambdaY2 ) )
                  {
                    if ( ( IsRdsFigRec( Rec   ) ) || 
                         ( IsRdsInstance( Rec ) ) )
                    {
                      CheckRec = (rdsrec_list *)Rec->USER;

                      while ( Rec != CheckRec )
                      {
                        if ( GRAAL_RDS_ACTIVE_LAYER_TABLE[ GetRdsLayer( CheckRec ) ] == 0 )

                         break;

                        CheckRec = (rdsrec_list *)CheckRec->USER;
                      }

                      if ( Rec == CheckRec ) GraalAddSelect( Rec );
                    }
                  }
                }
              }
            }

            X = X + 1;
          }
  
          Y = Y + 1;
        }
      }

      for ( Select  = GraalHeadSelect;
            Select != (graalselect *)NULL;
            Select  = Select->NEXT )
      {
        GraalUnselectRectangle( Select->RECTANGLE );
      }
    }   
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalEditSelectFence                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalEditSelectFence( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

    long LambdaX1;
    long LambdaY1;
    long LambdaX2;
    long LambdaY2;
  {
    long         Offset;
    graalwin    *ScanWin;
    graalwinrec *ScanWinRec;
    rdsrec_list *Rec;
    rdsrec_list *CheckRec;
    graalselect *Select;
    char         ScanRec;
    char         Layer;
    long         Xmin;
    long         Ymin;
    long         Xmax;
    long         Ymax;
    long         X;
    long         Y;
    long         Swap;

    if ( ( LambdaX1 != LambdaX2 ) &&
         ( LambdaY1 != LambdaY2 ) )
    {
      if ( LambdaX1 > LambdaX2 )
      {
        Swap = LambdaX1; LambdaX1 = LambdaX2; LambdaX2 = Swap;
      }

      if ( LambdaY1 > LambdaY2 )
      {
        Swap = LambdaY1; LambdaY1 = LambdaY2; LambdaY2 = Swap;
      }
    }

    if ( GraalFigureMbk != (phfig_list *)NULL )
    {
      LambdaX1 = LambdaX1 * RDS_LAMBDA; 
      LambdaX2 = LambdaX2 * RDS_LAMBDA; 
      LambdaY1 = LambdaY1 * RDS_LAMBDA; 
      LambdaY2 = LambdaY2 * RDS_LAMBDA; 

      Xmin = ( LambdaX1 - GraalWindowXmin ) / GraalWindowSide;
      Xmax = ( LambdaX2 - GraalWindowXmin ) / GraalWindowSide;
      Ymin = ( LambdaY1 - GraalWindowYmin ) / GraalWindowSide;
      Ymax = ( LambdaY2 - GraalWindowYmin ) / GraalWindowSide;

      for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ ) 
      {
        if ( GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] == 0 ) continue; 

        Y = Ymin;

        while ( Y <= Ymax )
        {
          X = Xmin;

          while ( X <= Xmax )
          {
            Offset = ( Y * GraalWindowDx ) + X;

            if ( ( ScanWin = GraalWindowTable[ Offset ] ) != (graalwin *)NULL )
            {
              for ( ScanWinRec  = ScanWin->LAYERTAB[ Layer ];
                    ScanWinRec != (graalwinrec *)NULL;
                    ScanWinRec  = ScanWinRec->NEXT )
              {
                for ( ScanRec = 0; ScanRec < GRAAL_MAX_REC ; ScanRec++ )
                {
                  Rec = ScanWinRec->RECTAB[ ScanRec ];

                  if ( ( Rec != (rdsrec_list *)NULL        ) &&
                       ( ! IsGraalDeleted( Rec )           ) &&
                       ( ! IsGraalCut( Rec )               ) &&
                       ( ! IsGraalAccepted( Rec )          ) &&
                       ( ! IsGraalSelected( Rec )          ) &&
                       ( ( Rec->X + Rec->DX ) >=  LambdaX1 ) &&
                       ( ( Rec->Y + Rec->DY ) >=  LambdaY1 ) &&
                       ( ( Rec->X           ) <=  LambdaX2 ) &&
                       ( ( Rec->Y           ) <=  LambdaY2 ) )
                  {
                    if ( ( IsRdsFigRec( Rec   ) ) || 
                         ( IsRdsInstance( Rec ) ) )
                    {
                      CheckRec = (rdsrec_list *)Rec->USER;

                      while ( Rec != CheckRec )
                      {
                        if ( GRAAL_RDS_ACTIVE_LAYER_TABLE[ GetRdsLayer( CheckRec ) ] == 0 )

                         break;

                        CheckRec = (rdsrec_list *)CheckRec->USER;
                      }

                      if ( Rec == CheckRec ) GraalAddSelect( Rec );
                    }
                  }
                }
              }
            }

            X = X + 1;
          }
  
          Y = Y + 1;
        }
      }

      for ( Select  = GraalHeadSelect;
            Select != (graalselect *)NULL;
            Select  = Select->NEXT )
      {
        GraalUnselectRectangle( Select->RECTANGLE );
      }
    }
  }


/*------------------------------------------------------------\
|                                                             |
|                  GraalEditSelectPointCopy                   |
|                                                             |
\------------------------------------------------------------*/

 void GraalEditSelectPointCopy( LambdaX1, LambdaY1 )

    long LambdaX1;
    long LambdaY1;
 {
   graalselect  *Select;
   graalselect  *DelSelect;
   graalselect **Previous;

   GraalEditSelectPoint( LambdaX1, LambdaY1 );

   GraalDisplaySelectList( (char *)NULL );

   Previous = &GraalHeadSelect;
   Select   = GraalHeadSelect;

   while ( Select != (graalselect *)NULL )
   {
     if ( IsRdsFigure( Select->RECTANGLE   ) ||
          IsRdsInstance( Select->RECTANGLE ) )
     {
       DelSelect = Select;
       Select    = Select->NEXT;
       *Previous = Select;

       GraalFreeSelect( DelSelect );
     }
     else
     {
       GraalAddSelectList( Select->RECTANGLE );

       Previous = &Select->NEXT;
       Select   = Select->NEXT;
     }
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );
   }
   else
   {
     if ( GraalHeadSelect->NEXT != (graalselect *)NULL )
     {
       GraalEnterPanel( &GraalEditSelectPanel );
       GraalLimitedLoop( GraalEditSelectPanel.PANEL );
     }
     else
     {
       GraalAcceptRectangle( GraalHeadSelect->RECTANGLE );
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }

     if ( GraalHeadSelect != (graalselect *)NULL )
     {
       GraalContinueEditMode( GRAAL_EDIT_COPY_POINT,
                              GraalPromptEditCopy, 1 );
     }
     else
     {
       GraalChangeEditMode( GRAAL_SELECT_POINT_COPY,
                            GraalPromptSelectPointCopy );
     }
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                 GraalEditSelectWindowCopy                   |
|                                                             |
\------------------------------------------------------------*/

 void GraalEditSelectWindowCopy( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

    long LambdaX1;
    long LambdaY1;
    long LambdaX2;
    long LambdaY2;
 {
   graalselect  *Select;
   graalselect  *DelSelect;
   graalselect **Previous;

   GraalEditSelectWindow( LambdaX1, LambdaY1, LambdaX2, LambdaY2 );

   Previous = &GraalHeadSelect;
   Select   = GraalHeadSelect;

   while ( Select != (graalselect *)NULL )
   {
     if ( IsRdsFigure( Select->RECTANGLE   ) ||
          IsRdsInstance( Select->RECTANGLE ) )
     {
       DelSelect = Select;
       Select    = Select->NEXT;
       *Previous = Select;

       GraalFreeSelect( DelSelect );
     }
     else
     {
       GraalAcceptRectangle( Select->RECTANGLE );

       Previous = &Select->NEXT;
       Select   = Select->NEXT;
     }
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );

     GraalChangeEditMode( GRAAL_SELECT_WINDOW_COPY,
                          GraalPromptSelectWindowCopy );
   }
   else
   {
     if ( GraalHeadSelect->NEXT == (graalselect *)NULL )
     {
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }
     else
     {
       GraalZoomRefresh();
     }

     GraalContinueEditMode( GRAAL_EDIT_COPY_WINDOW,
                            GraalPromptEditCopy, 0 );
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                  GraalEditSelectPointMove                   |
|                                                             |
\------------------------------------------------------------*/

 void GraalEditSelectPointMove( LambdaX1, LambdaY1 )

    long LambdaX1;
    long LambdaY1;
 {
   graalselect  *Select;

   GraalEditSelectPoint( LambdaX1, LambdaY1 );

   GraalDisplaySelectList( (char *)NULL );

   for ( Select  = GraalHeadSelect;
         Select != (graalselect *)NULL;
         Select  = Select->NEXT )
   {
     GraalAddSelectList( Select->RECTANGLE );
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );
   }
   else
   {
     if ( GraalHeadSelect->NEXT != (graalselect *)NULL )
     {
       GraalEnterPanel( &GraalEditSelectPanel );
       GraalLimitedLoop( GraalEditSelectPanel.PANEL );
     }
     else
     {
       GraalAcceptRectangle( GraalHeadSelect->RECTANGLE );
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }

     if ( GraalHeadSelect != (graalselect *)NULL )
     {
       GraalContinueEditMode( GRAAL_EDIT_MOVE_POINT,
                              GraalPromptEditMove, 1 );
     }
     else
     {
       GraalChangeEditMode( GRAAL_SELECT_POINT_MOVE,
                            GraalPromptSelectPointMove );
     }
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                 GraalEditSelectWindowMove                   |
|                                                             |
\------------------------------------------------------------*/

 void GraalEditSelectWindowMove( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

    long LambdaX1;
    long LambdaY1;
    long LambdaX2;
    long LambdaY2;
 {
   graalselect  *Select;

   GraalEditSelectWindow( LambdaX1, LambdaY1, LambdaX2, LambdaY2 );

   for ( Select  = GraalHeadSelect;
         Select != (graalselect *)NULL;
         Select  = Select->NEXT )
   {
     GraalAcceptRectangle( Select->RECTANGLE );
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );

     GraalChangeEditMode( GRAAL_SELECT_WINDOW_MOVE,
                          GraalPromptSelectWindowMove );
   }
   else
   {
     if ( GraalHeadSelect->NEXT == (graalselect *)NULL )
     {
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }
     else
     {
       GraalZoomRefresh();
     }

     GraalContinueEditMode( GRAAL_EDIT_MOVE_WINDOW,
                            GraalPromptEditMove, 0 );
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                  GraalEditSelectPointDelete                 |
|                                                             |
\------------------------------------------------------------*/

 void GraalEditSelectPointDelete( LambdaX1, LambdaY1 )

    long LambdaX1;
    long LambdaY1;
 {
   graalselect  *Select;

   GraalEditSelectPoint( LambdaX1, LambdaY1 );

   GraalDisplaySelectList( (char *)NULL );

   for ( Select  = GraalHeadSelect;
         Select != (graalselect *)NULL;
         Select  = Select->NEXT )
   {
     GraalAddSelectList( Select->RECTANGLE );
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );
   }
   else
   {
     if ( GraalHeadSelect->NEXT != (graalselect *)NULL )
     {
       GraalEnterPanel( &GraalEditSelectPanel );
       GraalLimitedLoop( GraalEditSelectPanel.PANEL );
     }
     else
     {
       GraalAcceptRectangle( GraalHeadSelect->RECTANGLE );
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }
 
     if ( GraalHeadSelect != (graalselect *)NULL ) 
     {
       GraalEditDelete();
     }
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                 GraalEditSelectWindowDelete                 |
|                                                             |
\------------------------------------------------------------*/

 void GraalEditSelectWindowDelete( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

    long LambdaX1;
    long LambdaY1;
    long LambdaX2;
    long LambdaY2;
 {
   graalselect  *Select;

   GraalEditSelectWindow( LambdaX1, LambdaY1, LambdaX2, LambdaY2 );

   for ( Select  = GraalHeadSelect;
         Select != (graalselect *)NULL;
         Select  = Select->NEXT )
   {
     GraalAcceptRectangle( Select->RECTANGLE );
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );
   }
   else
   {
     if ( GraalHeadSelect->NEXT == (graalselect *)NULL )
     {
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }
     else
     {
       GraalZoomRefresh();
     }

     GraalEditDelete();
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                  GraalEditSelectPointStretch                |
|                                                             |
\------------------------------------------------------------*/

 void GraalEditSelectPointStretch( LambdaX1, LambdaY1 )

    long LambdaX1;
    long LambdaY1;
 {
   graalselect  *Select;
   graalselect  *DelSelect;
   graalselect **Previous;

   GraalEditSelectPoint( LambdaX1, LambdaY1 );

   GraalDisplaySelectList( (char *)NULL );

   Previous = &GraalHeadSelect;
   Select   = GraalHeadSelect;

   while ( Select != (graalselect *)NULL )
   {
     if ( ( IsRdsSegment( Select->RECTANGLE ) ) ||
          ( IsRdsFigure( Select->RECTANGLE )  ) )
     {
       GraalAddSelectList( Select->RECTANGLE );

       Previous = &Select->NEXT;
       Select   = Select->NEXT;
     }
     else
     {
       DelSelect = Select;
       Select    = Select->NEXT;
       *Previous = Select;

       GraalFreeSelect( DelSelect );
     }
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );
   }
   else
   {
     if ( GraalHeadSelect->NEXT != (graalselect *)NULL )
     {
       GraalEnterPanel( &GraalEditSelectPanel );
       GraalLimitedLoop( GraalEditSelectPanel.PANEL );
     }
     else
     {
       GraalAcceptRectangle( GraalHeadSelect->RECTANGLE );
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }

     if ( GraalHeadSelect != (graalselect *)NULL )
     {
       GraalContinueEditMode( GRAAL_EDIT_STRETCH_POINT,
                              GraalPromptEditStretch, 1 );
     }
     else
     {
       GraalChangeEditMode( GRAAL_SELECT_POINT_STRETCH,
                            GraalPromptSelectPointStretch );
     }
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                  GraalEditSelectPointModify                 |
|                                                             |
\------------------------------------------------------------*/

 void GraalEditSelectPointModify( LambdaX1, LambdaY1 )

    long LambdaX1;
    long LambdaY1;
 {
   graalselect  *Select;
   graalselect  *DelSelect;
   graalselect **Previous;

   GraalEditSelectPoint( LambdaX1, LambdaY1 );

   GraalDisplaySelectList( (char *)NULL );

   Previous = &GraalHeadSelect;
   Select   = GraalHeadSelect;

   while ( Select != (graalselect *)NULL )
   {
     if ( ! IsRdsFigure( Select->RECTANGLE   ) )
     {
       GraalAddSelectList( Select->RECTANGLE );

       Previous = &Select->NEXT;
       Select   = Select->NEXT;
     }
     else
     {
       DelSelect = Select;
       Select    = Select->NEXT;
       *Previous = Select;

       GraalFreeSelect( DelSelect );
     }
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );
   }
   else
   {
     if ( GraalHeadSelect->NEXT != (graalselect *)NULL )
     {
       GraalEnterPanel( &GraalEditSelectPanel );
       GraalLimitedLoop( GraalEditSelectPanel.PANEL );
     }

     if ( GraalHeadSelect != (graalselect *)NULL )
     {
       GraalEditModify();
     }
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                 GraalEditSelectWindowModify                 |
|                                                             |
\------------------------------------------------------------*/

 void GraalEditSelectWindowModify( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

    long LambdaX1;
    long LambdaY1;
    long LambdaX2;
    long LambdaY2;
 {
   graalselect  *Select;
   graalselect  *DelSelect;
   graalselect **Previous;

   GraalEditSelectWindow( LambdaX1, LambdaY1, LambdaX2, LambdaY2 );

   Previous = &GraalHeadSelect;
   Select   = GraalHeadSelect;

   while ( Select != (graalselect *)NULL )
   {
     if ( ! IsRdsFigure( Select->RECTANGLE   ) )
     {
       Previous = &Select->NEXT;
       Select   = Select->NEXT;
     }
     else
     {
       DelSelect = Select;
       Select    = Select->NEXT;
       *Previous = Select;

       GraalFreeSelect( DelSelect );
     }
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );
   }
   else
   {
     GraalEditModify();
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                  GraalToolsSelectEqui                       |
|                                                             |
\------------------------------------------------------------*/

 void GraalToolsSelectEqui( LambdaX1, LambdaY1 )

    long LambdaX1;
    long LambdaY1;
 {
   graalselect  *Select;
   graalselect  *DelSelect;
   graalselect **Previous;
   void         *Pointer;
   char          Delete;

   GraalEditSelectPoint( LambdaX1, LambdaY1 );

   GraalDisplaySelectList( (char *)NULL );

   Previous = &GraalHeadSelect;
   Select   = GraalHeadSelect;

   while ( Select != (graalselect *)NULL )
   {
     Delete = 0;

     if ( IsRdsSegment( Select->RECTANGLE ) )
     {
       Pointer = GRAAL_MBK( Select->RECTANGLE );

       if ( (((phseg_list *)Pointer)->LAYER == NTRANS ) ||
            (((phseg_list *)Pointer)->LAYER == PTRANS ) )

         Delete = 1;
     }
     else
     if ( IsRdsVia( Select->RECTANGLE ) )
     {
       Pointer = GRAAL_MBK( Select->RECTANGLE );

       if ( (((phvia_list *)Pointer)->TYPE == C_X_N ) ||
            (((phvia_list *)Pointer)->TYPE == C_X_P ) )

         Delete = 1;
     }
     else
     if ( ( IsRdsInstance( Select->RECTANGLE ) ) ||
          ( IsRdsFigure( Select->RECTANGLE )   ) )

        Delete = 1;

     if ( Delete )
     {
       DelSelect = Select;
       Select    = Select->NEXT;
       *Previous = Select;

       GraalFreeSelect( DelSelect );
     }
     else
     {
       GraalAddSelectList( Select->RECTANGLE );

       Previous = &Select->NEXT;
       Select   = Select->NEXT;
     }
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No element found !" );
   }
   else
   {
     if ( GraalHeadSelect->NEXT != (graalselect *)NULL )
     {
       GraalEnterPanel( &GraalEditSelectPanel );
       GraalLimitedLoop( GraalEditSelectPanel.PANEL );
     }
     else
     {
       GraalAcceptRectangle( GraalHeadSelect->RECTANGLE );
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }

     if ( GraalHeadSelect != (graalselect *)NULL )
     {
       GraalToolsEqui();
     }
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                 GraalToolsSelectFlatten                     |
|                                                             |
\------------------------------------------------------------*/

 void GraalToolsSelectFlatten( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

    long LambdaX1;
    long LambdaY1;
    long LambdaX2;
    long LambdaY2;
 {
   graalselect  *Select;
   graalselect  *DelSelect;
   graalselect **Previous;

   GraalEditSelectFence( LambdaX1, LambdaY1, LambdaX2, LambdaY2 );

   Previous = &GraalHeadSelect;
   Select   = GraalHeadSelect;

   while ( Select != (graalselect *)NULL )
   {
     if ( ( ! IsRdsInstance( Select->RECTANGLE ) ) ||
          (  IsGraalFlatten( Select->RECTANGLE ) ) )
     {
       DelSelect = Select;
       Select    = Select->NEXT;
       *Previous = Select;

       GraalFreeSelect( DelSelect );
     }
     else
     {
       GraalAcceptRectangle( Select->RECTANGLE );

       Previous = &Select->NEXT;
       Select   = Select->NEXT;
     }
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No instance found !" );
   }
   else
   {
     if ( GraalHeadSelect->NEXT == (graalselect *)NULL )
     {
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }
     else
     {
       GraalZoomRefresh();
     }

     GraalToolsFlatten();
   }
 }

/*------------------------------------------------------------\
|                                                             |
|                 GraalToolsSelectUnflatten                   |
|                                                             |
\------------------------------------------------------------*/

 void GraalToolsSelectUnflatten( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

    long LambdaX1;
    long LambdaY1;
    long LambdaX2;
    long LambdaY2;
 {
   graalselect  *Select;
   graalselect  *DelSelect;
   graalselect **Previous;

   GraalEditSelectFence( LambdaX1, LambdaY1, LambdaX2, LambdaY2 );

   Previous = &GraalHeadSelect;
   Select   = GraalHeadSelect;

   while ( Select != (graalselect *)NULL )
   {
     if ( ( ! IsRdsInstance( Select->RECTANGLE  ) ) ||
          ( ! IsGraalFlatten( Select->RECTANGLE ) ) )
     {
       DelSelect = Select;
       Select    = Select->NEXT;
       *Previous = Select;

       GraalFreeSelect( DelSelect );
     }
     else
     {
       GraalAcceptRectangle( Select->RECTANGLE );

       Previous = &Select->NEXT;
       Select   = Select->NEXT;
     }
   }

   if ( GraalHeadSelect == (graalselect *)NULL  )
   {
     GraalWarningMessage( GraalMainWindow, "No instance found !" );
   }
   else
   {
     if ( GraalHeadSelect->NEXT == (graalselect *)NULL )
     {
       GraalDisplayRectangle( GraalHeadSelect->RECTANGLE );
     }
     else
     {
       GraalZoomRefresh();
     }

     GraalToolsUnflatten();
   }
 }
