/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                 Dialog.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>
# include <Xm/FileSB.h>
# include <Xm/SelectioB.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GMF_H

# include "GMF_dialog.h"
# include "GMF_file.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          File Dialog                        |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalFileOpenDialog =

  {
    "Open File",
    GRAAL_DIALOG_FILE,
    (Widget)NULL,
    (void *)CallbackFileOpenOk,
    (XtPointer)NULL,
    (void *)CallbackFileOpenCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalFileQuitDialog =

  {
    "Do you really want to quit Graal ?",
    GRAAL_DIALOG_WARNING,
    (Widget)NULL,
    (void *)CallbackFileQuitOk,
    (XtPointer)NULL,
    (void *)CallbackFileQuitCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalFileSaveAsDialog =

  {
    "Save As",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackFileSaveAsOk,
    (XtPointer)NULL,
    (void *)CallbackFileSaveAsCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                  GraalBuildFileDialog                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalBuildFileDialog()

  {
    GraalBuildDialog( GraalMainWindow, &GraalFileSaveAsDialog );
    GraalBuildDialog( GraalMainWindow, &GraalFileOpenDialog   );
    GraalBuildDialog( GraalMainWindow, &GraalFileQuitDialog   );
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackFileQuitOk                         |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileQuitOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      caddr_t                       CallData;
  {
    GraalExitDialog();

    if ( GraalHeadUndo != (graalundo *)NULL )
    { 
      CallbackFileSaveAs( NULL, NULL, NULL );
    }

    XtCloseDisplay( XtDisplay( XtParent( MyWidget ) ) );

    exit( 0 );
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackFileQuitCancel                     |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileQuitCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      caddr_t                       CallData;
  {
    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackFileSaveAsOk                       |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileSaveAsOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *FileName;

    XmStringGetLtoR(  CallData->value, 
                      XmSTRING_DEFAULT_CHARSET, 
                     &FileName );

    FileName = GraalPostTreatString( FileName );

    XtUnmanageChild( GraalFileSaveAsDialog.WIDGET );

    GraalExitDialog();

    GraalFileSaveAs( FileName );
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackFileSaveAsCancel                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileSaveAsCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalFileSaveAsDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackFileOpenOk                       |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileOpenOk( MyWidget, ClientData, FileStruct )

      Widget                            MyWidget;
      caddr_t                           ClientData;
      XmFileSelectionBoxCallbackStruct *FileStruct;
  {
    char *FileName;

    XtUnmanageChild( GraalFileOpenDialog.WIDGET );

    GraalExitDialog();

    if ( FileStruct->value != NULL )
    {
      XmStringGetLtoR( FileStruct->value,
                       XmSTRING_DEFAULT_CHARSET,
                       &FileName 
                     );

      FileName = GraalPostTreatString( FileName ); 

      if ( FileName != (char *)NULL )
      {
        if ( GraalHeadUndo != (graalundo *)NULL )
        {
          CallbackFileSaveAs( NULL, NULL, NULL );
        }

        GraalFileOpen( FileName );

        GraalChangeEditMode( GRAAL_EDIT_MEASURE, 
                             GraalPromptEditMeasure );
      }
      else
      {
        GraalErrorMessage( GraalMainWindow, "Unable to load this file !" );
      }
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackFileOpenCancel                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileOpenCancel( MyWidget, ClientData, FileStruct )

      Widget                            MyWidget;
      caddr_t                           ClientData;
      XmFileSelectionBoxCallbackStruct *FileStruct;
  {
    XtUnmanageChild( GraalFileOpenDialog.WIDGET );

    GraalExitDialog();
  }
