/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   File.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>
# include <Xm/FileSB.h>
# include <Xm/SelectioB.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GMF_H

# include "GMF_file.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
 
  char *GRAAL_WORK_LIB = (char *)NULL;

  char GraalFileFilter[ 10 ]    = "*.";
  char GraalFileExtention[ 10 ] = ".";

  char GraalFileBuffer[ 128 ];
  char GraalDirectoryBuffer[ 512 ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        GraalFileNew                         |
|                                                             |
\------------------------------------------------------------*/

  void GraalFileNew()
  {
    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_WATCH_CURSOR  );

    if ( GraalFigureMbk != (phfig_list *)NULL )
    {
      GraalDelEqui();
      GraalDelPeek();
      GraalDelSelect();
      GraalDelFigure();
    }

    GraalRecomputeBound = GRAAL_TRUE;

    GraalInitializeZoom();
    GraalInitializeUndo();
    GraalClearGraphicWindow( 0, 0, GraalGraphicDx, GraalGraphicDy );

    GraalRefreshGraphicWindow( 0, 0, 
                               GraalGraphicDx, GraalGraphicDy );

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_NORMAL_CURSOR );
  }

/*------------------------------------------------------------\
|                                                             |
|                        GraalFileSave                        |
|                                                             |
\------------------------------------------------------------*/

  void GraalFileSave()
  {
    char Ok;

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_WATCH_CURSOR  );

    Ok = GraalSaveFigure();

    GraalDisplayToolsMessage();

    if ( ! Ok )
    {
      GraalErrorMessage( GraalMainWindow, "Unable to save this figure !" );
    }

    GraalInitializeUndo();

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_NORMAL_CURSOR  );
  }

/*------------------------------------------------------------\
|                                                             |
|                        GraalFileSaveAs                      |
|                                                             |
\------------------------------------------------------------*/

  void GraalFileSaveAs( FileName )

     char *FileName;
  {
    rdsins_list *InstanceRds;
    char         Ok;

    if ( FileName == (char *)NULL ) 
    {
      FileName = GraalFigureMbk->NAME;
    }
    else
    {
      FileName = namealloc( FileName );
    }

    for ( InstanceRds  = GraalFigureRds->INSTANCE; 
          InstanceRds != (rdsins_list *)NULL;
          InstanceRds  = InstanceRds->NEXT )
    {
      if ( InstanceRds->FIGNAME == FileName ) break;
    }

    if ( InstanceRds != (rdsins_list *)NULL )
    {
      GraalErrorMessage( GraalMainWindow,
                         "A figure cannot be part of itself !" );
    }

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_WATCH_CURSOR );

    GraalFigureMbk->NAME = FileName;
    GraalFigureRds->NAME = FileName;

    if ( GraalFigureRds->LAYERTAB[ RDS_ABOX ] != (rdsrec_list *)NULL ) 
    {
      GraalFigureRds->LAYERTAB[ RDS_ABOX ]->NAME = FileName;
    }

    Ok = GraalSaveFigure();

    GraalDisplayToolsMessage();

    if ( ! Ok )
    {
      GraalErrorMessage( GraalMainWindow, "Unable to save this figure !" );
    }

    GraalInitializeUndo();

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_NORMAL_CURSOR );
  }

/*------------------------------------------------------------\
|                                                             |
|                        GraalFileOpen                        |
|                                                             |
\------------------------------------------------------------*/

  void GraalFileOpen( FileName )

    char *FileName;
  {
    char       *Directory;
    char       *File;
    int         Index;
    char       *SWAP_WORK_LIB = WORK_LIB;

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_WATCH_CURSOR  );
    GraalUndisplayCursor();

    if ( GraalFigureMbk != (phfig_list *)NULL )
    {
      GraalDelEqui();
      GraalDelPeek();
      GraalDelSelect();
      GraalInitializeUndo();
      GraalDelFigure();
    }

    GraalRecomputeBound = GRAAL_TRUE;

    if ( GRAAL_WORK_LIB == (char *)NULL )
    {
      GRAAL_WORK_LIB = WORK_LIB;
    }

    for ( Index = strlen( FileName ); Index >= 0; Index-- )
    {
      if ( FileName[ Index ] == '/' ) break;
    }
    
    if ( Index >= 0 ) 
    {
      strcpy( GraalDirectoryBuffer, FileName );
      strcpy( GraalFileBuffer, FileName + Index + 1);

      GraalDirectoryBuffer[ Index + 1 ] = '\0';

      WORK_LIB = GraalDirectoryBuffer;
    }
    else
    {
      strcpy( GraalFileBuffer, FileName );

      WORK_LIB = GRAAL_WORK_LIB;
    }

    Index = strlen( GraalFileBuffer ) - strlen( GraalFileExtention );

    if ( Index >= 0 )
    {
      if ( ! strcmp( GraalFileBuffer + Index, GraalFileExtention ) )
      {
        GraalFileBuffer[ Index ] = '\0';
      }
    }

    GraalFigureMbk = Graalgetphfig( GraalFileBuffer, 'A' );

    GraalInitializeUndo();

    GraalDisplayToolsMessage();

    if ( GraalFigureMbk == (phfig_list *)NULL )
    {
      GraalErrorMessage( GraalMainWindow, "Unable to open this figure !" );
      GraalInitializeZoom();
      GraalClearGraphicWindow( 0, 0, GraalGraphicDx, GraalGraphicDy );
    }
    else
    {
      GraalAddFigure();
      GraalInitializeZoom();
      GraalDisplayFigure( 0, 0, GraalGraphicDx, GraalGraphicDy );
    }

    GraalRefreshGraphicWindow( 0, 0,
                               GraalGraphicDx, GraalGraphicDy );

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_NORMAL_CURSOR );
    GraalDisplayCursor();

    WORK_LIB = SWAP_WORK_LIB;
  }
