/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Panel.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <string.h>
# include <Xm/Xm.h>
# include <Xm/Form.h>
# include <Xm/LabelG.h>
# include <Xm/Label.h>
# include <Xm/Frame.h>
# include <Xm/List.h>
# include <Xm/Text.h>
# include <Xm/PushB.h>
# include <Xm/FileSB.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GMF_H

# include "GMF_panel.h"
# include "GMF_dialog.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

   GraalPanelItem GraalLibraryPanel =

         {
           "Library",
           1,
           GRAAL_LIBRARY_X,
           GRAAL_LIBRARY_Y,
           250,
           375,
           0,
           0,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (GraalPanelButtonItem *)NULL
         };

   int GraalLibraryDefaultValues[ 4 ] =

         {
           GRAAL_LIBRARY_X,
           GRAAL_LIBRARY_Y,
           250, 375
         };

   static char **GRAAL_CATA_LIB    = (char **)NULL;
   static char  *GRAAL_WORK_LIB    = (char  *)NULL;
   static char  *GRAAL_DEFAULT_LIB = (char *)NULL;
 
   static char   GraalFirstLibrary = 1;

/*------------------------------------------------------------\
|                                                             |
|                            Buffer                           |
|                                                             |
\------------------------------------------------------------*/

  static char *LibraryBuffer = (char *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                    Widget For Library Panel                 |
|                                                             |
\------------------------------------------------------------*/

  Widget     GraalLibraryListLabel;
  Widget     GraalLibraryList;

  Widget     GraalLibraryButtonOk;
  Widget     GraalLibraryButtonUpdate;
  Widget     GraalLibraryButtonCancel;

  Widget     GraalLibraryCataLabel;
  Widget     GraalLibraryCata;

  Widget     GraalLibraryWorkLabel;
  Widget     GraalLibraryWork;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        GraalIsDirectory                     |
|                                                             |
\------------------------------------------------------------*/

  char GraalIsDirectory( FileName )

     char *FileName;
  {
    struct stat Buffer;

    if ( stat( FileName, &Buffer ) != -1 )
    {
      if ( ( Buffer.st_mode & S_IFMT ) == S_IFDIR ) 
      {
        return( 1 );
      }
    }

    return( 0 );
  }
 
/*------------------------------------------------------------\
|                                                             |
|                      GraalSetLibraryList                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalSetLibraryList()
  {
    int      Index;
    XmString Label;

    XmListDeleteAllItems( GraalLibraryList );

    for ( Index = 0;
          GRAAL_CATA_LIB[ Index ] != (char *)NULL;
          Index++ )
    {
      Label = XmStringCreateSimple( GRAAL_CATA_LIB[ Index ] );
      XmListAddItem( GraalLibraryList , Label , NULL );
      XmStringFree( Label );
    }

    Label = XmStringCreateSimple( GRAAL_WORK_LIB );
    XmListAddItem( GraalLibraryList , Label , NULL );
    XmStringFree( Label );

    GRAAL_DEFAULT_LIB = (char *)NULL;
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalSetWorkLibrary                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalSetWorkLibrary()
  {
    XmTextSetString( GraalLibraryWork, GRAAL_WORK_LIB );
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalSetCataLibrary                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalSetCataLibrary()
  {
    int   Index;
    long  Length;
    char *Buffer;
    char *Scan;

    for ( Index = 0, Length = 0; 
          GRAAL_CATA_LIB[ Index ] != (char *)NULL;
          Index++ )
    {
      Length = Length + strlen( GRAAL_CATA_LIB[ Index ] ) + 1;
    }
  
    Buffer = mbkalloc( Length + 1 );
    Scan   = Buffer;

    for ( Index = 0;
          GRAAL_CATA_LIB[ Index ] != (char *)NULL;
          Index++ )
    {
      strcpy( Scan, GRAAL_CATA_LIB[ Index ] );
      strcat( Scan, "\n" );

      Scan = Scan + strlen( Scan );
    }

    XmTextSetString( GraalLibraryCata, Buffer );

    mbkfree( Buffer );
  }
 
/*------------------------------------------------------------\
|                                                             |
|                     GraalInitializeLibrary                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeLibrary()
  {
    int Index;

    for ( Index = 0; CATA_LIB[ Index ] != (char *)NULL; Index++ );

    GRAAL_CATA_LIB = (char **)mbkalloc( sizeof(char *) * ( Index + 1 ));

    for ( Index = 0; 
          CATA_LIB[ Index ] != (char *)NULL;
          Index++ )
    {
      GRAAL_CATA_LIB[ Index ] = mbkalloc( strlen( CATA_LIB[ Index ] ) + 1 );
      strcpy( GRAAL_CATA_LIB[ Index ], CATA_LIB[ Index ] );
    }

    GRAAL_CATA_LIB[ Index ] = (char *)NULL;

    GRAAL_WORK_LIB = mbkalloc( strlen( WORK_LIB ) + 1 );
    strcpy( GRAAL_WORK_LIB, WORK_LIB );

    GraalSetCataLibrary();
    GraalSetWorkLibrary();
    GraalSetLibraryList();
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalGetCataLibrary                     |
|                                                             |
\------------------------------------------------------------*/

 void GraalGetCataLibrary()
 {
    char *NewCata;
    char *Scan;
    int   Index;
    int   Count;
    int   Length;

    for ( Index = 0; 
          GRAAL_CATA_LIB[ Index ] != (char *)NULL;
          Index++ )
    {
      mbkfree( GRAAL_CATA_LIB[ Index ] );
    }

    mbkfree( GRAAL_CATA_LIB );

    NewCata = XmTextGetString( GraalLibraryCata );

    Count = 1;

    for ( Index = 0; NewCata[ Index ] != '\0'; Index++ ) 
    {
      if ( NewCata[ Index ] == '\n' )
      {
        Count = Count + 1;
      }
    }

    GRAAL_CATA_LIB = (char **)mbkalloc( sizeof(char *) * ( Count + 1 ));

    Count = 0;
    Scan  = NewCata;

    for ( Index = 0; NewCata[ Index ] != '\0'; Index++ )
    {
      if ( NewCata[ Index ] == '\n' ) 
      {
        NewCata[ Index ] = '\0';

        Length = strlen( Scan );

        if ( ( Length > 0               ) &&
             ( GraalIsDirectory( Scan ) ) )
        {
          GRAAL_CATA_LIB[ Count ] = mbkalloc( Length + 1 );
          strcpy( GRAAL_CATA_LIB[ Count ], Scan );
          Count = Count + 1;
        }

        Scan  = NewCata + Index + 1;
      }
      else
      if ( NewCata[ Index ] == ' ' )
      {
        NewCata[ Index ] = '\0';
      }
    }
   
    Length = strlen( Scan );

    if ( Length > 0 )
    {
      GRAAL_CATA_LIB[ Count ] = mbkalloc( Length + 1 );
      strcpy( GRAAL_CATA_LIB[ Count ], Scan );
      Count = Count + 1;
    }

    GRAAL_CATA_LIB[ Count ] = (char *)NULL;
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalGetWorkLibrary                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalGetWorkLibrary()
  {
    char *NewWork;

    mbkfree( GRAAL_WORK_LIB );

    NewWork = XmTextGetString( GraalLibraryWork );

    if ( GraalIsDirectory( NewWork ) )
    {
      GRAAL_WORK_LIB = mbkalloc( strlen( NewWork ) + 1 );
      strcpy( GRAAL_WORK_LIB, NewWork );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackLibraryList                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackLibraryList( MyWidget, ClientData, CallData )

       Widget                MyWidget;
       caddr_t               ClientData;
       XmListCallbackStruct *CallData;
  {
    GRAAL_DEFAULT_LIB = GRAAL_CATA_LIB[ CallData->item_position - 1 ];

    if ( GRAAL_DEFAULT_LIB == (char *)NULL )
    {
      GRAAL_DEFAULT_LIB = GRAAL_WORK_LIB;
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                        CallbackLibraryOk                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackLibraryOk( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XmString Label;
    int      Index;

    XtUnmanageChild( GraalLibraryPanel.PANEL );
 
    GraalExitDialog();

    if ( GraalFirstLibrary == 0 )
    {
      for ( Index = 0;
            CATA_LIB[ Index ] != (char *)NULL;
            Index++ )
      {
        mbkfree( CATA_LIB[ Index ] );
      }

      mbkfree( CATA_LIB );
      mbkfree( WORK_LIB );
    }

    GraalFirstLibrary = 0;

    CATA_LIB = GRAAL_CATA_LIB;
    WORK_LIB = GRAAL_WORK_LIB;

    if ( GRAAL_DEFAULT_LIB != (char *)NULL )
    {
      Label = XmStringCreateSimple( GRAAL_DEFAULT_LIB );

      XtVaSetValues( GraalFileOpenDialog.WIDGET,
                     XmNdirectory, Label, NULL );
   
      XmStringFree( Label );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                        CallbackLibraryUpdate                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackLibraryUpdate( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalGetCataLibrary();
    GraalGetWorkLibrary();
    GraalSetLibraryList();
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackLibraryCancel                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackLibraryCancel( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    int Index;

    for ( Index = 0;
          GRAAL_CATA_LIB[ Index ] != (char *)NULL;
          Index++ )
    {
      mbkfree( GRAAL_CATA_LIB[ Index ] );
    }

    mbkfree( GRAAL_CATA_LIB );
    mbkfree( GRAAL_WORK_LIB );

    XtUnmanageChild( GraalLibraryPanel.PANEL );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackEnterLibrary                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEnterLibrary( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalInitializeLibrary();

    GraalEnterPanel( &GraalLibraryPanel );
    GraalLimitedLoop( GraalLibraryPanel.PANEL );
    GraalReEnterDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalBuildPanelLibrary                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalBuildPanelLibrary()
  {
    Arg      Args[15];
    XmString Label;

    XtSetArg( Args[0], XmNshadowType    , XmSHADOW_ETCHED_IN      );
    XtSetArg( Args[1], XmNdeleteResponse,          XmDESTROY      );
    XtSetArg( Args[2], XmNtitle         , GraalLibraryPanel.TITLE );

    GraalLibraryPanel.PANEL = 

      XmCreateFormDialog( GraalMainWindow, "GraalLibraryPanel", Args, 3);

    XtAddCallback( GraalLibraryPanel.PANEL, XmNdestroyCallback,
                   GraalDestroyDialogCallback, NULL  );

    GraalLibraryPanel.PANEL_FORM = 

      XtVaCreateManagedWidget( "GraalLibraryPanelForm",
                               xmFormWidgetClass,
                               GraalLibraryPanel.PANEL,
                               XmNtopAttachment    , XmATTACH_FORM,
                               XmNbottomAttachment , XmATTACH_FORM,
                               XmNleftAttachment   , XmATTACH_FORM,
                               XmNrightAttachment  , XmATTACH_FORM,
                               XmNfractionBase     , 10,
                               NULL
                             );
 
    GraalLibraryPanel.FRAME = 

      XtVaCreateManagedWidget( "GraalLibraryFrame",
                               xmFrameWidgetClass,
                               GraalLibraryPanel.PANEL_FORM, 
                               XmNtopAttachment    , XmATTACH_FORM,
                               XmNbottomAttachment , XmATTACH_FORM,
                               XmNleftAttachment   , XmATTACH_FORM,
                               XmNrightAttachment  , XmATTACH_FORM,
                               NULL
                             );
 
    GraalLibraryPanel.FORM = 

      XtVaCreateManagedWidget( "GraalLibraryForm",
                               xmFormWidgetClass,
                               GraalLibraryPanel.FRAME, 
                               XmNtopAttachment    , XmATTACH_FORM,
                               XmNbottomAttachment , XmATTACH_FORM,
                               XmNleftAttachment   , XmATTACH_FORM,
                               XmNrightAttachment  , XmATTACH_FORM,
                               XmNfractionBase     , 120,
                               NULL
                             );

    GraalLibraryButtonUpdate =

      XtVaCreateManagedWidget( "Update",
                               xmPushButtonWidgetClass,
                               GraalLibraryPanel.FORM,
                               XmNleftAttachment   , XmATTACH_POSITION,
                               XmNleftPosition     , 10,
                               XmNrightAttachment  , XmATTACH_POSITION,
                               XmNrightPosition    , 40,
                               XmNtopAttachment    , XmATTACH_POSITION,
                               XmNtopPosition      , 105,
                               XmNbottomAttachment , XmATTACH_POSITION,
                               XmNbottomPosition   , 115,
                               NULL
                             );

    GraalLibraryButtonOk = 

      XtVaCreateManagedWidget( "Ok",
                               xmPushButtonWidgetClass,
                               GraalLibraryPanel.FORM, 
                               XmNleftAttachment   , XmATTACH_POSITION,
                               XmNleftPosition     , 50,
                               XmNrightAttachment  , XmATTACH_POSITION,
                               XmNrightPosition    , 70,
                               XmNtopAttachment    , XmATTACH_POSITION,
                               XmNtopPosition      , 105,
                               XmNbottomAttachment , XmATTACH_POSITION,
                               XmNbottomPosition   , 115,
                               NULL
                             );

    GraalLibraryButtonCancel = 

      XtVaCreateManagedWidget( "Cancel",
                               xmPushButtonWidgetClass,
                               GraalLibraryPanel.FORM, 
                               XmNleftAttachment   , XmATTACH_POSITION,
                               XmNleftPosition     , 80,
                               XmNrightAttachment  , XmATTACH_POSITION,
                               XmNrightPosition    , 110,
                               XmNtopAttachment    , XmATTACH_POSITION,
                               XmNtopPosition      , 105,
                               XmNbottomAttachment , XmATTACH_POSITION,
                               XmNbottomPosition   , 115,
                               NULL
                             );

    Label = XmStringCreateSimple( "Directories" );

    GraalLibraryListLabel = 

       XtVaCreateManagedWidget( "GraalLibraryListLabel",
                                xmLabelGadgetClass      , 
                                GraalLibraryPanel.FORM, 
                                XmNlabelString          , Label,
                                XmNleftAttachment       , XmATTACH_POSITION,
                                XmNleftPosition         , 5,
                                XmNtopAttachment        , XmATTACH_POSITION,
                                XmNtopPosition          , 5,
                                XmNbottomAttachment     , XmATTACH_POSITION,
                                XmNbottomPosition       , 10,
                                NULL );

    XmStringFree( Label );

    XtSetArg( Args[0]  , XmNtopAttachment         , XmATTACH_POSITION );
    XtSetArg( Args[1]  , XmNtopPosition           , 10 );
    XtSetArg( Args[2]  , XmNbottomAttachment      , XmATTACH_POSITION );
    XtSetArg( Args[3]  , XmNbottomPosition        , 40 );
    XtSetArg( Args[4]  , XmNrightAttachment       , XmATTACH_POSITION ); 
    XtSetArg( Args[5]  , XmNrightPosition         , 115 );
    XtSetArg( Args[6]  , XmNleftAttachment        , XmATTACH_POSITION );
    XtSetArg( Args[7]  , XmNleftPosition          , 5 );
    XtSetArg( Args[8]  , XmNscrollBarDisplayPolicy, XmSTATIC );
    XtSetArg( Args[9]  , XmNscrollHorizontal      , True );
    XtSetArg( Args[10] , XmNscrollVertical        , True );
    XtSetArg( Args[11] , XmNlistSizePolicy        , XmCONSTANT );

    GraalLibraryList = 

      XmCreateScrolledList( GraalLibraryPanel.FORM,
                            "GraalLibraryList", Args, 12 );

    Label = XmStringCreateSimple( "Catalog libraries" );

    GraalLibraryCataLabel = 

       XtVaCreateManagedWidget( "GraalLibraryCataLabel",
                                xmLabelGadgetClass      ,
                                GraalLibraryPanel.FORM,
                                XmNlabelString          , Label,
                                XmNleftAttachment       , XmATTACH_POSITION,
                                XmNleftPosition         , 5,
                                XmNtopAttachment        , XmATTACH_POSITION,
                                XmNtopPosition          , 45,
                                XmNbottomAttachment     , XmATTACH_POSITION,
                                XmNbottomPosition       , 50,
                                NULL );

    XmStringFree( Label );

    XtSetArg( Args[0]  , XmNrows                  , 4 );
    XtSetArg( Args[1]  , XmNeditable              , True );
    XtSetArg( Args[2]  , XmNcursorPositionVisible , True );
    XtSetArg( Args[3]  , XmNscrollHorizontal      , True );
    XtSetArg( Args[4]  , XmNscrollVertical        , True );
    XtSetArg( Args[5]  , XmNeditMode              , XmMULTI_LINE_EDIT );
    XtSetArg( Args[6]  , XmNtopAttachment         , XmATTACH_POSITION );
    XtSetArg( Args[7]  , XmNtopPosition           , 50 );
    XtSetArg( Args[8]  , XmNleftAttachment        , XmATTACH_POSITION );
    XtSetArg( Args[9]  , XmNleftPosition          , 5 );
    XtSetArg( Args[10] , XmNrightAttachment       , XmATTACH_POSITION );
    XtSetArg( Args[11] , XmNrightPosition         , 115 );
    XtSetArg( Args[12] , XmNbottomAttachment      , XmATTACH_POSITION );
    XtSetArg( Args[13] , XmNbottomPosition        , 80 );

    GraalLibraryCata  = 
 
      XmCreateScrolledText( GraalLibraryPanel.FORM,
                            "GraalLibraryCata", Args, 14 );

    Label = XmStringCreateSimple( "Work library" );

    GraalLibraryWorkLabel =

       XtVaCreateManagedWidget( "GraalLibraryWorkLabel",
                                xmLabelGadgetClass      ,
                                GraalLibraryPanel.FORM,
                                XmNlabelString          , Label,
                                XmNleftAttachment       , XmATTACH_POSITION,
                                XmNleftPosition         , 5,
                                XmNtopAttachment        , XmATTACH_POSITION,
                                XmNtopPosition          , 85,
                                XmNbottomAttachment     , XmATTACH_POSITION,
                                XmNbottomPosition       , 90,
                                NULL );
    XmStringFree( Label );

    XtSetArg( Args[0]  , XmNrows                  , 1 );
    XtSetArg( Args[1]  , XmNeditable              , True );
    XtSetArg( Args[2]  , XmNeditMode              , XmSINGLE_LINE_EDIT );
    XtSetArg( Args[3]  , XmNscrollHorizontal      , False );
    XtSetArg( Args[4]  , XmNscrollVertical        , False );
    XtSetArg( Args[5]  , XmNcursorPositionVisible , True  );
    XtSetArg( Args[6]  , XmNtopAttachment         , XmATTACH_POSITION );
    XtSetArg( Args[7]  , XmNtopPosition           , 90 );
    XtSetArg( Args[8]  , XmNleftAttachment        , XmATTACH_POSITION );
    XtSetArg( Args[9]  , XmNleftPosition          , 5 );
    XtSetArg( Args[10] , XmNrightAttachment       , XmATTACH_POSITION );
    XtSetArg( Args[11] , XmNrightPosition         , 115 );
    XtSetArg( Args[12] , XmNbottomAttachment      , XmATTACH_POSITION );
    XtSetArg( Args[13] , XmNbottomPosition        , 100 );

    GraalLibraryWork  =

      XmCreateText( GraalLibraryPanel.FORM,
                    "GraalLibraryWork", Args, 14 );

    XtManageChild( GraalLibraryWork );
    XtManageChild( GraalLibraryList );
    XtManageChild( GraalLibraryCata );

    XtAddCallback( GraalLibraryList,
                   XmNdefaultActionCallback,
                   CallbackLibraryList, NULL );

    XtAddCallback( GraalLibraryButtonOk, 
                   XmNactivateCallback,
                   CallbackLibraryOk, NULL );

    XtAddCallback( GraalLibraryButtonCancel, 
                   XmNactivateCallback,
                   CallbackLibraryCancel, NULL );

    XtAddCallback( GraalLibraryButtonUpdate, 
                   XmNactivateCallback,
                   CallbackLibraryUpdate, NULL );

    XtVaSetValues( GraalLibraryPanel.PANEL,
                   XmNheight, GraalLibraryPanel.HEIGHT,
                   XmNwidth , GraalLibraryPanel.WIDTH,
                   XmNx     , GraalLibraryPanel.X,
                   XmNy     , GraalLibraryPanel.Y,
                   NULL );

    Label = XmStringCreateSimple( "Library" );

    XtVaSetValues( XmFileSelectionBoxGetChild( GraalFileOpenDialog.WIDGET,
                   XmDIALOG_HELP_BUTTON ),
                   XmNlabelString, Label, NULL  );

    XmStringFree( Label );

    XtAddCallback( XmFileSelectionBoxGetChild( GraalFileOpenDialog.WIDGET,
                   XmDIALOG_HELP_BUTTON ),
                   XmNactivateCallback, 
                   CallbackEnterLibrary, NULL );
  }
