/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Menu.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include GTB_H
# include GSB_H
# include GMS_H

# include "GMS_menu.h"
# include "GMS_setup.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

   GraalMenuItem GraalSetupMenu[] =

         {
           {
             "Default Config",
             'D',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackSetupDefaultConfig,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Load Config",
             'L',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackSetupLoadConfig,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Save Config",
             'S',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackSetupSaveConfig,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           NULL
         };


/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                  CallbackSetupLoadConfig                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackSetupLoadConfig( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalLoadConfig( GRAAL_TRUE );
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackSetupSaveConfig                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackSetupSaveConfig( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalSaveConfig();
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackSetupDefaultConfig                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackSetupDefaultConfig( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalDefaultConfig();
  }
