/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Panel.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>
# include <Xm/FileSB.h>
# include <Xm/SelectioB.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GMT_H

# include "GMT_panel.h"
# include "GMT_message.h"
# include "GMT_dialog.h"
# include "GMT_tools.h"
# include "GMT_druc.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                             Panel                           |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Panel Tools                        |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalPanelToolsButtonName[] = 

   {
     "Equi",  
     "UnEqui",  
     "Flat",
     "Unflat",
     "Peek",
     "Unpeek",
     "Druc",
     "Close"
   };

 GraalPanelButtonItem GraalToolsGlobalButton[] =

         {
           {
             &GraalPanelToolsButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 0,
             1, 1,
             CallbackToolsGlobalEqui,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelToolsButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 1,
             1, 1,
             CallbackToolsGlobalUnEqui,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelToolsButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackToolsGlobalFlat,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelToolsButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 3,
             1, 1,
             CallbackToolsGlobalUnflat,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,

           {
             &GraalPanelToolsButtonName[4],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 4,
             1, 1,
             CallbackToolsGlobalPeek,
             (XtPointer)NULL,
             (Widget)NULL
           } 
           ,
           {
             &GraalPanelToolsButtonName[5],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 5,
             1, 1,
             CallbackToolsGlobalUnpeek,
             (XtPointer)NULL,
             (Widget)NULL
           } 
           ,
           {
             &GraalPanelToolsButtonName[6],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 6,
             1, 1,
             CallbackToolsGlobalDruc,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelToolsButtonName[7],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 7,
             1, 1,
             CallbackToolsCloseGlobal,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalToolsGlobalPanel =

         {
           "Tools",
           1,
           GRAAL_TOOLS_GLOBAL_X,
           GRAAL_TOOLS_GLOBAL_Y, 
           90,
           200,
           1,  
           8,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalToolsGlobalButton
         };

   int GraalToolsGlobalDefaultValues[ 4 ] =
 
         {
           GRAAL_TOOLS_GLOBAL_X,
           GRAAL_TOOLS_GLOBAL_Y,
           90, 200
         };

/*------------------------------------------------------------\
|                                                             |
|                      Panel Message                          |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalPanelMessageButtonName[] =

   {
     "Text",
     "Close"
   };

 GraalPanelButtonItem GraalToolsMessageButton[] =

         {
           {
             &GraalPanelMessageButtonName[0],
             "Nothing", NULL, 0, 0,
             NULL,
             NULL,
              0, 0,
              8, 9,
             NULL,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelMessageButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             3, 9,
             2, 1,
             CallbackToolsCloseMessage,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalToolsMessagePanel =

         {
           "Message",
           1,
           GRAAL_TOOLS_MESSAGE_X,
           GRAAL_TOOLS_MESSAGE_Y,
           360,
           250,
           8,
           10,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalToolsMessageButton
         };

   int GraalToolsMessageDefaultValues[ 4 ] =

         {
           GRAAL_TOOLS_MESSAGE_X,
           GRAAL_TOOLS_MESSAGE_Y,
           360, 250
         };

/*------------------------------------------------------------\
|                                                             |
|                        Druc  Panel                          |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalToolsDrucButtonName[] =

   {
     "Text",
     "Continue",
     "Abort"
   };

   static GraalPanelButtonItem GraalToolsDrucButton[] =

         {
           {
             &GraalToolsDrucButtonName[0],
             "Nothing", NULL, 0, 0,
             NULL,
             NULL,
             0, 0,
             8, 5,
             NULL,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalToolsDrucButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             1, 5,
             2, 1,
             CallbackToolsDrucContinue,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalToolsDrucButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             5, 5,
             2, 1,
             CallbackToolsDrucAbort,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalToolsDrucPanel  =

         {
           "Druc error",
           1,
           GRAAL_TOOLS_DRUC_X,
           GRAAL_TOOLS_DRUC_Y,
           360,
           150,
           8,
           6,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalToolsDrucButton
         };

  int GraalToolsDrucDefaultValues[ 4 ] =

         {
           GRAAL_TOOLS_DRUC_X,
           GRAAL_TOOLS_DRUC_Y,
           360, 150
         };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      Callback For Tools                     |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsGlobalEqui                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsGlobalEqui( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GraalHeadEqui != (rdsrec_list *)NULL )
    {
      GraalDelEqui();
      GraalZoomRefresh();
    }

    GraalChangeEditMode( GRAAL_TOOLS_EQUI,
                         GraalPromptToolsEqui );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsGlobalUnEqui                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsGlobalUnEqui( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GraalHeadEqui != (rdsrec_list *)NULL )
    {
      GraalDelEqui();
      GraalZoomRefresh();
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsGlobalFlat                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsGlobalFlat( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_TOOLS_FLATTEN,
                         GraalPromptToolsFlatten );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsGlobalUnflat                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsGlobalUnflat( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_TOOLS_UNFLATTEN,
                         GraalPromptToolsUnflatten );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsGlobalPeek                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsGlobalPeek( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_TOOLS_PEEK,
                         GraalPromptToolsPeek );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsGlobalUnpeek                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsGlobalUnpeek( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalToolsUnpeek();
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsGlobalDruc                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsGlobalDruc( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_TOOLS_DRUC,
                         GraalPromptToolsDruc );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsCloseGlobal                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsCloseGlobal( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalToolsGlobalPanel.PANEL );
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Message                    |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsCloseMessage                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsCloseMessage( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalToolsMessagePanel.PANEL );
  }

/*------------------------------------------------------------\
|                                                             |
|                   GraalDisplayErrorMessage                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalDisplayToolsMessage()
  {
    char *Message;

    Message = GraalGetErrorMessage();

    if ( Message != (char *)NULL )
    {
      XmTextSetString( GraalToolsMessageButton[0].BUTTON, Message );

      GraalEnterPanel( &GraalToolsMessagePanel );
    }
    else
    {
      XmTextSetString( GraalToolsMessageButton[0].BUTTON, ""      );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                        Callback For Druc                    |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsDrucContinue                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsDrucContinue( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackToolsDrucAbort                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsDrucAbort( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalDrucAbort = GRAAL_TRUE; 

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalDisplayDrucMessage                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalDisplayDrucMessage( Message )

    char *Message;
  {
    XmTextSetString( GraalToolsDrucButton[0].BUTTON, Message );
  }
