/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Map.h                           |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# ifndef GRAAL_MAP
# define GRAAL_MAP

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# define GRAAL_B1UP   0
# define GRAAL_B2UP   1
# define GRAAL_B3UP   2

# define GRAAL_VIEW_MAP_X        25
# define GRAAL_VIEW_MAP_Y       520

# define GRAAL_DEFAULT_MAP_X      0
# define GRAAL_DEFAULT_MAP_Y      0
# define GRAAL_DEFAULT_MAP_DX    40
# define GRAAL_DEFAULT_MAP_DY    40

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
 
  extern Widget GraalMapPanel;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern void GraalComputeLambdaMap();
  extern void GraalInitializeLambdaMap();
  extern void GraalDisplayLambdaMap();

  extern void GraalEnterMapPanel();
  extern void GraalClearMapWindow();
  extern void GraalResizeMapWindow();
  extern void GraalRefreshMapWindow();
  extern void GraalInitializeMapWindow();

  extern void CallbackCloseMap();
  extern void CallbackMapCompute();
  extern void CallbackMapResize();
  extern void CallbackMapExpose();
  extern void CallbackMapEvent();

# endif 
