/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Panel.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>

# include MPH_H
# include RDS_H
# include RPR_H
# include GSB_H
# include GTB_H
# include GMX_H
# include GMV_H

# include "GMV_panel.h"
# include "GMV_dialog.h"
# include "GMV_view.h"
# include "GMV_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        Panel Pixmap                         |
|                                                             |
\------------------------------------------------------------*/

  static char GraalPixmapDownArrow[] =

  { 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xfe, 0xff, 0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x02, 0x80, 0x00,
    0x00, 0x02, 0x80, 0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x02, 0x80, 0x00,
    0x00, 0x02, 0x80, 0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x02, 0x80, 0x00,
    0xf0, 0x03, 0x80, 0x1f, 0x10, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x10,
    0x10, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00, 0x08,
    0x40, 0x00, 0x00, 0x04, 0x80, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01,
    0x00, 0x02, 0x80, 0x00, 0x00, 0x04, 0x40, 0x00, 0x00, 0x08, 0x20, 0x00,
    0x00, 0x10, 0x10, 0x00, 0x00, 0x20, 0x08, 0x00, 0x00, 0x40, 0x04, 0x00,
    0x00, 0x80, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

  static char GraalPixmapLeftArrow[] =

  {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x0f, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x20, 0x08, 0x00,
    0x00, 0x10, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x04, 0xf8, 0x1f,
    0x00, 0x02, 0x00, 0x10, 0x00, 0x01, 0x00, 0x10, 0x80, 0x00, 0x00, 0x10,
    0x40, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x10,
    0x08, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00, 0x10,
    0x40, 0x00, 0x00, 0x10, 0x80, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00, 0x10,
    0x00, 0x02, 0x00, 0x10, 0x00, 0x04, 0xf8, 0x1f, 0x00, 0x08, 0x08, 0x00,
    0x00, 0x10, 0x08, 0x00, 0x00, 0x20, 0x08, 0x00, 0x00, 0x40, 0x08, 0x00,
    0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

  static char GraalPixmapRightArrow[] =

  {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xf0, 0x01, 0x00, 0x00, 0x10, 0x02, 0x00, 0x00, 0x10, 0x04, 0x00,
    0x00, 0x10, 0x08, 0x00, 0x00, 0x10, 0x10, 0x00, 0xf8, 0x1f, 0x20, 0x00,
    0x08, 0x00, 0x40, 0x00, 0x08, 0x00, 0x80, 0x00, 0x08, 0x00, 0x00, 0x01,
    0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x08,
    0x08, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x04,
    0x08, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x01, 0x08, 0x00, 0x80, 0x00,
    0x08, 0x00, 0x40, 0x00, 0xf8, 0x1f, 0x20, 0x00, 0x00, 0x10, 0x10, 0x00,
    0x00, 0x10, 0x08, 0x00, 0x00, 0x10, 0x04, 0x00, 0x00, 0x10, 0x02, 0x00,
    0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

  static char GraalPixmapUpArrow[] =

  {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x01, 0x00, 0x00, 0x20, 0x02, 0x00,
    0x00, 0x10, 0x04, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x04, 0x10, 0x00,
    0x00, 0x02, 0x20, 0x00, 0x00, 0x01, 0x40, 0x00, 0x80, 0x00, 0x80, 0x00,
    0x40, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x02, 0x10, 0x00, 0x00, 0x04,
    0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x08,
    0x08, 0x00, 0x00, 0x08, 0xf8, 0x01, 0xc0, 0x0f, 0x00, 0x01, 0x40, 0x00,
    0x00, 0x01, 0x40, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x01, 0x40, 0x00,
    0x00, 0x01, 0x40, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x01, 0x40, 0x00,
    0x00, 0x01, 0x40, 0x00, 0x00, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

/*------------------------------------------------------------\
|                                                             |
|                        Panel Arrows                         |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalPanelArrowsButtonName[] = 

   {
     "Left",  
     "Up",
     "Down",
     "Right",
     "Move Set",
     "Close"
   };

   static GraalPanelButtonItem GraalViewArrowsButton[] =

         {
           {
             &GraalPanelArrowsButtonName[0],
             NULL, GraalPixmapLeftArrow, 32, 32,
             NULL,
             NULL,
             0, 0,
             1, 2,
             CallbackLeftArrow,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelArrowsButtonName[1],
             NULL, GraalPixmapUpArrow, 32, 32,
             NULL,
             NULL,
             1, 0,
             1, 2,
             CallbackUpArrow,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelArrowsButtonName[2],
             NULL, GraalPixmapDownArrow, 32, 32,
             NULL,
             NULL,
             0, 2,
             1, 2,
             CallbackDownArrow,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelArrowsButtonName[3],
             NULL, GraalPixmapRightArrow, 32, 32,
             NULL,
             NULL,
             1, 2,
             1, 2,
             CallbackRightArrow,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelArrowsButtonName[4],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 4,
             2, 1,
             CallbackMoveSet,
             (XtPointer)NULL,
             (Widget)NULL
           } 
           , 
           {
             &GraalPanelArrowsButtonName[5],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 5,
             2, 1,
             CallbackCloseArrows,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalViewArrowsPanel =

         {
           "Arrows",
           1,
           GRAAL_VIEW_ARROWS_X,
           GRAAL_VIEW_ARROWS_Y, 
           90,
           125,
           2,  
           6,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalViewArrowsButton
         };

   int GraalViewArrowsDefaultValues[ 4 ] =

         {
           GRAAL_VIEW_ARROWS_X, 
           GRAAL_VIEW_ARROWS_Y,
           90, 125 
         };

/*------------------------------------------------------------\
|                                                             |
|                        Panel Zoom                           |
|                                                             |
\------------------------------------------------------------*/

 static char *GraalPanelZoomButtonName[] =

   {
     "Refresh",
     "UnZoom",
     "Zoom",
     "Mooz",
     "Zoom Set",
     "Zoom In",
     "Center",
     "Goto",
     "Pan",
     "Fit",
     "Close"
   };


 GraalPanelButtonItem GraalViewZoomButton[] =

         {
           {
             &GraalPanelZoomButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 0,
             1, 1,
             CallbackZoomRefresh,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelZoomButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 1,
             1, 1,
             CallbackZoomPrevious,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelZoomButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackZoomMore,
             (XtPointer)NULL,
             (Widget)NULL
           } 
           ,
           {
             &GraalPanelZoomButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 3,
             1, 1,
             CallbackZoomLess,
             (XtPointer)NULL,
             (Widget)NULL
           } 
           ,
           {
             &GraalPanelZoomButtonName[4],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 4,
             1, 1,
             CallbackZoomSet,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelZoomButtonName[5],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 5,
             1, 1,
             CallbackZoomIn,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelZoomButtonName[6],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 6,
             1, 1,
             CallbackZoomCenter,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelZoomButtonName[7],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 7,
             1, 1,
             CallbackZoomGoto,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelZoomButtonName[8],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 8,
             1, 1,
             CallbackZoomPan,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalPanelZoomButtonName[9],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 9,
             1, 1,
             CallbackZoomFit,
             (XtPointer)NULL,
             (Widget)NULL
           } 
           , 
           {
             &GraalPanelZoomButtonName[10],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 10,
             1, 1,
             CallbackCloseZoom,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalViewZoomPanel =

         {
           "Zoom",
           1,
           GRAAL_VIEW_ZOOM_X,
           GRAAL_VIEW_ZOOM_Y, 
           90,
           275,
           1,  
           11,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalViewZoomButton
         };

   int GraalViewZoomDefaultValues[ 4 ] =

         {
           GRAAL_VIEW_ZOOM_X, 
           GRAAL_VIEW_ZOOM_Y,
           90, 275
         };

/*------------------------------------------------------------\
|                                                             |
|                        Panel Layer                          |
|                                                             |
\------------------------------------------------------------*/

  static char GraalViewLayerTranslate [ GRAAL_RDS_MAX_LAYER ] =

  {
    RDS_NWELL,
    RDS_PWELL,
    RDS_NIMP,
    RDS_PIMP,
    RDS_ACTIV,
    RDS_NDIF,
    RDS_PDIF,
    RDS_NTIE,
    RDS_PTIE,
    RDS_POLY,
    RDS_GATE,
    RDS_TPOLY,
    RDS_CONT,
    RDS_ALU1,
    RDS_TALU1,
    RDS_VIA1,
    RDS_ALU2,
    RDS_TALU2,
    RDS_VIA2,
    RDS_ALU3,
    RDS_TALU3,
    RDS_VIA3,
    RDS_ALU4,
    RDS_CPAS,
    RDS_REF,
    RDS_ABOX
  };

  static char *GraalViewLayerButtonName[] =

  {
    "All visible",
    "All invisible",
    "Fig",
    "Inst",
    "FCon",
    "ICon",
    "FSeg",
    "ISeg",
    "FRef",
    "IRef",
    "Apply",
    "Close"
  };

  static char *GraalViewLayerButtonBackground = "Black";
  static char *GraalViewLayerButtonForeground = "White";

     GraalPanelButtonItem GraalViewLayerButton[] =

         {
           {
             &GraalViewLayerButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 0,
             2, 1,
             CallbackLayerAllVisible,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[1],
             NULL, NULL, 0, 0, 
             NULL, 
             NULL, 
             2, 0, 
             2, 1, 
             CallbackLayerAllInvisible, 
             (XtPointer)NULL, 
             (Widget)NULL 
           } 
           , 
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NWELL][0],
             NULL, NULL, 0, 0, 
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NWELL][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NWELL][2], 
             0, 1, 
             1, 1, 
             CallbackLayerVisible, 
             (XtPointer)GRAAL_RDS_NWELL,
             (Widget)NULL 
           } 
           , 
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NWELL][0],
             NULL, NULL, 0, 0, 
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NWELL][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NWELL][2], 
             1, 1, 
             1, 1, 
             CallbackLayerInvisible, 
             (XtPointer)GRAAL_RDS_NWELL,
             (Widget)NULL 
           } 
           , 
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PWELL][0],
             NULL, NULL, 0, 0, 
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PWELL][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PWELL][2],
             2, 1, 
             1, 1,
             CallbackLayerVisible, 
             (XtPointer)GRAAL_RDS_PWELL,
             (Widget)NULL 
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PWELL][0],
             NULL, NULL, 0, 0, 
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PWELL][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PWELL][2],
             3, 1, 
             1, 1,
             CallbackLayerInvisible, 
             (XtPointer)GRAAL_RDS_PWELL,  
             (Widget)NULL 
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NIMP][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NIMP][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NIMP][2],
             0, 2,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_NIMP,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NIMP][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NIMP][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NIMP][2],
             1, 2,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_NIMP,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PIMP][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PIMP][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PIMP][2],
             2, 2,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_PIMP,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PIMP][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PIMP][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PIMP][2],
             3, 2,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_PIMP,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ACTIV][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ACTIV][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ACTIV][2],
             0, 3,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_ACTIV,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ACTIV][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ACTIV][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ACTIV][2],
             1, 3,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_ACTIV,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NDIF][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NDIF][2],
             2, 3,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_NDIF,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NDIF][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NDIF][2],
             3, 3,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_NDIF,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PDIF][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PDIF][2],
             0, 4,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_PDIF,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PDIF][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PDIF][2],
             1, 4,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_PDIF,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NTIE][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NTIE][2],
             2, 4,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_NTIE,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NTIE][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_NTIE][2],
             3, 4,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_NTIE,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PTIE][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PTIE][2],
             0, 5,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_PTIE,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PTIE][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_PTIE][2],
             1, 5,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_PTIE,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_POLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_POLY][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_POLY][2],
             2, 5,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_POLY,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_POLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_POLY][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_POLY][2],
             3, 5,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_POLY,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_GATE][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_GATE][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_GATE][2],
             0, 6,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_GATE,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_GATE][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_GATE][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_GATE][2],
             1, 6,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_GATE,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TPOLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TPOLY][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TPOLY][2],
             2, 6,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_TPOLY,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TPOLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TPOLY][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TPOLY][2],
             3, 6,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_TPOLY,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CONT][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CONT][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CONT][2],
             0, 7,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_CONT,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CONT][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CONT][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CONT][2],
             1, 7,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_CONT,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU1][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU1][2],
             2, 7,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_ALU1,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU1][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU1][2],
             3, 7,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_ALU1,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU1][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU1][2],
             0, 8,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_TALU1,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU1][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU1][2],
             1, 8,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_TALU1,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA1][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA1][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA1][2],
             2, 8,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_VIA1,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA1][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA1][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA1][2],
             3, 8,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_VIA1,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU2][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU2][2],
             0, 9,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_ALU2,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU2][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU2][2],
             1, 9,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_ALU2,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU2][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU2][2],
             2, 9,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_TALU2,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU2][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU2][2],
             3, 9,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_TALU2,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA2][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA2][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA2][2],
             0, 10,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_VIA2,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA2][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA2][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA2][2],
             1, 10,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_VIA2,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU3][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU3][2],
             2, 10,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_ALU3,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU3][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU3][2],
             3, 10,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_ALU3,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU3][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU3][2],
             0, 11,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_TALU3,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU3][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_TALU3][2],
             1, 11,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_TALU3,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA3][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA3][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA3][2],
             2, 11,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_VIA3,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA3][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA3][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_VIA3][2],
             3, 11,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_VIA3,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU4][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU4][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU4][2],
             0, 12,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_ALU4,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU4][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU4][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ALU4][2],
             1, 12,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_ALU4,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CPAS][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CPAS][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CPAS][2],
             2, 12,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_CPAS,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CPAS][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CPAS][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_CPAS][2],
             3, 12,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_CPAS,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_REF][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_REF][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_REF][2],
             0, 13,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_REF,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_REF][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_REF][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_REF][2],
             1, 13,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_REF,
             (Widget)NULL
           } 
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ABOX][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ABOX][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ABOX][2],
             2, 13,
             1, 1,
             CallbackLayerVisible,
             (XtPointer)GRAAL_RDS_ABOX,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ABOX][0],
             NULL, NULL, 0, 0,
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ABOX][1],
             &GRAAL_RDS_LAYER_NAME_TABLE[RDS_ABOX][2],
             3, 13,
             1, 1,
             CallbackLayerInvisible,
             (XtPointer)GRAAL_RDS_ABOX,
             (Widget)NULL
           } 
           ,
           {
             &GraalViewLayerButtonName[2],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             0, 14,
             1, 1,
             CallbackNameVisible,
             (XtPointer)GRAAL_FIGURE_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[2],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             1, 14,
             1, 1,
             CallbackNameInvisible,
             (XtPointer)GRAAL_FIGURE_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[3],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             2, 14,
             1, 1,
             CallbackNameVisible,
             (XtPointer)GRAAL_INSTANCE_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[3],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             3, 14,
             1, 1,
             CallbackNameInvisible,
             (XtPointer)GRAAL_INSTANCE_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[4],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             0, 15,
             1, 1,
             CallbackNameVisible,
             (XtPointer)GRAAL_FIGURE_CONNECTOR_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[4],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             1, 15,
             1, 1,
             CallbackNameInvisible,
             (XtPointer)GRAAL_FIGURE_CONNECTOR_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[5],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             2, 15,
             1, 1,
             CallbackNameVisible,
             (XtPointer)GRAAL_INSTANCE_CONNECTOR_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[5],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             3, 15,
             1, 1,
             CallbackNameInvisible,
             (XtPointer)GRAAL_INSTANCE_CONNECTOR_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[6],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             0, 16,
             1, 1,
             CallbackNameVisible,
             (XtPointer)GRAAL_FIGURE_SEGMENT_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[6],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             1, 16,
             1, 1,
             CallbackNameInvisible,
             (XtPointer)GRAAL_FIGURE_SEGMENT_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[7],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             2, 16,
             1, 1,
             CallbackNameVisible,
             (XtPointer)GRAAL_INSTANCE_SEGMENT_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[7],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             3, 16,
             1, 1,
             CallbackNameInvisible,
             (XtPointer)GRAAL_INSTANCE_SEGMENT_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[8],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             0, 17,
             1, 1,
             CallbackNameVisible,
             (XtPointer)GRAAL_FIGURE_REFERENCE_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[8],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             1, 17,
             1, 1,
             CallbackNameInvisible,
             (XtPointer)GRAAL_FIGURE_REFERENCE_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[9],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             2, 17,
             1, 1,
             CallbackNameVisible,
             (XtPointer)GRAAL_INSTANCE_REFERENCE_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[9],
             NULL, NULL, 0, 0,
             &GraalViewLayerButtonForeground,
             &GraalViewLayerButtonBackground,
             3, 17,
             1, 1,
             CallbackNameInvisible,
             (XtPointer)GRAAL_INSTANCE_REFERENCE_NAME,
             (Widget)NULL
           }
           ,
           {
             &GraalViewLayerButtonName[10],
             NULL, NULL, 0, 0, 
             NULL, 
             NULL, 
             0, 18, 
             2, 1, 
             CallbackLayerApply, 
             (XtPointer)NULL, 
             (Widget)NULL 
           } 
           , 
           {
             &GraalViewLayerButtonName[11],
             NULL, NULL, 0, 0, 
             NULL, 
             NULL, 
             2, 18, 
             2, 1, 
             CallbackCloseLayer, 
             (XtPointer)NULL, 
             (Widget)NULL 
           } 
           ,
           NULL
         };


     GraalPanelItem GraalViewLayerPanel =

         {
           "Layer",
           1,
           GRAAL_VIEW_LAYER_X,
           GRAAL_VIEW_LAYER_Y,
           180,
           475,
           4,
           19,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalViewLayerButton
         };

  int GraalViewLayerDefaultValues[ 4 ] =

         {
           GRAAL_VIEW_LAYER_X,
           GRAAL_VIEW_LAYER_Y,
           180, 475
         };

  static char FirstEnterLayerPanel = 1;

/*------------------------------------------------------------\
|                                                             |
|                        Panel Grid                           |
|                                                             |
\------------------------------------------------------------*/

 static char *GraalPanelGridButtonName[] =

   {
     "Grid X",
     "Grid Y",
     "Grid Off",
     "Close"
   };


 GraalPanelButtonItem GraalViewGridButton[] =

         {
           {
             &GraalPanelGridButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 0,
             1, 1,
             CallbackSetGridX,
             (XtPointer)NULL,
             (Widget)NULL
           }
           , 
           {
             &GraalPanelGridButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 1,
             1, 1,
             CallbackSetGridY,
             (XtPointer)NULL,
             (Widget)NULL   
           }
           ,
           {
             &GraalPanelGridButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackGridOnOff,
             (XtPointer)NULL,
             (Widget)NULL   
           }
           ,
           {
             &GraalPanelGridButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 3,
             1, 1,
             CallbackCloseGrid,
             (XtPointer)NULL,
             (Widget)NULL   
           }
           ,
           NULL
         };

     GraalPanelItem GraalViewGridPanel =

         {
           "Grid",
           1,
           GRAAL_VIEW_GRID_X,
           GRAAL_VIEW_GRID_Y, 
           90,
           100,
           1,  
           4,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalViewGridButton
         };

  int GraalViewGridDefaultValues[ 4 ] =

         {
           GRAAL_VIEW_GRID_X,
           GRAAL_VIEW_GRID_Y, 
           90, 100
         };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      Callback For Arrows                    |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      CallbackLeftArrow                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackLeftArrow( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomLeft();
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackRightArrow                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackRightArrow( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomRight();
  }

/*------------------------------------------------------------\
|                                                             |
|                        CallbackUpArrow                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackUpArrow( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomUp();
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackDownArrow                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackDownArrow( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomDown();
  }


/*------------------------------------------------------------\
|                                                             |
|                       CallbackMoveSet                       |
|                                                             |
\------------------------------------------------------------*/

  void CallbackMoveSet( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalViewMoveSetDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackCloseArrows                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCloseArrows( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalViewArrowsPanel.PANEL );
  }

/*------------------------------------------------------------\
|                                                             |
|                         Zoom Callback                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       CallbackZoomRefresh                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomRefresh( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomRefresh();
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackZoomPrevious                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomPrevious( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomUndo();
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackZoomLess                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomLess( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomLess();
  }

/*------------------------------------------------------------\
|                                                             |
|                        CallbackZoomMore                     |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomMore( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomMore();
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackZoomSet                       |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomSet( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalViewZoomSetDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackCloseZoom                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCloseZoom( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalViewZoomPanel.PANEL );
  }

/*------------------------------------------------------------\
|                                                             |
|                        CallbackZoomIn                       |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomIn( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_ZOOM_IN,
                         GraalPromptZoomIn );
  }

/*------------------------------------------------------------\
|                                                             |
|                        CallbackZoomCenter                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomCenter( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_ZOOM_CENTER,
                         GraalPromptZoomCenter );
  }

/*------------------------------------------------------------\
|                                                             |
|                        CallbackZoomGoto                     |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomGoto( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalViewZoomGotoDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                        CallbackZoomPan                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomPan( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_ZOOM_PAN,
                         GraalPromptZoomPan );
  }

/*------------------------------------------------------------\
|                                                             |
|                        CallbackZoomFit                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackZoomFit( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomFit();
  }

/*------------------------------------------------------------\
|                                                             |
|                      Callback For Layer                     |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackLayerAllVisible                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackLayerAllVisible( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalLayerAllVisible();
  }

/*------------------------------------------------------------\ 
|                                                             | 
|                  CallbackLayerAllInvisible                  | 
|                                                             | 
\------------------------------------------------------------*/ 
 
  void CallbackLayerAllInvisible( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData; 
  {
    GraalLayerAllInvisible();
  }

/*------------------------------------------------------------\ 
|                                                             | 
|                      CallbackLayerVisible                   | 
|                                                             | 
\------------------------------------------------------------*/ 
 
  void CallbackLayerVisible( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData; 
  {
    char Layer;

    Layer = GraalViewLayerTranslate[ (int)ClientData ];

    if ( GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] == 0 )
    {
      GraalSetLayerVisible( ClientData );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackNameVisible                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackNameVisible( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GRAAL_RDS_ACTIVE_NAME_TABLE[ (int)ClientData ] == 0 )
    {
      GraalSetNameVisible( ClientData );
    }
  }

/*------------------------------------------------------------\ 
|                                                             | 
|                     CallbackLayerInvisible                  | 
|                                                             | 
\------------------------------------------------------------*/ 
 
  void CallbackLayerInvisible( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData; 
  {
    char Layer;

    Layer = GraalViewLayerTranslate[ (int)ClientData ];

    if ( GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] == 1 )
    { 
      GraalSetLayerInvisible( ClientData );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackNameInvisible                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackNameInvisible( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GRAAL_RDS_ACTIVE_NAME_TABLE[ (int)ClientData ] == 1 )
    {
      GraalSetNameInvisible( ClientData );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackLayerApply                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackLayerApply( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalZoomRefresh();
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackCloseLayer                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCloseLayer( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalViewLayerPanel.PANEL );
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalSetLayerVisible                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalSetLayerVisible( Layer )

    int Layer;
  {
     int   Index;
     char *Background;
     char *Foreground;

     Index = 2 + ( Layer << 1 );
     Layer = GraalViewLayerTranslate[ Layer ];

     if ( GraalViewLayerButton[ Index ].BUTTON != NULL )
     {
       GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] = 1;

       XtVaSetValues( GraalViewLayerButton[ Index + 1 ].BUTTON,
                      XtVaTypedArg                            ,
                      XmNbackground                           ,
                      XmRString                               ,
                      GRAAL_BLACK_COLOR                       ,
                      strlen( GRAAL_BLACK_COLOR ) + 1         ,
                      NULL
                    );

       XtVaSetValues( GraalViewLayerButton[ Index + 1 ].BUTTON,
                      XtVaTypedArg                            ,
                      XmNforeground                           ,
                      XmRString                               ,
                      GRAAL_BLACK_COLOR                       ,
                      strlen( GRAAL_BLACK_COLOR ) + 1         ,
                      NULL
                    );

       Background = *GraalViewLayerButton[ Index ].BACKGROUND;
       Foreground = *GraalViewLayerButton[ Index ].FOREGROUND;

       XtVaSetValues( GraalViewLayerButton[ Index ].BUTTON  ,
                      XtVaTypedArg            ,
                      XmNbackground           ,
                      XmRString               ,
                      Background              ,
                      strlen( Background ) + 1,
                      NULL
                    );
  
       XtVaSetValues( GraalViewLayerButton[ Index ].BUTTON  ,
                      XtVaTypedArg            ,
                      XmNforeground           ,
                      XmRString               ,
                      Foreground              ,
                      strlen( Foreground ) + 1,
                      NULL
                    );
    }
  } 

/*------------------------------------------------------------\
|                                                             |
|                       GraalSetNameVisible                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalSetNameVisible( Name )

    int Name;
  {
     int   Index;
     char *Background;
     char *Foreground;

     Index = 2 + ( ( GRAAL_RDS_MAX_LAYER + Name ) << 1 );

     if ( GraalViewLayerButton[ Index ].BUTTON != NULL )
     {
       GRAAL_RDS_ACTIVE_NAME_TABLE[ Name ] = 1;

       XtVaSetValues( GraalViewLayerButton[ Index + 1 ].BUTTON,
                      XtVaTypedArg                            ,
                      XmNbackground                           ,
                      XmRString                               ,
                      GRAAL_BLACK_COLOR                       ,
                      strlen( GRAAL_BLACK_COLOR ) + 1         ,
                      NULL
                    );

       XtVaSetValues( GraalViewLayerButton[ Index + 1 ].BUTTON,
                      XtVaTypedArg                            ,
                      XmNforeground                           ,
                      XmRString                               ,
                      GRAAL_BLACK_COLOR                       ,
                      strlen( GRAAL_BLACK_COLOR ) + 1         ,
                      NULL
                    );

       Background = *GraalViewLayerButton[ Index ].BACKGROUND;
       Foreground = *GraalViewLayerButton[ Index ].FOREGROUND;

       XtVaSetValues( GraalViewLayerButton[ Index ].BUTTON  ,
                      XtVaTypedArg            ,
                      XmNbackground           ,
                      XmRString               ,
                      Background              ,
                      strlen( Background ) + 1,
                      NULL
                    );
  
       XtVaSetValues( GraalViewLayerButton[ Index ].BUTTON  ,
                      XtVaTypedArg            ,
                      XmNforeground           ,
                      XmRString               ,
                      Foreground              ,
                      strlen( Foreground ) + 1,
                      NULL
                    );
    }
  } 
  
/*------------------------------------------------------------\
|                                                             |
|                    GraalSetLayerInvisible                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalSetLayerInvisible( Layer )

    int Layer;
  {
     int   Index;
     char *Background;
     char *Foreground;

     Index = 3 + ( Layer << 1 );
     Layer = GraalViewLayerTranslate[ Layer ];

     if ( GraalViewLayerButton[ Index ].BUTTON != NULL )
     {
       GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] = 0;

       XtVaSetValues( GraalViewLayerButton[ Index - 1 ].BUTTON,
                      XtVaTypedArg                            ,
                      XmNbackground                           ,
                      XmRString                               ,
                      GRAAL_BLACK_COLOR                       ,
                      strlen( GRAAL_BLACK_COLOR ) + 1         ,
                      NULL
                    );

       XtVaSetValues( GraalViewLayerButton[ Index - 1 ].BUTTON,
                      XtVaTypedArg                            ,
                      XmNforeground                           ,
                      XmRString                               ,
                      GRAAL_BLACK_COLOR                       ,
                      strlen( GRAAL_BLACK_COLOR ) + 1         ,
                      NULL
                    );

       Background = *GraalViewLayerButton[ Index ].BACKGROUND;
       Foreground = *GraalViewLayerButton[ Index ].FOREGROUND;
  
       XtVaSetValues( GraalViewLayerButton[ Index ].BUTTON  ,
                      XtVaTypedArg                          ,
                      XmNbackground                         ,
                      XmRString                             ,
                      Background                            ,
                      strlen( Background ) + 1              ,
                      NULL
                    );
  
       XtVaSetValues( GraalViewLayerButton[ Index ].BUTTON  ,
                      XtVaTypedArg                          ,
                      XmNforeground                         ,
                      XmRString                             ,
                      Foreground                            ,
                      strlen( Foreground ) + 1              ,
                      NULL
                    );
    } 
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalSetNameInvisible                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalSetNameInvisible( Name )

    int Name;
  {
     int   Index;
     char *Background;
     char *Foreground;

     Index = 3 + ( ( GRAAL_RDS_MAX_LAYER + Name ) << 1 );

     if ( GraalViewLayerButton[ Index ].BUTTON != NULL )
     {
       GRAAL_RDS_ACTIVE_NAME_TABLE[ Name ] = 0;

       XtVaSetValues( GraalViewLayerButton[ Index - 1 ].BUTTON,
                      XtVaTypedArg                            ,
                      XmNbackground                           ,
                      XmRString                               ,
                      GRAAL_BLACK_COLOR                       ,
                      strlen( GRAAL_BLACK_COLOR ) + 1         ,
                      NULL
                    );

       XtVaSetValues( GraalViewLayerButton[ Index - 1 ].BUTTON,
                      XtVaTypedArg                            ,
                      XmNforeground                           ,
                      XmRString                               ,
                      GRAAL_BLACK_COLOR                       ,
                      strlen( GRAAL_BLACK_COLOR ) + 1         ,
                      NULL
                    );

       Background = *GraalViewLayerButton[ Index ].BACKGROUND;
       Foreground = *GraalViewLayerButton[ Index ].FOREGROUND;
  
       XtVaSetValues( GraalViewLayerButton[ Index ].BUTTON  ,
                      XtVaTypedArg                          ,
                      XmNbackground                         ,
                      XmRString                             ,
                      Background                            ,
                      strlen( Background ) + 1              ,
                      NULL
                    );
  
       XtVaSetValues( GraalViewLayerButton[ Index ].BUTTON  ,
                      XtVaTypedArg                          ,
                      XmNforeground                         ,
                      XmRString                             ,
                      Foreground                            ,
                      strlen( Foreground ) + 1              ,
                      NULL
                    );
    } 
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalLayerAllVisible                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalLayerAllVisible()

  {
    int   Layer;

    for ( Layer = GRAAL_RDS_NWELL; Layer < GRAAL_RDS_MAX_LAYER; Layer++ )
    {
      GraalSetLayerVisible( Layer );
    }

    for ( Layer = 0; Layer < GRAAL_MAX_ACTIVE_NAME; Layer++ )
    {
      GraalSetNameVisible( Layer );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalInitializeLayer                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeLayer()

  {
    int   Index;
    char  Layer;

    for ( Index = GRAAL_RDS_NWELL; Index < GRAAL_RDS_MAX_LAYER; Index++ )
    {
      Layer = GraalViewLayerTranslate[ Index ];

      if ( GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] == 0 )
      {
        GraalSetLayerInvisible( Index );
      }
      else
      {
        GraalSetLayerVisible( Index );
      }
    }

    for ( Layer = 0; Layer < GRAAL_MAX_ACTIVE_NAME; Layer++ )
    {
      if ( GRAAL_RDS_ACTIVE_NAME_TABLE[ Layer ] == 0 )
      {
        GraalSetNameInvisible( Layer );
      }
      else
      {
        GraalSetNameVisible( Layer );
      }
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalLayerAllInvisible                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalLayerAllInvisible()

  {
    int   Layer;

    for ( Layer = RDS_NWELL; Layer < GRAAL_RDS_MAX_LAYER; Layer++ )
    {
      GraalSetLayerInvisible( Layer );
    }

    for ( Layer = 0; Layer < GRAAL_MAX_ACTIVE_NAME; Layer++ )
    {
      GraalSetNameInvisible( Layer );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                      Callback For Grid                      |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      CallbackSetGridX                       |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackSetGridX( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalViewGridXDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackSetGridY                       |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackSetGridY( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalViewGridYDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackGridOnOff                      |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackGridOnOff( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XmString Label;

    GraalLambdaUserGrid = ! GraalLambdaUserGrid;

    if ( GraalLambdaUserGrid == GRAAL_FALSE )
    {  
      Label = XmStringCreateSimple( "Grid Off" );
    }  
    else
    {   
      Label = XmStringCreateSimple( "Grid On" );
    }  

    XtVaSetValues( MyWidget, XmNlabelString, Label,
                             XmNresizable  , False,
                             NULL );
    XmStringFree( Label );

    GraalZoomRefresh();
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackCloseGrid                      |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackCloseGrid( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalViewGridPanel.PANEL );
  }
