/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Panel.h                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  25/02/93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# ifndef GRAAL_VIEW_PANEL
# define GRAAL_VIEW_PANEL

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
 
# define GRAAL_RDS_NWELL   0
# define GRAAL_RDS_PWELL   1
# define GRAAL_RDS_NIMP    2
# define GRAAL_RDS_PIMP    3
# define GRAAL_RDS_ACTIV   4
# define GRAAL_RDS_NDIF    5
# define GRAAL_RDS_PDIF    6
# define GRAAL_RDS_NTIE    7
# define GRAAL_RDS_PTIE    8
# define GRAAL_RDS_POLY    9
# define GRAAL_RDS_GATE    10
# define GRAAL_RDS_TPOLY   11
# define GRAAL_RDS_CONT    12
# define GRAAL_RDS_ALU1    13
# define GRAAL_RDS_TALU1   14
# define GRAAL_RDS_VIA1    15
# define GRAAL_RDS_ALU2    16
# define GRAAL_RDS_TALU2   17
# define GRAAL_RDS_VIA2    18
# define GRAAL_RDS_ALU3    19
# define GRAAL_RDS_TALU3   20
# define GRAAL_RDS_VIA3    21
# define GRAAL_RDS_ALU4    22
# define GRAAL_RDS_CPAS    23
# define GRAAL_RDS_REF     24
# define GRAAL_RDS_ABOX    25

# define GRAAL_RDS_MAX_LAYER ( GRAAL_RDS_ABOX + 1 )

# define GRAAL_VIEW_ARROWS_X     990
# define GRAAL_VIEW_ARROWS_Y      80
# define GRAAL_VIEW_ZOOM_X       990
# define GRAAL_VIEW_ZOOM_Y       230
# define GRAAL_VIEW_LAYER_X      430
# define GRAAL_VIEW_LAYER_Y      190
# define GRAAL_VIEW_GRID_X       470
# define GRAAL_VIEW_GRID_Y       330

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       Callback View Panel                   |
|                                                             |
\------------------------------------------------------------*/

  extern void CallbackLeftArrow();
  extern void CallbackRightArrow();
  extern void CallbackUpArrow();
  extern void CallbackDownArrow();
  extern void CallbackMoveSet();
  extern void CallbackCloseArrows();

  extern void CallbackZoomRefresh();
  extern void CallbackZoomPrevious();
  extern void CallbackZoomLess();
  extern void CallbackZoomMore();
  extern void CallbackZoomSet();
  extern void CallbackZoomIn();
  extern void CallbackZoomFit();
  extern void CallbackZoomCenter();
  extern void CallbackZoomGoto();
  extern void CallbackZoomPan();
  extern void CallbackCloseZoom();

  extern void CallbackLayerAllVisible();
  extern void CallbackLayerAllInvisible();
  extern void CallbackNameVisible();
  extern void CallbackNameInvisible();
  extern void CallbackLayerVisible();
  extern void CallbackLayerInvisible();
  extern void CallbackLayerApply();
  extern void CallbackCloseLayer();

  extern void GraalSetLayerVisible();
  extern void GraalSetLayerInvisible();
  extern void GraalSetNameVisible();
  extern void GraalSetNameInvisible();
  extern void GraalLayerAllVisible();
  extern void GraalLayerAllInvisible();

  extern void CallbackSetGridX();
  extern void CallbackSetGridY();
  extern void CallbackGridOnOff();
  extern void CallbackCloseGrid();

  extern void GraalInitializeLayer();

# endif 
