/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Error.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <stdlib.h>
# include <signal.h>
# include <setjmp.h>
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GSB_H 
# include GRM_H
# include "GRM_error.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  static FILE   *GraalStreamErr;
  static FILE   *GraalStreamOut;
  static FILE   *GraalStreamAll;

  static char    GraalErrFileName[ 40 ];
  static char    GraalOutFileName[ 40 ];
  static char    GraalAllFileName[ 40 ];

/*------------------------------------------------------------\
|                                                             |
|                      Graal Error Message                    |
|                                                             |
\------------------------------------------------------------*/

  static char *GraalErrorBuffer = (char *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                           Functions                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                 Graal Error Message Functions               |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                   GraalInitializeErrorMessage               |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeErrorMessage()
  {
    sprintf( GraalOutFileName, "/usr/tmp/out_%d",getpid() ); 
    sprintf( GraalErrFileName, "/usr/tmp/err_%d",getpid() );
    sprintf( GraalAllFileName, "/usr/tmp/all_%d",getpid() );

    GraalStreamAll = fopen  ( GraalAllFileName, "w+"        );
    GraalStreamOut = freopen( GraalOutFileName, "w+", stdout);
    GraalStreamErr = freopen( GraalErrFileName, "w+", stderr);

    if ( ( GraalStreamOut == (FILE *)NULL ) ||
         ( GraalStreamAll == (FILE *)NULL ) ||
         ( GraalStreamErr == (FILE *)NULL ) )
    {
      fprintf( stderr, "Grm: Unable to open trace window !\n");
      exit(1);
    }

    unlink( GraalOutFileName ); 
    unlink( GraalErrFileName );
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalFlushErrorMessage                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalFlushErrorMessage()
  {
    int Data;

    fflush( GraalStreamErr );
    fflush( GraalStreamOut );

    fseek( GraalStreamOut, 0L, 0 );
    fseek( GraalStreamErr, 0L, 0 );

    while( ( Data = fgetc( GraalStreamErr ) ) != EOF )
    {
      fputc( Data, GraalStreamAll );
    }

    while( ( Data = fgetc( GraalStreamOut ) ) != EOF )
    {
      fputc( Data, GraalStreamAll );
    } 

    fclose( GraalStreamOut );
    fclose( GraalStreamErr );

    GraalStreamOut = freopen( GraalOutFileName, "w+", stdout );
    GraalStreamErr = freopen( GraalErrFileName, "w+", stderr );
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalGetErrorMessage                   |
|                                                             |
\------------------------------------------------------------*/

  char *GraalGetErrorMessage()
  {
    char *Message;
    long  Length;
    long  Index;
    int   Data;

    GraalFlushErrorMessage();

    fflush( GraalStreamAll );

    Length = ftell( GraalStreamAll );

    if ( GraalErrorBuffer != (char *)NULL )
    {
      mbkfree( GraalErrorBuffer );
    }

    GraalErrorBuffer = mbkalloc( Length + 1 );
    Index            = 0;

    while ( ( ( Data = fgetc( GraalStreamAll ) ) != EOF ) &&
            ( Index  < Length ) )
    {
      GraalErrorBuffer[ Index++ ] = (char)Data;
    }

    rewind( GraalStreamAll );

    GraalErrorBuffer[ Index ] = '\0';

    if ( Index == 0 )
    {
      Message = (char *)NULL;
    }
    else
    {
      Message = GraalErrorBuffer;
    }

    return( Message );
  }
