/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Select.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GSB_H
# include "GRM_window.h"
# include "GRM_select.h"

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  graalselect *GraalHeadSelect  = (graalselect *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       Alloc Functions                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        GraalAllocSelect                     |
|                                                             |
\------------------------------------------------------------*/

   graalselect *GraalAllocSelect()
   {
     return((graalselect *)rdsalloc(sizeof(graalselect), 1));
   }

/*------------------------------------------------------------\
|                                                             |
|                        Free Functions                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         GraalFreeSelect                     |
|                                                             |
\------------------------------------------------------------*/
  
  void GraalFreeSelect( FreeSelect )

     graalselect *FreeSelect;
  {
    rdsfree((char *)FreeSelect, sizeof(graalselect));
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalAcceptRectangle                  |
|                                                             |
\------------------------------------------------------------*/
 
  void GraalAcceptRectangle( Rectangle )
 
    rdsrec_list *Rectangle;
  {
    rdsrec_list *ScanRec;
 
    ScanRec = Rectangle;
 
    do
    {
      SetGraalAccepted( ScanRec );
 
      ScanRec = (rdsrec_list *)ScanRec->USER;
    }
    while( Rectangle != ScanRec );
  }

/*------------------------------------------------------------\ 
|                                                             | 
|                       GraalRejectRectangle                  | 
|                                                             |
\------------------------------------------------------------*/ 
  
  void GraalRejectRectangle( Rectangle ) 
  
    rdsrec_list *Rectangle;
  { 
    rdsrec_list *ScanRec; 
  
    ScanRec = Rectangle;
  
    do
    { 
      ClearGraalAccepted( ScanRec ); 
  
      ScanRec = (rdsrec_list *)ScanRec->USER;
    } 
    while( Rectangle != ScanRec ); 
  } 

/*------------------------------------------------------------\
|                                                             |
|                       GraalSelectRectangle                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalSelectRectangle( Rectangle )

    rdsrec_list *Rectangle;
  {
    rdsrec_list *ScanRec;

    ScanRec = Rectangle;

    do
    {
      SetGraalSelected( ScanRec );

      ScanRec = (rdsrec_list *)ScanRec->USER;
    }
    while( Rectangle != ScanRec );
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalUnselectRectangle                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalUnselectRectangle( Rectangle )

    rdsrec_list *Rectangle;
  {
    rdsrec_list *ScanRec;

    ScanRec = Rectangle;

    do
    {
      ClearGraalSelected( ScanRec );

      ScanRec = (rdsrec_list *)ScanRec->USER;
    }
    while( Rectangle != ScanRec );
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalDeleteRectangle                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalDeleteRectangle( Rectangle )

    rdsrec_list *Rectangle;
  {
    rdsrec_list *ScanRec;

    ScanRec = Rectangle;

    do
    { 
      SetGraalDeleted( ScanRec );

      ScanRec = (rdsrec_list *)ScanRec->USER;
    }
    while( Rectangle != ScanRec );
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalUndeleteRectangle                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalUndeleteRectangle( Rectangle )

    rdsrec_list *Rectangle;
  {
    rdsrec_list *ScanRec;

    ScanRec = Rectangle;

    do
    { 
      ClearGraalDeleted( ScanRec );

      ScanRec = (rdsrec_list *)ScanRec->USER;
    }
    while( Rectangle != ScanRec );
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalAddSelect                        |
|                                                             |
\------------------------------------------------------------*/

   void GraalAddSelect( Rectangle )

      rdsrec_list *Rectangle;
   {
     graalselect *Select;

     Select = GraalAllocSelect();

     Select->RECTANGLE = Rectangle;
     Select->NEXT      = GraalHeadSelect;
     GraalHeadSelect   = Select;

     GraalSelectRectangle( Rectangle );
   }

/*------------------------------------------------------------\
|                                                             |
|                       GraalDelSelect                        |
|                                                             |
\------------------------------------------------------------*/

  void GraalDelSelect()
  {
    graalselect    *DelSelect;
    graalselect    *Select;

    Select          = GraalHeadSelect;
    GraalHeadSelect = (graalselect *)NULL;

    while( Select != (graalselect *)NULL )
    {
      GraalRejectRectangle( Select->RECTANGLE );

      DelSelect  = Select;
      Select     = Select->NEXT;
      
      GraalFreeSelect( DelSelect );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalPurgeSelect                      |
|                                                             |
\------------------------------------------------------------*/

  void GraalPurgeSelect()
  {
    graalselect    *DelSelect;
    graalselect    *Select;
    graalselect   **Previous;

    Previous = &GraalHeadSelect;
    Select   =  GraalHeadSelect;

    while( Select != (graalselect *)NULL )
    {
      if ( ! IsGraalAccepted( Select->RECTANGLE ) )
      {
        DelSelect  = Select;
        Select     = Select->NEXT;
        *Previous  = Select;
      
        GraalFreeSelect( DelSelect );
      }
      else
      {
        Previous = &Select->NEXT;
        Select   = Select->NEXT;
      }
    }
  }
