/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Undo.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GSB_H
# include "GRM_window.h"
# include "GRM_undo.h"

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  graalundo *GraalHeadUndo = (graalundo *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       Alloc Functions                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        GraalAllocUndo                       |
|                                                             |
\------------------------------------------------------------*/

   graalundo *GraalAllocUndo()
   {
     return((graalundo *)rdsalloc(sizeof(graalundo), 1));
   }

/*------------------------------------------------------------\
|                                                             |
|                      GraalAllocUndoRec                      |
|                                                             |
\------------------------------------------------------------*/

   graalundorec *GraalAllocUndoRec()
   {
     return((graalundorec *)rdsalloc(sizeof(graalundorec), 1));
   }

/*------------------------------------------------------------\
|                                                             |
|                        Free Functions                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         GraalFreeUndo                       |
|                                                             |
\------------------------------------------------------------*/
  
  void GraalFreeUndo( FreeUndo )

     graalundo *FreeUndo;
  {
    rdsfree((char *)FreeUndo, sizeof(graalundo));
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalFreeUndoRec                      |
|                                                             |
\------------------------------------------------------------*/

  void GraalFreeUndoRec( FreeUndoRec )

     graalundorec *FreeUndoRec;
  {
    rdsfree((char *)FreeUndoRec, sizeof(graalundorec));
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalAddUndoRec                       |
|                                                             |
\------------------------------------------------------------*/

   void GraalAddUndoRec( Rectangle )

      rdsrec_list *Rectangle;
   {
     graalundorec *UndoRec;

     UndoRec             = GraalAllocUndoRec();
     UndoRec->RECTANGLE  = Rectangle;
     UndoRec->NEXT       = GraalHeadUndo->UNDO;
     GraalHeadUndo->UNDO = UndoRec;
   }

/*------------------------------------------------------------\
|                                                             |
|                       GraalAddUndo                          |
|                                                             |
\------------------------------------------------------------*/

  void GraalAddUndo()
 
  {
    graalundo *NewUndo;

    NewUndo       = GraalAllocUndo();
    NewUndo->NEXT = GraalHeadUndo;
    GraalHeadUndo = NewUndo;

    GraalRecomputeBound = GRAAL_TRUE;
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalDelUndo                          |
|                                                             |
\------------------------------------------------------------*/

  char GraalDelUndo()

  {
    graalundo    *OldUndo;
    graalundorec *UndoRec;
    graalundorec *DelUndoRec;

    if ( GraalHeadUndo == (graalundo *)NULL )
    {
      return( GRAAL_FALSE );
    }

    OldUndo       = GraalHeadUndo;
    GraalHeadUndo = GraalHeadUndo->NEXT;

    UndoRec       = OldUndo->UNDO;

    while( UndoRec != (graalundorec *)NULL )
    {
      DelUndoRec = UndoRec;
      UndoRec    = UndoRec->NEXT;
      
      GraalFreeUndoRec( DelUndoRec );
    }

    GraalFreeUndo( OldUndo );

    return( GRAAL_TRUE );
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalInitializeUndo                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeUndo()

  {
    while( GraalDelUndo() != GRAAL_FALSE );
  }
