/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                 Gsb Errors                        |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.08.93                        |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include MUT_H
# include MPH_H
# include RDS_H
# include RUT_H
# include RPR_H
# include GSB_H
# include "GSB_error.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  void GsbError( ErrorType, Message, Data )

       char  ErrorType; 
       char *Message;
       long  Data;
  {
	 fflush(stdout);

    switch ( ErrorType ) 
    {
      case DEFINE_MISSING : 

        fprintf( stderr, "Gsb: Some defines missing\n");
        break;

      case TABLE_MISSING  : 
 
        fprintf( stderr, "Gsb: Some tables missing\n");
        break;

      case LINE_EXPECTED  :
 
        fprintf( stderr, "Gsb: %s expected line %lu\n", 
        Message, Data );
        break;

      case UNKNOWN_DEFINE : 

        fprintf( stderr, "Gsb: Unknown define %s line %lu\n",
        Message, Data );
        break;

      case NOT_DEFINED    : 

        fprintf( stderr, "Gsb: %s not defined line %lu\n",
        Message, Data );
        break;

      case TOO_SMAL       :

        fprintf( stderr, "Gsb: %s too smal line %lu\n",
        Message, Data );
        break;

      case MISSING_VALUE  :

        fprintf( stderr, "Gsb: Missing value at line %lu\n",
        Data );
        break;

      case MISSING_NAME   :

        fprintf( stderr, "Gsb: Missing name of %s line %lu\n",
        Message, Data );
        break;

      case UNEXPECTED_LINE :

        fprintf( stderr, "Gsb: %s unexpected line %lu\n",
        Message, Data );
        break;

      case UNEXPECTED_EOF  :

        fprintf( stderr, "Gsb: Unexpected end of file, missing definitions\n");
        break;

      case TOO_MANY_WORDS  :

        fprintf( stderr, "Gsb: Too many words %s unexpected line %lu\n",
        Message, Data );
        break;

      case MISSING_TABLE  :

        fprintf( stderr, "Gsb: Missing value in %s table line %lu\n",
        Message, Data );
        break;

      case OPEN_FILE      :

        fprintf( stderr, "Gsb: Parameters file %s can't be opened\n", 
        Message );
        break;

      case UNKNOWN_TABLE  :

        fprintf( stderr, "Gsb: Unknown table %s line %lu\n",
        Message , Data );
        break;

      case SYNTAX_ERROR   :

        fprintf( stderr, "Gsb: Syntax Error %s at line %lu\n", 
        Message , Data );
        break;

      case ILLEGAL_FLOAT  :

        fprintf( stderr, "Gsb: Illegal floating point number %s line %lu\n", 
        Message , Data );
        break;
    }

    exit( 1 );
  }
