/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Share.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RUT_H
# include RPR_H
# include GSB_H
# include "GSB_share.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  char GRAAL_RDS_ACTIVE_LAYER_TABLE[ RDS_MAX_LAYER ] =

  {
    1,  /* RDS_NWELL */
    1,  /* RDS_PWELL */
    1,  /* RDS_NIMP  */
    1,  /* RDS_PIMP  */
    1,  /* RDS_ACTIV */
    1,  /* RDS_NDIF  */
    1,  /* RDS_PDIF  */
    1,  /* RDS_NTIE  */
    1,  /* RDS_PTIE  */
    1,  /* RDS_POLY  */
    1,  /* RDS_GATE  */
    1,  /* RDS_TPOLY */
    1,  /* RDS_CONT  */
    1,  /* RDS_ALU1  */
    1,  /* RDS_TALU1 */
    1,  /* RDS_VIA1  */
    1,  /* RDS_ALU2  */
    1,  /* RDS_TALU2 */
    1,  /* RDS_VIA2  */
    1,  /* RDS_ALU3  */
    1,  /* RDS_TALU3 */
    1,  /* RDS_VIA3  */
    1,  /* RDS_ALU4  */
    1,  /* RDS_CPAS  */
    1,  /* RDS_REF   */
    1,  /* RDS_USER0 */
    1,  /* RDS_USER1 */
    1,  /* RDS_USER2 */
    1   /* RDS_ABOX  */
  };

  char GRAAL_RDS_ACTIVE_NAME_TABLE[ GRAAL_MAX_ACTIVE_NAME ] = 

  {
    1, /* FIGURE             NAME */
    1, /* INSTANCE           NAME */
    1, /* FIGURE CONNECTOR   NAME */
    1, /* INSTANCE CONNECTOR NAME */
    1, /* FIGURE SEGMENT     NAME */
    1, /* INSTANCE SEGMENT   NAME */
    1, /* FIGURE REFERENCE   NAME */
    1  /* INSTANCE REFERENCE NAME */
  };

/*------------------------------------------------------------\
|                                                             |
|                       Cut Transistor Table                  |
|                                                             |
\------------------------------------------------------------*/

  static long GRAAL_CUT_C_X_PARAM[ 5 ];

  /* 0 -> Constant 0    */
  /* 1 -> Nothing to do */
  /* 2 -> D             */
  /* 3 -> ( D + d ) / 2 */
  /* 4 -> ( D - d ) / 2 */

  long GRAAL_CUT_C_X_N_TABLE [ 16 ] [ 4 ] [ 4 ] =

  {
    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O   */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 2 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O   */
    { { 0, 0, 2, 4 }, { 0, 3, 4, 4 }, { 3, 4, 4, 3 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O   */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 2 }, { 0, 3, 3, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O   */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 2 }, { 0, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O-- */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 4, 0, 3, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 4 }, { 4, 3, 3, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O-- */
    { { 0, 0, 2, 4 }, { 0, 3, 2, 4 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O-- */
    { { 0, 0, 2, 4 }, { 0, 3, 4, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O-- */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 4 }, { 0, 3, 2, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O-- */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 4 }, { 0, 3, 4, 4 }, { 3, 3, 4, 4 } }, /*   |   */

  };

  long GRAAL_CUT_C_X_P_TABLE [ 16 ] [ 4 ] [ 4 ] =

  {
    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O   */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 2 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O   */
    { { 0, 0, 2, 4 }, { 0, 3, 4, 4 }, { 3, 4, 4, 3 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O   */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 2 }, { 0, 3, 3, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O   */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 2 }, { 0, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O-- */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 4, 0, 3, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 4 }, { 4, 3, 3, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O-- */
    { { 0, 0, 2, 4 }, { 0, 3, 2, 4 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O-- */
    { { 0, 0, 2, 4 }, { 0, 3, 4, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O-- */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 4 }, { 0, 3, 2, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O-- */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 4 }, { 0, 3, 4, 4 }, { 3, 3, 4, 4 } }, /*   |   */

  };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      GraalPostTreatString                   |
|                                                             |
\------------------------------------------------------------*/

  char *GraalPostTreatString( Text )

    char *Text;
  {
    char OnlySpace;
    int  Counter;

    if ( Text != (char *)NULL )
    {
      OnlySpace = 1;

      for ( Counter = 0; Text[ Counter ]; Counter++ )
      {
        if ( Text[ Counter ] != ' ' ) OnlySpace = 0;
      }

      if ( OnlySpace ) Text = (char *)NULL;
    }

    return( Text );
  }

/*------------------------------------------------------------\
|                                                             |
|                  GraalInitializeCutCxTable                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeCutCxTable()

  {
    int   Index;    
    long  DeltaGate;
    long  DeltaDiff;
    char  Layer;
    long *Table;
 
    DeltaGate = -1;
    DeltaDiff = -1;
    Index     = 0;
    Layer     = GET_VIA_LAYER( C_X_N, Index );

    while ( Layer != RDS_VIA_EMPTY )
    {
      if ( Layer == RDS_GATE )
      {
        DeltaGate = GET_VIA_SIZE( C_X_N, Index );
      }
      else
      if ( Layer == RDS_NDIF )   
      {
        DeltaDiff = GET_VIA_SIZE( C_X_N, Index );
      }

      Index = Index + 1;

      Layer = GET_VIA_LAYER( C_X_N, Index );
    }

    Table = GRAAL_CUT_C_X_N_TABLE[0][0];

    if ( ( DeltaGate == -1 ) || 
         ( DeltaDiff == -1 ) )
    {
      for ( Index = 0; Index < 256; Index++ )
      {  
        Table[ Index ] = -1;
      }
    }
    else
    {
      /* 0 -> Constant 0    */
      /* 1 -> Nothing to do */
      /* 2 -> D             */
      /* 3 -> ( D + d ) / 2 */
      /* 4 -> ( D - d ) / 2 */
       
      GRAAL_CUT_C_X_PARAM[ 0 ] =  0;
      GRAAL_CUT_C_X_PARAM[ 1 ] = -1;
      GRAAL_CUT_C_X_PARAM[ 2 ] = DeltaDiff;
      GRAAL_CUT_C_X_PARAM[ 3 ] = ( DeltaDiff + DeltaGate ) >> 1;
      GRAAL_CUT_C_X_PARAM[ 4 ] = ( DeltaDiff - DeltaGate ) >> 1;

      for ( Index = 0; Index < 256; Index++ )
      {
        Table[ Index ] = GRAAL_CUT_C_X_PARAM[ Table[ Index ] ];
      }
    }

    DeltaGate = -1;
    DeltaDiff = -1;
    Index     = 0;
    Layer     = GET_VIA_LAYER( C_X_P, Index );

    while ( Layer != RDS_VIA_EMPTY )
    {
      if ( Layer == RDS_GATE )
      {
        DeltaGate = GET_VIA_SIZE( C_X_P, Index );
      }
      else
      if ( Layer == RDS_PDIF )
      {
        DeltaDiff = GET_VIA_SIZE( C_X_P, Index );
      }

      Index = Index + 1;

      Layer = GET_VIA_LAYER( C_X_P, Index );
    }

    Table = GRAAL_CUT_C_X_P_TABLE[0][0];

    if ( ( DeltaGate == -1 ) ||
         ( DeltaDiff == -1 ) )
    {
      for ( Index = 0; Index < 256; Index++ )
      {
        Table[ Index ] = -1;
      }
    }
    else
    {
      /* 0 -> Constant 0    */
      /* 1 -> Nothing to do */
      /* 2 -> D             */
      /* 3 -> ( D + d ) / 2 */
      /* 4 -> ( D - d ) / 2 */

      GRAAL_CUT_C_X_PARAM[ 0 ] =  0;
      GRAAL_CUT_C_X_PARAM[ 1 ] = -1;
      GRAAL_CUT_C_X_PARAM[ 2 ] = DeltaDiff;
      GRAAL_CUT_C_X_PARAM[ 3 ] = ( DeltaDiff + DeltaGate ) >> 1;
      GRAAL_CUT_C_X_PARAM[ 4 ] = ( DeltaDiff - DeltaGate ) >> 1;

      for ( Index = 0; Index < 256; Index++ )
      {
        Table[ Index ] = GRAAL_CUT_C_X_PARAM[ Table[ Index ] ];
      }
    }
  }
