/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Pixmap.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

# include <Xm/Xm.h>
# include <X11/Intrinsic.h>
# include GTB_H

# include "GTB_pixmap.h"

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     GraalCreatePixmap                       |
|                                                             |
\------------------------------------------------------------*/

  Pixmap GraalCreatePixmap( MainWidget, IconBits, IconWidth, IconHeight )

         Widget  MainWidget;
         char   *IconBits;
         int     IconWidth;
         int     IconHeight;
  {
    Pixel  Foreground;
    Pixel  Background;
    Pixmap IconPixmap;

    XtVaGetValues( MainWidget, XmNforeground, &Foreground, 
                               XmNbackground, &Background, NULL );

    IconPixmap = XCreatePixmapFromBitmapData( XtDisplay( MainWidget ),
                                              RootWindowOfScreen( XtScreen( MainWidget ) ), 
                                              IconBits, IconWidth, IconHeight,
                                              Foreground, Background,
                                              DefaultDepthOfScreen( XtScreen( MainWidget ) ) );

    return( IconPixmap );
  }

