/*******************************************************************************
* Grog : generic rom generator                                                 *
*                                                                              *
* Architecture and leaf cells defined at Bull's research center at les Clayes  *
*                                                                              *
* Leaf cells modifications to meet idps design rules                           *
* version 0.0 on April/June 1992, Frederic Petrot                              *
*                                                                              *
* All programming in Genlib                                                    *
* version 0.0 on April/June 1992, Frederic Petrot                              *
*                                                                              *
* version 0.1, by Frederic Petrot                                              *
*                                                                              *
*******************************************************************************/

#include "genlib.h"
#include "grog.h"

void grognetlist(name, nb, nw, hz, msb)
char *name;
long nb, nw, hz, msb;
{
long i;

	DEF_LOFIG(name);
	if (!msb)
	LOCON(BUS("adr", ln2p(nw) - 1L, 0L), IN, BUS("adr", ln2p(nw) - 1L, 0L));
	else
	LOCON(BUS("adr", 0L, ln2p(nw) - 1L), IN, BUS("adr", 0L, ln2p(nw) - 1L));
   if (nw == 64)
      LOCON("ck", IN, "ck");
   else if (nw == 128 || nw == 256)
      LOCON("ck[0:1]", IN, "ck[0:1]");
   else for (i = 0; i < nw / 512; i += 2)
      LOCON(ELM("ck", i / 2), IN, ELM("ck", i / 2));
	LOCON(BUS("f", 0L, nb - 1L), OUT, BUS("f", 0L, nb - 1L));
	if (hz)
		LOCON("oe", IN, "oe");
	LOCON("vdd", IN, "vdd");
	LOCON("vss", IN, "vss");
	SAVE_LOFIG();
}
