/*------------------------------------------------------------\
|                                                             |
| Tool    :                   LYNX                            |
|                                                             |
| File    :                  cut.h                            |
|                                                             |
| Authors :               Jacomme Ludovic                     |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef LYNX_CUT 

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# define LYNX_CUT            (long)0x00200000
# define LYNX_DELETED        (long)0x00400000

/*------------------------------------------------------------\
|                                                             |
|                            Macros                           |
|                                                             |
\------------------------------------------------------------*/

# define IsLynxCut( Rectangle )            \
                                           \
   ( ( Rectangle )->FLAGS & LYNX_CUT       )

# define SetLynxCut( Rectangle )           \
                                           \
   ( ( Rectangle )->FLAGS |= LYNX_CUT      )

# define ClearLynxCut( Rectangle )         \
                                           \
   ( ( Rectangle )->FLAGS &= ~LYNX_CUT     )


# define IsLynxDeleted( Rectangle )        \
                                           \
   ( ( Rectangle )->FLAGS & LYNX_DELETED   )

# define SetLynxDeleted( Rectangle )       \
                                           \
   ( ( Rectangle )->FLAGS |= LYNX_DELETED  )

# define ClearLynxDeleted( Rectangle )     \
                                           \
   ( ( Rectangle )->FLAGS &= ~LYNX_DELETED )

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern long  LynxCutTransistorElbow();


# endif
