/*------------------------------------------------------------\
|                                                             |
| Tool    :                   LYNX                            |
|                                                             |
| File    :                  netlist.h                        |
|                                                             |
| Authors :               Jacomme Ludovic                     |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef LYNX_NETLIST
# define LYNX_NETLIST

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# define LYNX_BAD              0
# define LYNX_GOOD             1

# define LYNX_TREAT_TRANSISTOR (long)0x00800000

/*------------------------------------------------------------\
|                                                             |
|                            Macros                           |
|                                                             |
\------------------------------------------------------------*/

# define IsLynxTreatTransistor( Rectangle )         \
                                                    \
   ( ( Rectangle )->FLAGS & LYNX_TREAT_TRANSISTOR   )

# define SetLynxTreatTransistor( Rectangle )        \
                                                    \
   ( ( Rectangle )->FLAGS |= LYNX_TREAT_TRANSISTOR  )

# define ClearLynxTreatTransistor( Rectangle )      \
                                                    \
   ( ( Rectangle )->FLAGS &= ~LYNX_TREAT_TRANSISTOR )

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern long  LynxBuildLogicalSignal();
  extern long  LynxBuildLogicalInstance();
  extern long  LynxBuildLogicalTransistor();
  extern char *LynxVectorizeConnector();

# endif
