/*------------------------------------------------------------\
|                                                             |
| Tool    :                   LYNX                            |
|                                                             |
| File    :                  Parse.c                          |
|                                                             |
| Author  :               Jacomme Ludovic                     |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>

# include MUT_H
# include MLO_H
# include MPH_H
# include RDS_H

# include "share.h"
# include "parse.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  chain_list *LynxScanEqui = (chain_list *)NULL;

  static char LynxBuffer[ 256 ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        IsLynxScanEqui                       |
|                                                             |
\------------------------------------------------------------*/

  char IsLynxScanEqui( LynxEqui, Name )

     chain_list *LynxEqui;
     char       *Name;
  {
    chain_list *Index;

    for ( Index  = LynxEqui;
          Index != (chain_list *)NULL;
          Index  = Index->NEXT )
    {
      if ( (char *)(Index->DATA) == Name ) break;
    }

    return ( Index != (chain_list *)NULL );
  }

/*------------------------------------------------------------\
|                                                             |
|                         LynxParseEqui                       |
|                                                             |
\------------------------------------------------------------*/

  char  LynxParseEqui()

  {
    FILE *LynxFile;

    if ( ( LynxFile = fopen( "LYNX_EQUI", "r" ) ) == (FILE *)NULL )

      return( 0 );

    while (  fgets( LynxBuffer, LYNX_BUFFER_SIZE, LynxFile ) != (char *)NULL )
    {
      LynxBuffer[ strlen( LynxBuffer ) - 1 ] = '\0';

      LynxScanEqui = addchain( LynxScanEqui,
                               (void *)namealloc( LynxBuffer ) );
    }

    fclose( LynxFile );

    return ( LynxScanEqui != (chain_list *)NULL );
  }
