/************************************************************************
*       MBK : Parser alliance logic                                     *
*                                                                       *
*	version : 4.03					                                    *
*	date	: 23/09/93				                                    *
************************************************************************/

#include <ctype.h>
#include <string.h>
#include "generic_target.h"
#include MUT_H
#include MLO_H
#include MLU_H

#ident "@(#)Parser alliance logic v4.03 23/09/93 by Vincent POUILLEY"

#define TAILLE_CHAINE BUFSIZE

/************************************************************************
*                  alc_directiondecode()                                *
************************************************************************/
char alc_directiondecode(dir)
char * dir;
{
	switch (dir[2])
	{
		case 'O' :
			return 'B';
		case 'K' :
			return 'X';
		case 'I' :
			return 'Z';
		case 'A' :
			return 'T';
		default :
			return dir[0];
	}
}

/************************************************************************
*                  alcloadlofig()                                       *
************************************************************************/

void alcloadlofig(pfig,fname,mode)
lofig_list * pfig;
char * fname;
char mode;
{
	FILE *in;
	char ligne[50];
	char nomfic[TAILLE_CHAINE];
	long i;
	
	(void)sprintf(nomfic,"%s/%s.%s",WORK_LIB,fname,IN_LO);
	if ((in=mbkfopen(fname, IN_LO ,READ_TEXT)) == NULL)
	{
		(void)fprintf(stderr,"\n*** mbk error *** Unable to open file : %s\n",nomfic);
		EXIT(1);
	}
	if (TRACE_MODE == 'Y')
	{
		(void)printf("\n--- mbk --- parsing file : %s\n",nomfic);
	}
	(void)fgets(ligne,50,in);
	i=0;
	(void)sscanf(ligne,"V ALLIANCE 2.2 SETUP : %d",&i);
	if (i==3)
		alcloadlofig3 (pfig, fname, mode, in);
	else
	{
		(void)sscanf(ligne,"V ALLIANCE : %d", &i);
		if (i == 4)
			alcloadlofig4 (pfig, fname, mode, in);
		else
		{
			(void)fprintf(stderr,"\n*** mbk error *** unable to load file %s, too old version\n", fname);
			EXIT(1);
		}
	}
	if (fclose(in) != 0)
	{
		(void)fprintf(stderr,"\n*** mbk error *** can't close file : %s\n",nomfic);
		EXIT(1);
	}
}

