/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur Logique                                       */
/*    Fichier :  fp_type.h                                                  */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 16/07/1991     */
/*                                                                          */
/*    Modifie par :                                     le : 14/09/1992     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#ifdef LAX
#define PRINTF LXU_PrintMSG
#else
#define PRINTF printf
#endif

#define FP_SYS fp_sys
#define FP_VHDL fp_sys->fileVhdl
#define FP_FILE fp_sys->file
#define FP_FILEPAR fp_sys->filePar
#define FP_PARAM fp_sys->fileParam
#define FP_PAR fp_sys->par
#define FP_BEH fp_sys->beh
#define FP_MODE fp_sys->mode
#define FP_VERSION fp_sys->version
#define FP_OPTION fp_sys->option
#define FP_FAMILY fp_sys->family
#define RULES_DC fp_sys->dc

#define FP_NAME (fp_sys->beh)->NAME
#define FP_CIRCUIT (fp_sys->beh)->CIRCUI
#define FP_PI (fp_sys->beh)->BERIN

#define FP_OPTIM (fp_sys->par)->mode
#define FP_AUX (fp_sys->par)->aux
#define FP_GUARDEDAUX (fp_sys->par)->intermediate
#define FP_LEVEL (fp_sys->par)->level
#define FP_OPTIMPO (fp_sys->par)->earlyPO
#define FP_DELAYPI (fp_sys->par)->delayPI
#define FP_NUMTRANSN (fp_sys->par)->numTransN
#define FP_NUMTRANSP (fp_sys->par)->numTransP

#define FP_ORDER fp_sys->order
#define FP_ORDERPI fp_sys->orderPI

	/* define correspondant aux variables d'environnement */

#define FP_BEH_LIB fp_sys->beh_lib
#define FP_PAR_LIB fp_sys->par_lib
#define FP_TRACE fp_sys->trace
#define FP_NAME_LOG fp_sys->name_log
#define FP_MAKEORDER fp_sys->makeOrder
#define FP_BANN fp_sys->banniere

	
#define X3000 1
#define X4000 2
#define ACT1 3
#define ACT2 4
#define XNODE 5

/*-------------- systeme pour la synthese logique ---------------

  fileVhdl	: identificateur du fichier contenant l'architecture
  fileParam	: fichier de parametres
  par		: pointeur sur la structure contenant les parametres
  beh		: pointeur sur la befig de l'architecture compilee  
  mode		: mode batch ou non.
  version       : outil et numero de version
  option	: option en batch "o" "l"
  family        : famille X3000, X4000, ACT1 ou ACT2
-----------------------------------------------------------------*/

typedef struct fp_syst {
    	char *file;
    	char *filePar;
	char *fileParam;
	char *fileVhdl;
	param *par;
	befig_list *beh;
        int mode;
        char *version;
	char option;
	int family;
	int order;
	chain_list *orderPI;

		/* variable d'environnement */

	char *beh_lib;
	char *par_lib;
	int  trace;
        int  name_log;
        int  makeOrder;
        int  banniere;
        int  dc;
	} fp_system;

fp_system *fp_sys;
chain_list *ptr_ctrlst;
fp_system *initializeFPSystem();
param *initializeParam();

extern char BVL_ERRFLG;
extern int BVL_LINNUM;
befig_list *VHB_HEDFIG;
param *initializeFPParam();
