/****************************************************************************/;
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  NetOptim                                                   */
/*    Fichier :  no_optim.h                                                 */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : N. Dictus                             le : 10/04/1992     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

typedef struct dchain
{
        struct dchain *SUIV;
        struct dchain *PRED;
        void *DATA;
} dchain_list;

typedef struct sol
        {
        short		TYPE;
        long		DIFFCIN;
        long		SURFACE;
        long		SUMCIN;
        ptype_list 	*NAME;
        ptype_list 	*ARBRE;
        short		NOMBRE;
        char		*ADAPT;
        struct sol	*NEXT;
        } sol_list;

#define MAX(x,y) ((x) > (y)) ? (x) : (y)
#define MIN(x,y) ((x) < (y)) ? (x) : (y)

#define BUN 0
#define BUF 1
#define DUP 2
#define PROF 52

	/* TH des instances dont les retards sont a remettre a jour */
pTH RAZTH;
pTH dejaTraite;

chain_list *addmodel();
void clearmodel();
char *adaptePuissance();
void addPuissante();
loins_list *addBufferCond();
loins_list *addBuffer();
void dupliqueInst();
void freeSol();
sol_list *triInstance();
void addConDir();
void calculProf();
void profondeur();
int statistics();
long capaNot();
ptype_list *triConptype();
void capaEntrees();
void optimEntrees();
void optimiseInst();
void optimFanMax();
void mainInfo();
void mainOptimFanMax();
void mainOptimGlobal();
