
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: pat_addpagrp.c					*/
/* date		: Jul 16 1993						*/
/* version	: v104							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: low-level pat function				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H
#include PAT_H

/* ###--------------------------------------------------------------### */
/* function	: pat_addpagrp						*/
/* description	: create a PAGRP (array of input-outputs) structure at	*/
/*		  the top of a list					*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct pagrp *pat_addpagrp (lastpagrp, name, length, index, flag)

struct pagrp   *lastpagrp;	/* pointer on the last pagrp structure	*/
char           *name;		/* array's name				*/
unsigned short  length;		/* array's number of bit		*/
unsigned short  index;		/* index of the first paiol of the array*/
short           flag;		/* actual or virtual (0,1) array	*/

  {
  struct pagrp *ptgrp;

  name          = namealloc (name);

  ptgrp         = (struct pagrp *) mbkalloc (sizeof(struct pagrp));
  ptgrp->NAME   = name;
  ptgrp->LENGTH = length;
  ptgrp->FINDEX = index;
  ptgrp->FLAG   = flag;
  ptgrp->NEXT   = lastpagrp;

  return (ptgrp);
  }
