
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: pat_addpapat.c					*/
/* date		: Jul 21 1993						*/
/* version	: v104							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: low-level pat function				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H
#include PAT_H

/* ###--------------------------------------------------------------### */
/* function	: pat_addpapat						*/
/* description	: create an empty PAPAT (pattern) structure at the top	*/
/*		  of a list						*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct papat *pat_addpapat (lastpapat, label, line)

struct papat   *lastpapat;	/* pointer on the last papat structure	*/
char           *label;		/* pattern's label			*/
unsigned short  line;		/* pattern' line number			*/

  {
  struct papat *ptpat;

  label          = namealloc (label);

  ptpat          = (struct papat *) mbkalloc (sizeof(struct papat));
  ptpat->LABEL   = label;
  ptpat->PAEVT   = NULL;
  ptpat->PAINI   = NULL;
  ptpat->LINE    = line;
  ptpat->BLANK   =  0 ;
  ptpat->ACTFLAG = 'U';
  ptpat->SIMFLAG = 'U';
  ptpat->NEXT    = lastpapat;

  return (ptpat);
  }
