
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: pat_addpaseq.c					*/
/* date		: Aug 17 1993						*/
/* version	: v104							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: low-level pat function				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H
#include PAT_H

/* ###--------------------------------------------------------------### */
/* function	: pat_addpaseq						*/
/* description	: create an empty PASEQ (sequence of patterns)		*/
/*		  structure at the top of a list			*/
/* called func.	: mbkalloc						*/
/* ###--------------------------------------------------------------### */

struct paseq *pat_addpaseq (lastpaseq)

struct paseq *lastpaseq;	/* pointer on the last paseq structure	*/

  {
  struct paseq *ptseq;

  ptseq           = (struct paseq *) mbkalloc (sizeof(struct paseq));

  ptseq->NAME     = NULL;
  ptseq->PAGRP    = NULL;
  ptseq->PAIOL    = NULL;
  ptseq->DECCOM   = NULL;
  ptseq->OLDPAT   = NULL;
  ptseq->OLDCOM   = NULL;
  ptseq->CURPAT   = NULL;
  ptseq->CURCOM   = NULL;
  ptseq->NXTPAT   = NULL;
  ptseq->PATNBR   = 0;
  ptseq->IOLNBR   = 0;
  ptseq->SUBSEQ   = 0;
  ptseq->LINENO   = 1;
  ptseq->SAVFLG   = 'N';
  ptseq->ENDFLG   = 'N';
  ptseq->DRVSEQ   = 0;
  ptseq->ERRFLG   = 1;

  ptseq->NEXT     = lastpaseq;

  return (ptseq);
  }
