
/*  A Bison parser, made from pat_decl.yac  */

#define YYBISON 1  /* Identify Bison output.  */

#define yyparse pat_declparse
#define yylex pat_lex
#define yyerror pat_declerror
#define yylval pat_decllval
#define yychar pat_declchar
#define yydebug pat_decldebug
#define	_IN	258
#define	_INOUT	259
#define	_LESym	260
#define	_OUT	261
#define	AbstractLit	262
#define	BitStringLit	263
#define	BEGIN_	264
#define	Colon	265
#define	Comma	266
#define	Comment	267
#define	DOWNTO	268
#define	Dot	269
#define	END_	270
#define	Format	271
#define	Identifier	272
#define	LeftParen	273
#define	Literal	274
#define	REGISTER	275
#define	RightParen	276
#define	SAVE	277
#define	SIGNAL	278
#define	Semicolons	279
#define	TO	280
#define	UnknownChar	281

#line 12 "pat_decl.yac"


#include <stdio.h>
#include MUT_H
#include PAT_H
#include "pat_defs.h"
#include "pat_type.h"
#include "pat_decl.h"

/* ###--------------------------------------------------------------### */
/* function	: yyerror						*/
/* description	: print an error message (errors detected by yacc)	*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static void yyerror (str)

char *str;
  {
  ERR_FLG += pat_error (18, str, ' ', LINNUM);
  }

/* ###--------------------------------------------------------------### */
/* function	: addiol						*/
/* description	: add a list of PAIOL structure at the top of the list	*/
/* called func.	: pat_addpaiol						*/
/* ###--------------------------------------------------------------### */

static struct paiol *addiol (lastiol, gname, format, mode, blank)

struct paiol *lastiol;
struct array  gname;
char          format;
char          mode;
short         blank;

  {
  struct paiol *ptiol = lastiol;
  char          extname[100];
  short         i;
  short         inc = 1;

  if (gname.left == -1)
    ptiol = pat_addpaiol (ptiol,gname.ident,format,mode,blank);
  else
    {
    if (gname.left >= gname.right)
      inc = -1;

    for (i=gname.left ; i!=(gname.right+inc) ; i+=inc)
      {
      sprintf (extname,"%s %d",gname.ident,i);
      ptiol = pat_addpaiol (ptiol,extname,format,mode,blank);
      }
    }

  return (ptiol);
  }

/* ###--------------------------------------------------------------### */
/* function	: pshtab						*/
/* description	: push a name on the TAB stack to build a virtual array	*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static void pshtab (gname)

struct array gname;

  {
  if (TAB_IDX > 256)
    ERR_FLG += pat_error (6, NULL, ' ', LINNUM);
  else
    {
    TAB [TAB_IDX] = gname;
    TAB_IDX++;
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: pshnam						*/
/* description	: push a name on the NAMTAB stack to build a		*/
/*		  hierarchical name					*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static void pshnam (str)

char *str;

  {
  if (NAM_IDX > 30)
    ERR_FLG += pat_error (14, NULL, ' ', LINNUM);
  else
    {
    NAMTAB [NAM_IDX] = str;
    NAM_IDX++;
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: initab						*/
/* description	: create a new dictionary				*/
/* called func.	: mbkalloc						*/
/* ###--------------------------------------------------------------### */

static struct entry **initab ()

  {
  struct entry **head;
  int            i;

  head = (struct entry **) mbkalloc (sizeof(struct entry *) * PAT_HSZDFN);

  for (i=0 ; i<PAT_HSZDFN ; i++)
    head[i] = NULL;

  return (head);
  }

/* ###--------------------------------------------------------------### */
/* function	: addent						*/
/* description	: add a new entry in a dictionary			*/
/* called func.	: mbkaloc						*/
/* ###--------------------------------------------------------------### */

static struct entry *addent (head, key)

struct entry *head;
char         *key;

  {
  struct entry *entry;
  int           i;

  if (ENTRY_HEAD == NULL)
    {
    ENTRY_HEAD = (struct entry *) mbkalloc (sizeof(struct entry) * PAT_ALODFN);

    entry = ENTRY_HEAD;
    for (i=1 ; i<PAT_ALODFN ; i++)
      {
      entry->next = entry + 1;
      entry++;
      }
    entry->next = NULL;
    }

  entry       = ENTRY_HEAD;
  ENTRY_HEAD  = ENTRY_HEAD->next;

  entry->next     = head;

  entry->fd0_val  = 0;
  entry->fd1_val  = 0;
  entry->pt0_val  = 0;
  entry->pt1_val  = 0;

  entry->key      = key;

  return (entry);
  }

/* ###--------------------------------------------------------------### */
/* function	: addtab						*/
/* description	: add a new information into a dictionary. If the key	*/
/*		  doesn't exist create a new entry			*/
/* called func.	: addent						*/
/* ###--------------------------------------------------------------### */

static void addtab (head, key_str, field, valu)

struct entry **head;
char          *key_str;
int            field;
int            valu;

  {
  int           found = 0;
  int           index;
  struct entry *entry_pnt;

  index     = (int) key_str % PAT_HSZDFN;
  entry_pnt = head[index];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 0)
    {
    head[index] = addent (head [index], key_str);
    entry_pnt   = head [index];
    }

  switch (field)
    {
    case 0 :
      entry_pnt->fd0_val = valu; break;
    case 1 :
      entry_pnt->fd1_val = valu; break;
    case 6 :
      entry_pnt->pt0_val = valu; break;
    case 7 :
      entry_pnt->pt1_val = valu; break;
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: chktab						*/
/* description	: extract an information from a dictionary. Return	*/
/*		  0 if the information has not been found.		*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static int chktab (head, key_str, field)

struct entry **head;
char          *key_str;
int            field;

  {
  int           found = 0;
  int           valu  = 0;
  struct entry *entry_pnt;

  entry_pnt = head [(int)key_str % PAT_HSZDFN];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 1)
    {
    switch (field)
      {
      case 0 :
        valu = entry_pnt->fd0_val; break;
      case 1 :
        valu = entry_pnt->fd1_val; break;
      case 6 :
        valu = entry_pnt->pt0_val; break;
      case 7 :
        valu = entry_pnt->pt1_val; break;
      }
    }

  return (valu);
  }

/* ###--------------------------------------------------------------### */
/* function	: fretab						*/
/* description	: remove entirely a dictionary				*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

static void fretab (pt_hash)

struct entry **pt_hash;
  {
  struct entry *pt_entry;
  int           i;

  if (pt_hash != NULL)
    {
    for (i=0 ; i<PAT_HSZDFN ; i++)
      {
      if ((pt_entry = pt_hash[i]) != NULL)
        {
        while (pt_entry->next != NULL)
          pt_entry = pt_entry->next;

        pt_entry->next = ENTRY_HEAD;
        ENTRY_HEAD     = pt_hash [i];
        }
      }
    mbkfree (pt_hash);
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: pat_declpat						*/
/* description	: parse a file in pat format and return a PASEQ		*/
/* called func.	: yyparse			 			*/
/* ###--------------------------------------------------------------### */

struct paseq *pat_declpat (fp, ptseq)

FILE           *fp;
struct paseq   *ptseq;

  {
  extern FILE *yyin;
  static int   call_nbr = 0;

  PAT_SEQPNT = ptseq;
  yyin       = fp;

  HSHTAB     = initab ();
  PAT_SEQPNT = pat_addpaseq (PAT_SEQPNT);

  PAT_COMPNT = NULL;
  PAT_GRPPNT = NULL;
  PAT_IOLPNT = NULL;
  LINNUM     = 1;
  STT_NBR    = 0;
  DCL_NBR    = 0;
  ERR_FLG    = 0;
  TAB_IDX    = 0;
  NAM_IDX    = 0;

  if (call_nbr != 0)
    yyrestart (yyin);

  yyparse ();
  call_nbr++;
  
  PAT_SEQPNT->DECCOM  = (struct pacom *) reverse (PAT_COMPNT);
  PAT_SEQPNT->PAGRP   = (struct pagrp *) reverse (PAT_GRPPNT);
  PAT_IOLPNT          = (struct paiol *) reverse (PAT_IOLPNT);
  PAT_SEQPNT->PAIOL   = pat_crtpaiol (PAT_IOLPNT);

  PAT_SEQPNT->LINENO  = LINNUM;
  PAT_SEQPNT->IOLNBR  = DCL_NBR;

  if (ERR_FLG == 0)
    PAT_SEQPNT->ERRFLG = 0;
  else
    PAT_SEQPNT->ERRFLG = 1;

  pat_frepaiol (PAT_IOLPNT);
  fretab (HSHTAB);

  return (PAT_SEQPNT);
  }


#line 362 "pat_decl.yac"
typedef union
  {
  int           valu;
  char          immd;
  char         *text;
  struct array  arra;
  } YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		51
#define	YYFLAG		-32768
#define	YYNTBASE	27

#define YYTRANSLATE(x) ((unsigned)(x) <= 281 ? yytranslate[x] : 46)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     3,     5,     7,    10,    12,    14,    17,    19,    21,
    23,    28,    36,    37,    39,    41,    45,    47,    49,    51,
    53,    58,    65,    68,    69,    73,    75,    77,    79,    81,
    83,    85,    87
};

#endif

static const short yyrhs[] = {    28,
     9,     0,    29,     0,    30,     0,    29,    30,     0,    32,
     0,    31,     0,     1,    45,     0,    12,     0,    33,     0,
    34,     0,    44,    37,    35,    45,     0,    44,    41,    18,
    36,    21,    35,    45,     0,     0,    16,     0,    37,     0,
    36,    11,    37,     0,    38,     0,    39,     0,    40,     0,
    41,     0,    41,    18,     7,    21,     0,    41,    18,     7,
    43,     7,    21,     0,    17,    42,     0,     0,    42,    14,
    17,     0,    25,     0,    13,     0,     3,     0,     6,     0,
     4,     0,    23,     0,    20,     0,    24,     0
};

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   409,   417,   421,   422,   427,   428,   429,   434,   442,   443,
   447,   488,   531,   533,   538,   540,   547,   549,   551,   556,
   565,   577,   591,   609,   610,   617,   618,   622,   624,   626,
   628,   630,   635
};

static const char * const yytname[] = {   "$","error","$illegal.","_IN","_INOUT",
"_LESym","_OUT","AbstractLit","BitStringLit","BEGIN_","Colon","Comma","Comment",
"DOWNTO","Dot","END_","Format","Identifier","LeftParen","Literal","REGISTER",
"RightParen","SAVE","SIGNAL","Semicolons","TO","UnknownChar","pat_format_file",
"declarative_block","..declaration_item..","declaration_item","other_statement",
"input_output_declaration","signal_declaration","group_declaration",".Format.",
"...name..","name","simple_name","indexed_name","slice_name","Identifier...Identifier..",
"...Identifier..","direction","mode","Semicolons_ERR",""
};
#endif

static const short yyr1[] = {     0,
    27,    28,    29,    29,    30,    30,    30,    31,    32,    32,
    33,    34,    35,    35,    36,    36,    37,    37,    37,    38,
    39,    40,    41,    42,    42,    43,    43,    44,    44,    44,
    44,    44,    45
};

static const short yyr2[] = {     0,
     2,     1,     1,     2,     1,     1,     2,     1,     1,     1,
     4,     7,     0,     1,     1,     3,     1,     1,     1,     1,
     4,     6,     2,     0,     3,     1,     1,     1,     1,     1,
     1,     1,     1
};

static const short yydefact[] = {     0,
     0,    28,    30,    29,     8,    32,    31,     0,     0,     3,
     6,     5,     9,    10,     0,    33,     7,     1,     4,    24,
    13,    17,    18,    19,    20,    23,    14,     0,     0,     0,
    11,     0,     0,    15,    20,    25,    27,    21,    26,     0,
     0,    13,     0,     0,    16,     0,    22,    12,     0,     0,
     0
};

static const short yydefgoto[] = {    49,
     8,     9,    10,    11,    12,    13,    14,    28,    33,    21,
    22,    23,    24,    35,    26,    40,    15,    17
};

static const short yypact[] = {     3,
   -23,-32768,-32768,-32768,-32768,-32768,-32768,     5,    -1,-32768,
-32768,-32768,-32768,-32768,     1,-32768,-32768,-32768,-32768,-32768,
    13,-32768,-32768,-32768,    -2,    17,-32768,   -23,    10,    15,
-32768,     0,     9,-32768,    16,-32768,-32768,-32768,-32768,    26,
     1,    13,    28,    18,-32768,   -23,-32768,-32768,    36,    37,
-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,    29,-32768,-32768,-32768,-32768,     2,-32768,   -17,
-32768,-32768,-32768,    25,-32768,-32768,-32768,   -18
};


#define	YYLAST		44


static const short yytable[] = {     1,
    16,     2,     3,     1,     4,     2,     3,    -2,     4,    31,
     5,    34,    37,    18,     5,    29,    32,    20,     6,    41,
    38,     7,     6,    45,    39,     7,    20,    48,    27,    42,
    30,    36,    44,    43,    32,    50,    51,    19,    47,    25,
     0,     0,     0,    46
};

static const short yycheck[] = {     1,
    24,     3,     4,     1,     6,     3,     4,     9,     6,    28,
    12,    29,    13,     9,    12,    18,     7,    17,    20,    11,
    21,    23,    20,    41,    25,    23,    17,    46,    16,    21,
    14,    17,     7,    18,     7,     0,     0,     9,    21,    15,
    -1,    -1,    -1,    42
};
#define YYPURE 1

/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/labo/gnu/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 169 "/labo/gnu/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
		 &yyls1, size * sizeof (*yylsp),
#endif
		 &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 411 "pat_decl.yac"
{
		YYACCEPT;
		;
    break;}
case 8:
#line 435 "pat_decl.yac"
{
		PAT_COMPNT = pat_addpacom (PAT_COMPNT, yyvsp[0].text, STT_NBR);
		STT_NBR    = 0;
		;
    break;}
case 11:
#line 451 "pat_decl.yac"
{
		int length;
		int lclmod;
		char name[100];

		if ((lclmod = chktab (HSHTAB, yyvsp[-2].arra.ident, PAT_MODDFN)) != 0)
		  {
		  if (lclmod == 'I')
		    ERR_FLG += pat_error (13, yyvsp[-2].arra.ident, ' ', LINNUM);
		  if (lclmod != yyvsp[-3].immd)
		    ERR_FLG += pat_error (7, yyvsp[-2].arra.ident, ' ', LINNUM);
		  }
		else
		  addtab (HSHTAB, yyvsp[-2].arra.ident, PAT_MODDFN, yyvsp[-3].immd);

		if (yyvsp[-2].arra.left < yyvsp[-2].arra.right)
		  length = yyvsp[-2].arra.right - yyvsp[-2].arra.left + 1;
		else
		  length = yyvsp[-2].arra.left - yyvsp[-2].arra.right + 1;

		STT_NBR++;
		PAT_IOLPNT = addiol (PAT_IOLPNT, yyvsp[-2].arra, yyvsp[-1].immd, yyvsp[-3].immd, yyvsp[0].valu);

		if (length != 1)
		  PAT_GRPPNT = pat_addpagrp (PAT_GRPPNT, yyvsp[-2].arra.ident, length,
		                             DCL_NBR   , 0);
		else
		  {
		  if (yyvsp[-1].immd != 'B')
		    ERR_FLG += pat_error (1, NULL, ' ', LINNUM);
		  }

		DCL_NBR += length;
		;
    break;}
case 12:
#line 495 "pat_decl.yac"
{
		int i;
		int lclmod;
		int length = 0;

		if (chktab (HSHTAB, yyvsp[-5].text, PAT_MODDFN) != 0)
		  ERR_FLG += pat_error (8, yyvsp[-5].text, ' ', LINNUM);
		else
		  addtab (HSHTAB, yyvsp[-5].text, PAT_MODDFN, yyvsp[-6].immd);

		STT_NBR++;

		for (i=0 ; i<TAB_IDX ; i++)
                  {
		  if ((lclmod = chktab(HSHTAB,TAB[i].ident,PAT_MODDFN)) != 0)
		    {
		    if (lclmod != yyvsp[-6].immd)
		      ERR_FLG += pat_error (7, TAB[i].ident, ' ', LINNUM);
		    }
		  else
		    addtab (HSHTAB, TAB[i].ident, PAT_MODDFN, yyvsp[-6].immd);

		  PAT_IOLPNT = addiol (PAT_IOLPNT, TAB[i], yyvsp[-1].immd, yyvsp[-6].immd, yyvsp[0].valu);
		  if (TAB[i].left < TAB[i].right)
		    length += TAB[i].right - TAB[i].left + 1;
		  else
		    length += TAB[i].left - TAB[i].right + 1;
                  }

		PAT_GRPPNT = pat_addpagrp (PAT_GRPPNT, yyvsp[-5].text, length, DCL_NBR, 1);
		TAB_IDX    = 0;
		DCL_NBR   += length;
		;
    break;}
case 13:
#line 532 "pat_decl.yac"
{ yyval.immd = 'B'; ;
    break;}
case 14:
#line 534 "pat_decl.yac"
{ yyval.immd = yyvsp[0].immd; ;
    break;}
case 15:
#line 539 "pat_decl.yac"
{ pshtab (yyvsp[0].arra); ;
    break;}
case 16:
#line 543 "pat_decl.yac"
{ pshtab (yyvsp[0].arra); ;
    break;}
case 17:
#line 548 "pat_decl.yac"
{ yyval.arra = yyvsp[0].arra; ;
    break;}
case 18:
#line 550 "pat_decl.yac"
{ yyval.arra = yyvsp[0].arra; ;
    break;}
case 19:
#line 552 "pat_decl.yac"
{ yyval.arra = yyvsp[0].arra; ;
    break;}
case 20:
#line 557 "pat_decl.yac"
{
		yyval.arra.ident = yyvsp[0].text;
		yyval.arra.left  = -1;
		yyval.arra.right = -1;
		;
    break;}
case 21:
#line 569 "pat_decl.yac"
{
		yyval.arra.ident = yyvsp[-3].text;
		yyval.arra.left  = yyvsp[-1].valu;
		yyval.arra.right = yyvsp[-1].valu;
		;
    break;}
case 22:
#line 583 "pat_decl.yac"
{
		yyval.arra.ident = yyvsp[-5].text;
		yyval.arra.left  = yyvsp[-3].valu;
		yyval.arra.right = yyvsp[-1].valu;
		;
    break;}
case 23:
#line 593 "pat_decl.yac"
{
		char name[256];
		int  i;

		strcpy (name, yyvsp[-1].text);
		for (i=0; i<NAM_IDX ; i++)
		 {
		 strcat (name, ".");
		 strcat (name, NAMTAB [i]);
		 }
		NAM_IDX = 0;
		yyval.text = namealloc (name);
		;
    break;}
case 25:
#line 613 "pat_decl.yac"
{ pshnam (yyvsp[0].text); ;
    break;}
case 28:
#line 623 "pat_decl.yac"
{ yyval.immd = 'I'; ;
    break;}
case 29:
#line 625 "pat_decl.yac"
{ yyval.immd = 'O'; ;
    break;}
case 30:
#line 627 "pat_decl.yac"
{ yyval.immd = 'T'; ;
    break;}
case 31:
#line 629 "pat_decl.yac"
{ yyval.immd = 'S'; ;
    break;}
case 32:
#line 631 "pat_decl.yac"
{ yyval.immd = 'R'; ;
    break;}
case 33:
#line 636 "pat_decl.yac"
{
		if (ERR_FLG > 30)
		  YYABORT;
		else
		   yyerrok;
		;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 442 "/labo/gnu/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 643 "pat_decl.yac"

