
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: pat_prspat.c						*/
/* date		: Aug 17 1993						*/
/* version	: v104							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* content	: parser-driver functions				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include MUT_H
#include PAT_H

/* ###--------------------------------------------------------------### */
/* function	: pat_prspat						*/
/* description	: parse a file in pat format and return a PASEQ		*/
/* called func.	: namealloc, pat_declpat, pat_descpat			*/
/* ###--------------------------------------------------------------### */

struct paseq *pat_prspat (fp, name, ptseq, maxpat)

FILE         *fp    ;		/* pointer of file to be parsed		*/
char         *name  ;		/* name of the new sequence		*/
struct paseq *ptseq ;		/* list of existing sequences		*/
unsigned int  maxpat;		/* # of pattern in a sub-sequence	*/

  {
  extern struct paseq *pat_declpat ();
  extern struct paseq *pat_descpat ();

  if ((ptseq == NULL) || (ptseq->ENDFLG == 'Y'))
    {
	/* ###------------------------------------------------------### */
	/* begin parsing a new pattern file				*/
	/* ###------------------------------------------------------### */

    ptseq = pat_declpat (fp, ptseq);

    if ((ptseq != NULL) && (ptseq->ERRFLG == 0))
      {
      ptseq->NAME = namealloc (name);
      ptseq       = pat_descpat (fp, ptseq, maxpat);
      }

    }
  else
    {
	/* ###------------------------------------------------------### */
	/* continue parsing						*/
	/* ###------------------------------------------------------### */

    ptseq = pat_descpat (fp, ptseq, maxpat);
    }

  return (ptseq);
  }
