/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur Logique                                       */
/*    Fichier :  sl_type.h                                                  */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 16/07/1991     */
/*                                                                          */
/*    Modifie par :                                     le : 14/09/1992     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#ifdef LAX
#define PRINTF LXU_PrintMSG
#else
#define PRINTF printf
#endif

#define SL_SYS sl_sys
#define SL_VHDL sl_sys->fileVhdl
#define SL_FILE sl_sys->file
#define SL_FILEPAR sl_sys->filePar
#define SL_PARAM sl_sys->fileParam
#define SL_PAR sl_sys->par
#define SL_BEH sl_sys->beh
#define SL_MODE sl_sys->mode
#define SL_VERSION sl_sys->version
#define SL_OPTION sl_sys->option
#define SL_AUXOF sl_sys->auxOF

#define SL_NAME (sl_sys->beh)->NAME
#define SL_CIRCUIT (sl_sys->beh)->CIRCUI
#define SL_PI (sl_sys->beh)->BERIN

#define SL_OPTIM (sl_sys->par)->mode
#define SL_AUX (sl_sys->par)->aux
#define SL_GUARDEDAUX (sl_sys->par)->intermediate
#define SL_LEVEL (sl_sys->par)->level
#define SL_OPTIMPO (sl_sys->par)->earlyPO
#define SL_DELAYPI (sl_sys->par)->delayPI
#define SL_NUMTRANSN (sl_sys->par)->numTransN
#define SL_NUMTRANSP (sl_sys->par)->numTransP

#define SL_ORDER sl_sys->order
#define SL_ORDERPI sl_sys->orderPI

	/* define correspondant aux variables d'environnement */

#define SL_BEH_LIB sl_sys->beh_lib
#define SL_LOG_LIB sl_sys->log_lib
#define SL_PAR_LIB sl_sys->par_lib
#define SL_CATA_LIB sl_sys->cata_lib
#define SL_CATA_SAVE sl_sys->cata_save
#define SL_CCCC_LIB sl_sys->c4_lib
#define SL_TRACE sl_sys->trace
#define SL_LATCHES sl_sys->latches
#define SL_NAME_LOG sl_sys->name_log
#define SL_MAKEORDER sl_sys->makeOrder
#define SL_BANN sl_sys->banniere
#define SL_IN_LO sl_sys->in_lo
#define SL_OUT_LO sl_sys->out_lo
#define SL_OUT_PH sl_sys->out_ph
	
/*-------------- systeme pour la synthese logique ---------------

  fileVhdl	: identificateur du fichier contenant l'architecture
  fileParam	: fichier de parametres
  par		: pointeur sur la structure contenant les parametres
  beh		: pointeur sur la befig de l'architecture compilee  
  mode		: mode batch ou non.
  version       : outil et numero de version
  option	: option en batch "o" "s" ou "c"
-----------------------------------------------------------------*/

typedef struct sl_syst {
    	char *file;
    	char *filePar;
	char *fileParam;
	char *fileVhdl;
	param *par;
	befig_list *beh;
        int mode;
        char *version;
	char option;
	int order;
	chain_list *orderPI;

		/* variable d'environnement */

	char *beh_lib;
   	char *log_lib;
	char *par_lib;
	char *cata_lib;
        char *cata_save;
	char *c4_lib;
	int  trace;
        int  latches;
        int  name_log;
	char *in_lo;
        char *out_lo;
        char *out_ph; 
        int  makeOrder;
        int  banniere;
        int  auxOF;
	} sl_system;

sl_system *sl_sys;
chain_list *ptr_ctrlst;
sl_system *initializeSLSystem();
param *initializeParam();
befig_list *laxOptimize();

extern char BVL_ERRFLG;
extern int BVL_LINNUM;
befig_list *VHB_HEDFIG;
