/*------------------------------------------------------------\
|                                                             |
| Tool    :                    RDSCIF                         |
|                                                             |
| File    :                 cif_error.c                       |
|                                                             |
| Authors :       Petrot Frederic & Jacomme Ludovic           |
|                   ---------                                 |
| Date    :    The king ^     04/07/93                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include MUT_H
# include "cif_error.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          ciferror                           |
|                                                             |
\------------------------------------------------------------*/

  void ciferror( Error, Text, Value )

    char  Error;
    char *Text;
    long  Value;
  {
    switch( Error )
    {
      case CIF_ERROR_BAD_TRANS      :

       (void)fprintf( stderr, 
                      "cif105: Unknown instance transformation on `%s'\n", 
                      Text );
      break;

      case CIF_ERROR_CONNECTOR_NAME :

         (void)fprintf( stderr, 
                        "cif105: Rds connector (%d, %d) has no name !\n", 
                        Text, Value );
      break;

      case CIF_ERROR_FILE_OPEN      :

       (void)fprintf( stderr, 
                      "cif105: Could not open file `%s'\n", 
                      Text );
      break;

      case CIF_ERROR_FILE_CLOSE     :

       (void)fprintf( stderr, 
                      "cif105: Could not close file `%s'\n", 
                      Text );
      break;
     
      case CIF_ERROR_MODEL          :

       (void)fprintf( stderr, 
                      "cif105: Could not find model `%s'\n", 
                      Text );
      break;

      case CIF_ERROR_EXPECTED_SEMI  :

       (void)fprintf( stderr,
                      "cif105: Missing ';' line %d\n",
                      Value );
      break;

      case CIF_ERROR_EXPECTED_SPACE :

       (void)fprintf( stderr,
                      "cif105: Missing space, line %d\n",
                      Value );
      break;

      case CIF_ERROR_EXPECTED_NAME :

       (void)fprintf( stderr,
                      "cif105: Missing name, line %d\n",
                      Value );
      break;

      case CIF_ERROR_EXPECTED_UNSIGNED :

       (void)fprintf( stderr,
                      "cif105: Missing unsigned integer, line %d\n",
                      Value );
      break;

      case CIF_ERROR_EXPECTED_SIGNED :

       (void)fprintf( stderr,
                      "cif105: Missing signed integer, line %d\n",
                      Value );
      break;

      case CIF_ERROR_EXPECTED_LAYER : 

       (void)fprintf( stderr,
                      "cif105: Missing layer name, line %d\n",
                      Value );
      break;

      case CIF_ERROR_EXPECTED_MANHATTAN :

       (void)fprintf( stderr,
                      "cif105: Expected manhattan distance, line %d\n",
                      Value );
      break;

      case CIF_ERROR_EXPECTED_EOF :

       (void)fprintf( stderr,
                      "cif105: End of file expected, line %d\n",
                      Value );
      break;

      case CIF_ERROR_UNEXPECTED_EOF :

       (void)fprintf( stderr,
                      "cif105: Unexpected end of file, line %d\n",
                      Value );
      break;

      case CIF_ERROR_UNSIGNED_OVERFLOW :

       (void)fprintf( stderr,
                      "cif105: Unsigned integer overflow, line %d\n",
                      Value );
      break;

      case CIF_ERROR_SIGNED_OVERFLOW :

       (void)fprintf( stderr,
                      "cif105: Signed integer overflow, line %d\n",
                      Value );
      break;

      case CIF_ERROR_LAYER_UNKNOWN :

       (void)fprintf( stderr,
                      "cif105: Layer unknown, line %d\n",
                      Value );
      break;

      case CIF_ERROR_POLYGON_EMPTY :

       (void)fprintf( stderr,
                      "cif105: Polygon empty, line %d\n",
                      Value );
      break;

      case CIF_ERROR_POLYGON_OVERFLOW :

       (void)fprintf( stderr,
                      "cif105: Polygon overflow, line %d\n",
                      Value );
      break;

      case CIF_ERROR_POLYGON_NOT_REC :

       (void)fprintf( stderr,
                      "cif105: Polygon not rectangular, line %d\n",
                      Value );
      break;

      case CIF_ERROR_SYMBOL_STARTED :

       (void)fprintf( stderr,
                      "cif105: Symbol has already started, line %d\n",
                      Value );
      break;

      case CIF_ERROR_SYMBOL_NOT_STARTED :

       (void)fprintf( stderr,
                      "cif105: Symbol hasn't  started, line %d\n",
                      Value );
      break;

      case CIF_ERROR_BAD_DEFINE :

       (void)fprintf( stderr,
                      "cif105: Bad define, line %d\n",
                      Value );
      break;

      case CIF_ERROR_BAD_COMMAND :

       (void)fprintf( stderr,
                      "cif105: Bad command, line %d\n",
                      Value );
      break;

      case CIF_ERROR_BAD_COMMENT :

       (void)fprintf( stderr,
                      "cif105: Bad comment, line %d\n",
                      Value );
      break;

      case CIF_ERROR_BAD_CONNECTOR :

       (void)fprintf( stderr,
                      "cif105: Bad connector specification, line %d\n",
                      Value );
      break;
     
      case CIF_ERROR_BAD_SYMBOL :

       (void)fprintf( stderr,
                      "cif105: Bad symbol specification, line %d\n",
                      Value );
      break;

      case CIF_ERROR_SYMBOL_NOT_DEFINE :

       (void)fprintf( stderr,
                      "cif105: Symbol number %d not define\n",
                      Value );
      break;

      case CIF_ERROR_BAD_MIRROR :

       (void)fprintf( stderr,
                      "cif105: Bad mirror specification, line %d\n",
                      Value );
      break;
     
      case CIF_ERROR_NO_TOP_MODEL :

       (void)fprintf( stderr,
                      "cif105: there is no top model !\n"
                    );
      break;
    }

    EXIT( 1 );
  }

/*------------------------------------------------------------\
|                                                             |
|                          cifwarning                         |
|                                                             |
\------------------------------------------------------------*/

  void cifwarning( Warning, Text, Value )

    char  Warning;
    char *Text;
    long  Value;
  {
    switch( Warning )
    {
      case CIF_WARNING_PHYSICAL_GRID :

       (void)fprintf( stderr,
                      "cif105: Rectangle not aligned on the physical grid !\n"
                    );
      break;

      case CIF_WARNING_UNCONNECTED_NODE :

       (void)fprintf( stderr,
                      "cif105: Node %s is not connected, in model %s !\n",
                      Text, Value 
                    );
      break;

      case CIF_WARNING_ROUND_FLASH :

       (void)fprintf( stderr,
                      "cif105: Command round flash ignored, line %d !\n",
                      Value 
                    );
      break;

      case CIF_WARNING_USER_COMMAND :

       (void)fprintf( stderr,
                      "cif105: User command ignored, line %d !\n",
                      Value 
                    );
      break;
    }
  }
