#ident "@(#)Reccurence Solver Adder generator"


/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   RSA                          */
/*                                                                          */
/*    Produit : RSA (Reccurence Solver Adder)                               */
/*    Fichier : ~rsa/dev/rsa/rsa.c                                          */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Luis Lucas                            le : 30/06/1991     */
/*                                                                          */
/*    Modifie par : Luis Lucas                          le : 17/10/1991     */
/*                                                                          */
/*    Modifie par : Luis Lucas                          le : 15/11/1991     */
/*                                                                          */
/*    Modifie par : Luis Lucas                          le : 05/03/1992     */
/*                                                                          */
/*    Modified by : Luis Lucas                          October 01 1992     */
/*                                                                          */
/*    Modified by : Luis Lucas                          October 01 1993     */
/*                                                                          */
/****************************************************************************/
/*
 * $Log: rsa.c,v $
 * Revision 2.0  1993/01/19  15:32:28  rsa
 * The banner was modified, and RCS is used.
 *
 * Revision 1.1  1993/01/19  15:10:44  rsa
 * Initial revision
 *
 */


static char rcsid[]="$Id: rsa.c,v 2.0 1993/01/19 15:32:28 rsa Exp rsa $";

/*----->
 *
 *     In Line Soft  30/01/91  RSA  Version 0.0
 *
 *     Toutes les fonctions et variables globales concernant le generateur d'additionneur sont prefixees par  rsa .
 *
 */

#include <genlib.h>
#include <ctype.h>
#include <string.h>


/*
 *     Le generateur est une boite noire. La seule fonction connue de l'exterieur est  rsa . En verite toutes les autres sont
 *   accessibles. Pour les rendre invisibles il suffit de les declarer de type  static  dans un meme fichier. Une boite noire
 *   communique avec l'exterieur a l'aide de son interface, ici les parametres.
 *
 *   Attention un entier booleen a pour valeur 0 ou 1, il n'y a pas de verification pour d'autre valeur pour vrai. Toutes
 *   autres valeurs entrainent une erreur d'execution voir un  core dump.
 *
 *   n        : Le nombre de bits doit etre compris entre 3 et 128 : pas de verification effectuee.
 *   cin      : Entier booleen :  == 0 -> Pas de retenue d'entree    :  == 1 -> il y a une retenue d'entree.
 *   cout     : Entier booleen :  == 0 -> Les retenues intermediaires non visibles :  ==> 1  visibles en alu2.
 *   over     : Entier booleen :  == 0 -> la retenue -1 n'est pas sortie en poly sur la face EST  ==> 1  visible.
 *   overn    : Entier booleen :  == 0 -> la retenue -1 n'est pas sortie en pmetal1 sur la face NORD  ==> 1  visible.
 *   not      : Entier booleen :  == 0 -> Les sorties sont directes : == 1 les sorties sont invers\'ees.
 *   csa      : Entier booleen :  == 0 -> Additionneur a 2 operandes :  == 1 -> Additionneur a 3 operandes.
 *   sub      : Entier booleen :  == 0 -> Additionneur a 2 operandes :  == 1 -> Additionneur a 3 operandes.
 *   addsub   : Entier booleen :  == 0 -> Additionneur a 2 operandes :  == 1 -> Additionneur a 3 operandes.
 *   deci     : Entier booleen :  == 0 -> Les retenues decimales non visibles en poly face EST :  ==> 1  visibles (BULL).
 *   stretch  : Entier booleen :  == 0 -> additionneur classique : == 1 additionneur a parite (BULL).
 *   name     : Pointe sur une chaine de caracteres : le nom de l'additionneur :  == NULL -> nom par defaut  rsaxxxx.
 *   layout   : Entier booleen :  == 0 -> Pas de vue physique generee :  == 1 -> Vue physique ( masques ).
 *   icon     : Entier booleen :  == 0 -> Pas de vue icone generee :  == 1 -> Vue icone ( icon ).
 *   vhdl     : Entier booleen :  == 0 -> Pas de vue comportementale generee :  == 1 -> Vue comportementale ( vhdl ).
 *   patterns : Entier booleen :  == 0 -> Pas de vue vecteurs de test generee :  == 1 -> Vue vecteurs de test ( pat ).
 *   netlist  : Entier booleen :  == 0 -> Pas de vue logique generee  :  == 1 -> Vue logique ( netlist ).
 *   outline  : Entier booleen :  == 0 -> Pas de vue outline : Incompatible avec la vue layout.
 *   perf     : Entier booleen :  == 0 -> Pas de vue performance pour spice symbolique generee :  == 1 -> Vue performance.
 *
 */


static      rsa_lay();
static void NETLIST();
static      rsa_vhdl();
static      rsa_icon();
static      rsa_pat();
static      rsa_dat();
static      rsa_perf();


char *rsa(n,cin,cout,overn,not,
          csa,sub,addsub,
          over,deci,stretch,stretch2,
          msb0,virtual,
          layout,icon,vhdl,patterns,datasheet,
          outline,netlist,perf,
          name)

int  n,cin,cout,overn,not,
     csa,sub,addsub,
     over,deci,stretch,stretch2;
int  msb0,virtual;
int  layout,vhdl,patterns,datasheet,
     outline,netlist,perf;
char *name ;
{
 char  tmp[100] ;


   if(n<3 || n>128){
      fprintf(stderr,"\nIncorrect number of bit : %d, only 3 to 128 is available\n",n);
      EXIT(-5) ;
     }

   if( (cin|cout|over|overn|not|csa|sub|addsub|deci|stretch|stretch2|msb0|virtual)>>1 ) {
      fprintf(stderr,"\nOptions gived to function rsa must be booleans : 1 ==> TRUE ; 0 ==> FALSE\n");
      EXIT(-6) ;
     }

   if((csa+sub+addsub)>1) {
     fprintf(stderr,"\nOptions csa, sub, addsub cannot be true at the same time\n");
     EXIT(-9) ;
    }

   if(addsub&&(n&1)) {
     fprintf(stderr,"\nWhen addsub is used, a even number of bits is needed\n");
     EXIT(-10);
    }

   if(over) {
      fprintf(stderr,"\nOptions over is not available yet\n");
     EXIT(-11);
    }


   if( ! ( layout || icon || vhdl || patterns || datasheet || netlist || outline || perf ) ) {
     datasheet=1;
/*   fprintf( stderr, "\nOne view must be specified\n" ) ;
 *   EXIT(-8) ;
 */
    }

   if(name==NULL) {int i,j,k,l; char car[16];

      for(i=0;i<16;i++) car[i]='a'+i;
      i =     cin |    cout<<1 |      over<<2 |  overn<<3 ;
      j =     not |     csa<<1 |       sub<<2 | addsub<<3 ;
      k =    deci | stretch<<1 |  stretch2<<2 |   msb0<<3 ;
      l = virtual ;
      sprintf(tmp,"rsa%d%c%c%c%c",n,car[i],car[j],car[k],car[l]);
      name = tmp ;
     }

   if(layout || netlist || outline)
      rsa_lay(n,cin,cout,over,overn,not,csa,sub,addsub,
              deci,stretch,stretch2,name,msb0,virtual) ;

   if(layout)   SAVE_PHFIG() ;

   if(netlist)/*if(virtual) NETLIST() ;
               else*/rsa_int(n,cin,cout,over,overn,csa,addsub,deci,stretch,stretch2,msb0,name);

   if(outline)
      if(layout) {
         fprintf( stderr, "\nIt's not possible to have the layout and outline view : It's the same name\n" ) ;
         EXIT(-7) ;
        }
      else OUTLINE();

   if(icon) rsa_icon(name,n,msb0,cin,cout,overn,over,not,csa,sub,addsub);
   if(vhdl) rsa_vhdl(n,cin,cout,over,overn,not,csa,sub,addsub,
                     deci,stretch,stretch2,name,msb0);
   if(patterns) rsa_pat(n,cin,cout,over,overn,not,csa,sub,addsub,
                        deci,stretch,stretch2,name,msb0);
   if(datasheet) rsa_dat(n,cin,cout,over,overn,not,csa,sub,addsub,
                         deci,stretch,stretch2,name,msb0);
   if(perf) rsa_perf(n,cin,csa,cout);

   return  name ;
}

#include "rsa_lay.c" 
#include "rsa_vhdl.c"
#include "rsa_int.c"
#include "rsa_icon.c"
#include "rsa_pat.c"
#include "rsa_dat.c"
#include "rsa_net.c"
#include "rsa_bull.c"
#include "rsa_perf.c"

/*       <-----*/
