
/*
 * Bull
 */

#ifndef min
#define min(a,b) ((a)<(b)?(a):(b))
#endif  

/*******************************************************************************
*
*   y : bitslice number
*   n : number of bitslice to stretch
*
*******************************************************************************/
static HSTRETCH( y, n, l )
int  y ;
int  n ;
int  l ;
{
 static int     con = 0 ;
 long  slice,  ycut ;
 int              i ;
 int              j ;
 int          start ;
 int         ystart ;
 phins_list  *phins ;
 phins_list  *phins0 ;
 phseg_list  *phseg ;
 phvia_list  *phvia ;
 phref_list  *phref ;
 phcon_list  *phcon ; 
 phcon_list  *phcon0 ; 
 phfig_list  *phfig0 ;
 phfig_list  *phfig1 ;

 char  newconname[250] ;

   if (WORK_PHFIG == NULL) {
      (void)fprintf(stderr, "\n*** genlib error ***\n");
      (void)fprintf(stderr, "HSTRETCH impossible : missing DEF_PHFIG\n");
      EXIT(1);
     }

   slice = n*60L*SCALE_X ;
   ycut = y*60L*SCALE_X + WORK_PHFIG->YAB1 ;

   WORK_PHFIG->YAB2 += slice ;

if(n>1){
   for( phins = WORK_PHFIG->PHINS ; phins != NULL ; phins = phins->NEXT )
      if( phins->YINS >= ycut )   phins->YINS += slice ;

   for( phseg = WORK_PHFIG->PHSEG ; phseg != NULL ; phseg = phseg->NEXT ) {
      if( phseg->Y1 > ycut )   phseg->Y1 += slice ;
      if( phseg->Y2 >= ycut )   phseg->Y2 += slice ;
      if( phseg->Y1 == ycut && phseg->Y2 == ycut )  {
         phseg->Y2 -= slice ;
         addphseg(WORK_PHFIG,phseg->LAYER,phseg->WIDTH,
                  phseg->X1,phseg->Y1+slice,phseg->X2,phseg->Y2+slice,"" ) ;
        }
     }

   for( phvia = WORK_PHFIG->PHVIA ; phvia != NULL ; phvia = phvia->NEXT )  {
      if( phvia->YVIA > ycut )   phvia->YVIA += slice ;
      if( phvia->YVIA == ycut )  addphvia(WORK_PHFIG,phvia->TYPE,
                                          phvia->XVIA,phvia->YVIA+slice) ;
     }

   for( phref = WORK_PHFIG->PHREF ; phref != NULL ; phref = phref->NEXT )
      if( phref->YREF > ycut )   phref->YREF += slice ;

   for( phcon = WORK_PHFIG->PHCON ; phcon != NULL ; phcon = phcon->NEXT )  {
      if( phcon->YCON > ycut )   phcon->YCON += slice ;
      if( phcon->YCON == ycut )   {
         sprintf( newconname, "%s_%d", phcon->NAME, con++ ) ;
         if( phcon->ORIENT!=NORTH)
                  addphcon(WORK_PHFIG,phcon->ORIENT,namealloc(newconname),
                  phcon->XCON,phcon->YCON+slice,phcon->LAYER,phcon->WIDTH);
        }
     }

   if(l==1){
      for( phcon = WORK_PHFIG->PHCON ; phcon != NULL ; phcon = phcon->NEXT )
         if(phcon->YCON==ycut && phcon->ORIENT==NORTH)  {
            addphseg(WORK_PHFIG,phcon->LAYER,phcon->WIDTH,phcon->XCON,phcon->YCON,
                     phcon->XCON,phcon->YCON+slice,"");
            phcon->YCON+=slice;
           }
      sprintf( newconname, "%s_%d", y&1 ? "vss" : "vdd", con++ ) ;
      genTHRU_H(ALU2,y&1 ? 6*SCALE_X : 8*SCALE_X,(long)ycut+slice) ;
   }
}
else
{
   for( phcon = WORK_PHFIG->PHCON ; phcon != NULL ; phcon = phcon->NEXT )
      if(phcon->YCON==ycut && phcon->ORIENT==NORTH)  {
         addphseg(WORK_PHFIG,phcon->LAYER,phcon->WIDTH,phcon->XCON,phcon->YCON,
                  phcon->XCON,phcon->YCON+slice,"");
         phcon->YCON+=slice;
        }
   sprintf( newconname, "%s_%d", y&1 ? "vss" : "vdd", con++ ) ;
   genTHRU_CON_H(ALU2,y&1 ? 8*SCALE_X : 6*SCALE_X,
                 namealloc(newconname),(long)ycut+slice) ;
}
   ystart = ycut ;
   for( j=0 ; j < n ; j++ )  {
      start = (j&1 ? 7*SCALE_X : 8*SCALE_X) + ystart ;
      for(i=0 ; i < 10 ; i++, start+=5*SCALE_X )
         genTHRU_H(TALU2,2*SCALE_X,(long)start) ;
      ystart+=60*SCALE_X ;
     }

   ystart = ycut + 60*SCALE_X ;
   for( j = 1 ; j < n ; j++ )  {
      sprintf( newconname, "%s_%d", y&1 ? "vss" : "vdd", con++ ) ;
      genTHRU_CON_H(ALU2,y&1 ? 8*SCALE_X : 6*SCALE_X,
                    namealloc(newconname),(long)ystart) ;
      ystart += 60*SCALE_X ;
     }

   for( phins0 = WORK_PHFIG->PHINS ; phins0 != NULL ; phins0 = phins0->NEXT ){
      phfig0=getphfig(phins0->FIGNAME,'P') ;
      if(phins0->YINS==(ycut-(phfig0->YAB2-phfig0->YAB1)))
         for(phins=WORK_PHFIG->PHINS ; phins != NULL ; phins = phins->NEXT )
            if( phins->YINS == ycut + slice )  {
              phfig1=getphfig(phins->FIGNAME,'P');
              for(phcon0=phfig0->PHCON;phcon0!=NULL;phcon0=phcon0->NEXT)
                for(phcon=phfig1->PHCON;phcon!=NULL;phcon=phcon->NEXT) {
                  long x0,y0,x1,y1;
                  xyflat(&x0,&y0,phcon0->XCON,phcon0->YCON,
                         phins0->XINS,phins0->YINS,
                         phfig0->XAB1,phfig0->YAB1,
                         phfig0->XAB2,phfig0->YAB2,phins0->TRANSF);
                  xyflat(&x1,&y1,phcon->XCON,phcon->YCON,
                         phins->XINS,phins->YINS,
                         phfig1->XAB1,phfig1->YAB1,
                         phfig1->XAB2,phfig1->YAB2,phins->TRANSF);
                  if( x0 == x1 && phcon0->LAYER == phcon->LAYER &&
                      y1 == ycut+slice &&
                      phcon->ORIENT==(n&1?NORTH:SOUTH) &&
                      phcon0->ORIENT==(y&1?NORTH:
                      ((phfig0->YAB2-phfig0->YAB1)>60L*SCALE_X?NORTH:SOUTH)))
                     addphseg(WORK_PHFIG,phcon->LAYER,
                              min(phcon->WIDTH,phcon0->WIDTH),x0,y0,x1,y1,"");
                 }
              }
     }
}
