/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : Icon Library                                                */
/*    Fichier : Icnxxx.h (icon struture definition)                         */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Vincent POUILLEY                      le : 25/05/1992     */
/*                                                                          */
/*    Modifie par : Vincent POUILLEY                    le : 15/11/1992     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/*    $Id: icn.h,v 2.1.1.1 1993/09/23 16:04:30 sax Exp sax $                    */
/*                                                                          */
/****************************************************************************/


#ifndef __ICON_H__
#define __ICON_H__

typedef struct IconGeometry
{
  long			x, y;
  unsigned int	halign: 2;
  unsigned int	valign: 2;
  unsigned int	direction: 2;	/* 0: left to right, 1: top to bottom,
							   2: right to left, 3: bottom to top,
							   (2 and 3 not yet available).
							*/
} IconStringGeometry;

typedef struct IconString
{
  char*					string;
  IconStringGeometry	geo;
} IconString;

/* connectors definition */
typedef struct IconCon
{
  struct IconCon	*NEXT;
  long				x, y;
  unsigned long		side:2; /* 0: north, 2: west,
							   1: south, 3: east */
  char				direction; /* logical direction */
  IconString		name;
  struct ptype		*USER; 
} IconCon_list;

/* lines definition */
typedef struct IconLine
{
  struct IconLine	*NEXT;
  long				x0, y0;
  long				x1, y1;
} IconLine_list;

/* componentes of closed shapes definition */
typedef struct IconComp
{
  struct IconComp	*NEXT;
  unsigned long		type; /* (line, arc start, arc end, componente of arc) */
  long				x, y;
} IconComp_list;

/* closed shapes definition */
typedef struct IconShape
{
  struct IconShape	*NEXT;
  struct IconComp	*components;
  int				number_of_components;
} IconShape_list;

/* circles and ovales definition */
typedef struct IconCircle
{
  struct IconCircle	*NEXT;
  long				x, y;	/* up-left corner of englobing rectangle */
  long				width, height;
} IconCircle_list;

/* arcs definition */
typedef struct IconArc
{
  struct IconArc 	*NEXT;
  long 				x, y;	/* up-left corner of englobing rectangle */
  long 				width, height;
  long				angle1, angle2;
} IconArc_list;

/* icon definition */
typedef struct IconGate
{
  struct IconGate		*NEXT;
  long					x, y, width, height;
  unsigned long			default_description:1; /* Default icon,
												  automagically generated. */
  double				scale; /* scale of icon */
  IconString			model_name;
  IconStringGeometry	ins_geo;
  IconStringGeometry	label_geo;
  char					*data; /* Bitmap definition of the icons */
  IconLine_list			*lines;
  IconShape_list		*shapes;
  IconCircle_list		*circles;
  IconArc_list			*arcs;
  IconCon_list			*connectors;
  struct ptype			*USER;
} IconGate_list;

/**************************************************/
/*    externals for icon                          */
/**************************************************/

#ifndef _ICON_C_

extern IconGate_list * HEAD_ICON;
extern char ICON_IN[];
extern char ICON_OUT[];

#ifdef __STDC__
extern IconGate_list * addicongate(char*	modelname, long	x_model_name, long	y_model_name,
								   char	halign_model, char	valign_model, char	direction_model,
								   long	x_ins_name, long	y_ins_name,
								   char	halign_ins, char	valign_ins, char	direction_ins,
								   long	x_label, long	y_label,
								   char	halign_label, char	valign_label, char	direction_label);
extern int delicongate(char * modelname);
extern IconGate_list * geticongate(char * modelname);
extern void viewicon(void);
extern void viewicongate (IconGate_list * pticon);
extern IconCon_list * addiconcon(IconGate_list * pticon, char * name,
								 long x, long y, char side, char direction,
								 char halign, char valign, char direction_name,
								 long x_name, long y_name);
extern int deliconcon(IconGate_list * pticon, IconCon_list * ptcon);
extern IconCon_list * geticoncon(IconGate_list * pticon, char * name);
extern void viewiconcon (IconCon_list * ptcon);
extern IconLine_list * addiconline(IconGate_list * pticon, long x0, long y0, long x1, long y1);
extern int deliconline(IconGate_list * pticon, IconLine_list * ptline);
extern void viewiconline (IconLine_list * ptline);
extern IconShape_list * addiconshape(IconGate_list * pticon, IconComp_list * ptcomp);
extern int deliconshape(IconGate_list * pticon, IconShape_list * ptshape);
extern void viewiconshape (IconShape_list * ptshape);
extern IconComp_list * addiconcomp(IconComp_list * ptcomp, char type, long x, long y);
extern IconComp_list * deliconcomp(IconComp_list * pthead, IconComp_list * ptcomp);
extern void viewiconcomp (IconComp_list * ptcomp);
extern IconCircle_list * addiconcircle(IconGate_list * pticon, long x0, long y0, long width, long height);
extern int deliconcircle(IconGate_list * pticon, IconCircle_list * ptcircle);
extern void viewiconcircle (IconCircle_list * ptcircle);
extern IconArc_list * addiconarc(IconGate_list * pticon, long x0, long y0, long width, long height,
								 long angle1, long angle2);
extern int deliconarc(IconGate_list * pticon, IconArc_list * ptarc);
extern void viewiconarc (IconArc_list * ptarc);

#else /* __STDC__ */

extern IconGate_list * addicongate();
extern int delicongate();
extern IconGate_list * geticongate();
extern void viewicon();
extern void viewicongate();
extern IconCon_list * addiconcon();
extern int deliconcon();
extern IconCon_list * geticoncon();
extern void viewiconcon();
extern IconLine_list * addiconline();
extern int deliconline();
extern void viewiconline();
extern IconShape_list * addiconshape();
extern int deliconshape();
extern void viewiconshape();
extern IconComp_list * addiconcomp();
extern IconComp_list * deliconcomp();
extern void viewiconcomp();
extern IconCircle_list * addiconcircle();
extern int deliconcircle();
extern void viewiconcircle();
extern IconArc_list * addiconarc();
extern int deliconarc();
extern void viewiconarc();

#endif /* __STDC__ */

#else /* _ICON_C_ */
#ifdef __STDC__

IconGate_list * addicongate(char*	modelname, long	x_model_name, long	y_model_name,
							char	halign_model, char	valign_model, char	direction_model,
							long	x_ins_name, long	y_ins_name,
							char	halign_ins, char	valign_ins, char	direction_ins,
							long	x_label, long	y_label,
							char	halign_label, char	valign_label, char	direction_label);
int delicongate(char * modelname);
IconGate_list * geticongate(char * modelname);
void viewicon(void);
void viewicongate (IconGate_list * pticon);
IconCon_list * addiconcon(IconGate_list * pticon, char * name,
						  long x, long y, char side, char direction,
						  char halign, char valign, char direction_name,
						  long x_name, long y_name);
int deliconcon(IconGate_list * pticon, IconCon_list * ptcon);
IconCon_list * geticoncon(IconGate_list * pticon, char * name);
void viewiconcon (IconCon_list * ptcon);
IconLine_list * addiconline(IconGate_list * pticon, long x0, long y0, long x1, long y1);
int deliconline(IconGate_list * pticon, IconLine_list * ptline);
void viewiconline (IconLine_list * ptline);
IconShape_list * addiconshape(IconGate_list * pticon, IconComp_list * ptcomp);
int deliconshape(IconGate_list * pticon, IconShape_list * ptshape);
void viewiconshape (IconShape_list * ptshape);
IconComp_list * addiconcomp(IconComp_list * ptcomp, char type, long x, long y);
IconComp_list * deliconcomp(IconComp_list * pthead, IconComp_list * ptcomp);
void viewiconcomp (IconComp_list * ptcomp);
IconCircle_list * addiconcircle(IconGate_list * pticon, long x0, long y0, long width, long height);
int deliconcircle(IconGate_list * pticon, IconCircle_list * ptcircle);
void viewiconcircle (IconCircle_list * ptcircle);
IconArc_list * addiconarc(IconGate_list * pticon, long x0, long y0, long width, long height,
						  long angle1, long angle2);
int deliconarc(IconGate_list * pticon, IconArc_list * ptarc);
void viewiconarc (IconArc_list * ptarc);

#endif /* __STDC__ */
#endif /* _ICON_C_ */

#endif /*__ICON_H__*/
