/******************************************************************************/
/*                                                                            */
/*                      Chaine de CAO & VLSI   Alliance                       */
/*                                                                            */
/*    Produit : STANDAD CELLS ROUTER                                          */
/*    Fichier : ScrSesame.c                                                   */
/*                                                                            */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                   */
/*    Tous droits reserves                                                    */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                   */
/*                                                                            */
/*    Auteur(s) : El housseine REJOUAN                  le : 26/10/1991       */
/*                                                                            */
/*    Modifie par :                                     le : ../../....       */
/*    Modifie par :                                     le : ../../....       */
/*    Modifie par :                                     le : ../../....       */
/*                                                                            */
/******************************************************************************/

# include MLO_H 
# include MPH_H 
# include MUT_H

/******************************************************************************/
/*	Function : InsCompare()                                               */
/******************************************************************************/
void		InsCompare(ptphIns,ptloIns)

phins_list	*ptphIns;
loins_list	*ptloIns;
 
{
 phins_list	*CurrentphIns = NULL;
 phins_list	*ptCurrentph  = NULL;
 loins_list	*CurrentloIns = NULL;
 loins_list	*ptCurrentlo  = NULL;
 char		*InsName;

 for (CurrentloIns = ptloIns; CurrentloIns; CurrentloIns = CurrentloIns->NEXT) {
  InsName = CurrentloIns->INSNAME;
  for (ptCurrentlo = ptloIns; ptCurrentlo; ptCurrentlo = ptCurrentlo->NEXT) 
   if ((ptCurrentlo != CurrentloIns) && (InsName == ptCurrentlo->INSNAME)) {
    fprintf(stderr,"scr_error : Logic instance : %s is redeclared !!\n", InsName);
    exit(1);
   }
 }

 for (CurrentphIns = ptphIns; CurrentphIns; CurrentphIns = CurrentphIns->NEXT) {
  InsName = CurrentphIns->INSNAME;
  for (ptCurrentph = ptphIns; ptCurrentph; ptCurrentph = ptCurrentph->NEXT) 
   if ((ptCurrentph != CurrentphIns) && (InsName == ptCurrentph->INSNAME)) {
    fprintf(stderr,"scr_error : Physical instance : %s is redeclared !!\n", InsName);
    exit(1);
   }
 }

 for (CurrentphIns = ptphIns; CurrentphIns; CurrentphIns = CurrentphIns->NEXT) {
  /*if (!(incatalogfeed(CurrentphIns->FIGNAME))) {*/
  if (strcmp(CurrentphIns->FIGNAME,"tie_y")) {
   for (CurrentloIns = ptloIns; CurrentloIns; CurrentloIns = CurrentloIns->NEXT)
    if (CurrentloIns->INSNAME == CurrentphIns->INSNAME) break;
   if (CurrentloIns == NULL) {
    fprintf(stderr,"scr_error : Physical instance : %s does not exist in logic net-list !! \n", CurrentphIns->INSNAME);
    exit(1);
   }
  }
 }

 for (CurrentloIns = ptloIns; CurrentloIns; CurrentloIns = CurrentloIns->NEXT) {
  for (CurrentphIns = ptphIns; CurrentphIns; CurrentphIns = CurrentphIns->NEXT)
   if (CurrentloIns->INSNAME == CurrentphIns->INSNAME) break;
  if (CurrentphIns == NULL) {
    fprintf(stderr,"scr_error : Logic instance : %s does not exist in physical net-list !! \n", CurrentloIns->INSNAME);
    exit(1);
  }
 }
}

/******************************************************************************/
/*	Function : ConCompare()                                               */
/******************************************************************************/
void		ConCompare(ptphCon,ptloCon)

phcon_list	*ptphCon;
locon_list	*ptloCon;

{
 phcon_list	*CurrentphCon = NULL;
 locon_list	*CurrentloCon = NULL;

 for (CurrentphCon = ptphCon; CurrentphCon; CurrentphCon = CurrentphCon->NEXT) {
  for (CurrentloCon = ptloCon; CurrentloCon; CurrentloCon = CurrentloCon->NEXT) 
   if (CurrentphCon->NAME == CurrentloCon->NAME) break;
  if (CurrentloCon == NULL) {
   fprintf(stderr,"scr_error : Physical connector : %s does not exist in logic connector list\n", CurrentphCon->NAME);
   exit(1);
  }
 }
}

/******************************************************************************/
/*	Function : Sesame()                                                   */
/******************************************************************************/
void		Sesame(ptphfig,ptlofig)

phfig_list	*ptphfig;
lofig_list	*ptlofig;

{
 if (ptphfig->PHSEG || ptphfig->PHVIA) {
  fprintf(stderr,"scr_error : Segments and Vias list must be NULL !!\n");
  exit(1);
 }
 InsCompare(ptphfig->PHINS,ptlofig->LOINS);
 ConCompare(ptphfig->PHCON,ptlofig->LOCON);
}
 
