/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : synthetiseur logique                                        */
/*    Fichier : sl_carac.c                                                  */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Burgun L. & Allegre P.                le : 29/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include MUT_H
#include LOG_H
#include BEH_H
#include BVL_H
#include "../mapping/types.h"
#include "../mapping/util.h"
#include "sl_carac.h"
#include "string.h"

/*------------------------------------------------------------------------------
caracDDTBeh	 : caracterise une befig correspondant a une cellule simple. 
-------------------------------------------------------
parametres 	 : une befig.
-------------------------------------------------------
return 		 : void.
------------------------------------------------------------------------------*/
void caracDDTBeh(beh,root)
befig_list *beh;
char *root;
{
FILE	*Pfile;
char  	*FileName;
int 	load;
		/* a modifier quand le compilo initialisera tout seul */

if (beh->USER == NULL)
   beh->USER = addptype(NULL,namealloc("VHB_GENERIC"),NULL);
else
   {
		/* generic deja calcule ? */

   ptype_list *pType;

   pType = getptype(beh->USER,namealloc("VHB_GENERIC"));
   if (pType != NULL)
      if (beh_getgenval(pType->DATA,namealloc("ron")) != NULL)
          return; 
   }

load = loadDDTBeh(beh,root);


if (load == 2)		/* fichier inexistant..on extrait le cp */
   {
   if (strcmp(root,"."))
      FileName = genNAME("%s/%s",root,beh->NAME);
   else
      FileName = genNAME("%s",beh->NAME);

   system(genNAME("mv %s/%s.* .",root,beh->NAME));
   if (( Pfile = fopen(genNAME("%s.fne",beh->NAME),"rt" )) != NULL ) 
      {
			/* extraction - Desb & Tas */

      printf("caracterisation de %s\n",FileName);
/*
      system(genNAME("extract %s",FileName));
*/
      system(genNAME("desb %s",beh->NAME));
      if (strcmp(root,"."))
         {
         if (fopen(genNAME("%s/technologie",root),"rt"))
            system(genNAME("tas %s -c -techno=%s/technologie",beh->NAME,root));
         else
            system(genNAME("tas %s -c",beh->NAME));
         }
      else
         {
         if (fopen("technologie","rt"))
            system(genNAME("tas %s -c -techno=technologie",beh->NAME));
         else
            system(genNAME("tas %s -c",beh->NAME));
         }

      system(genNAME("mv %s.* %s",beh->NAME,root));
      
      printf("fin de caracterisation \n");
      load = loadDDTBeh(beh,root);
      }
   else
     {
     printf("caracDDTBeh : fichiers %s.fne et .car inexistants\n",FileName);
     return;
     }
   }

if (load == 1)
   {
   if (strcmp(root,"."))
      printf("caracDDTBeh : fichier %s/%s.car errone\n",root,beh->NAME);
   else
      printf("caracDDTBeh : fichier %s.car errone\n",beh->NAME);
   exit(-1);
   }

FileName = genNAME("%s",beh->NAME);

vhdlsavebefig(beh);
if (strcmp(root,"."))
   system(genNAME("mv %s.vbe %s/%s.vbe\n", FileName,root,FileName));
else
   system(genNAME("mv %s.vbe %s.vbe\n", FileName,FileName));
}

/*------------------------------------------------------------------------------
loadDDTBeh	 : charge le fichier ".car" dans les generic de la befig. 
-------------------------------------------------------
parametres 	 : une befig.
-------------------------------------------------------
return 		 : un int.
------------------------------------------------------------------------------*/
int loadDDTBeh(beh,root)
befig_list *beh;
char *root;
{
   
FILE	*Pfile;
char     aux[ 30 ];
char	 Name[30];
int numberI;
int val,i;

begen_list *beh_addbegen();
ptype_list *pTLGen;
char * FileName;
char c;
int *pval;

		/* recherche le pointeur d'entrees pour les GENERIC */

FileName = beh->NAME;
if (strcmp(root,"."))
   FileName = genNAME("%s/%s.car",root,FileName);
else
   FileName = genNAME("%s.car",FileName);

if (beh->USER == NULL)
   beh->USER = addptype(NULL,NULL,namealloc("VHB_GENERIC"));

pTLGen = getptype(beh->USER,namealloc("VHB_GENERIC")); 

printf("load %s\n",FileName);

if (( Pfile = fopen(FileName,"rt" )) != NULL ) 
	{
	fscanf( Pfile, "%s", Name);

	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );                     /* lecture de '\n'         */
	fscanf( Pfile, "%d", &val );
        pval = (int *) mbkalloc (sizeof(int));
        *pval = val;
printf("cout =  %d\n",*pval);
        pTLGen->DATA = beh_addbegen(pTLGen->DATA,namealloc("cout"),
                                namealloc("natural"),(void *)pval);

	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );                     /* lecture de '\n'         */
	fscanf( Pfile, "%d", &val );
        pval = (int *) mbkalloc (sizeof(int));
        *pval = val;
        pTLGen->DATA = beh_addbegen(pTLGen->DATA,namealloc("ron"),
                                namealloc("natural"),(void *)pval);

printf("ron = %d\n",*pval);
	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );                     /* lecture de '\n'         */
	fscanf( Pfile, "%d", &val );
        pval = (int *) mbkalloc (sizeof(int));
        *pval = val;
        pTLGen->DATA = beh_addbegen(pTLGen->DATA,namealloc("roff"),
                                namealloc("natural"),(void *)pval);


	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture 1er car suivant  */

        while (c != '$')
           	{
           	ungetc(c,Pfile);
		fscanf( Pfile, "%s", Name );	/* ident Input */
printf("input %s\n",Name);
		c = fgetc( Pfile );		/* lecture de \n           */

	        fscanf( Pfile, "%d", &val );
                pval = (int *) mbkalloc (sizeof(int));
                *pval = val;
                pTLGen->DATA = beh_addbegen(pTLGen->DATA,genNAME("cin_%s",Name),
                                          namealloc("natural"),(void *)pval);

	        c = fgetc( Pfile );             /* lecture de '\n'         */
		c = fgetc( Pfile );		/* lecture 1er car suivant  */

                while (c != '*')
                   {
           	   ungetc(c,Pfile);
		   fscanf( Pfile, "%s", aux );	/* tphl | tplh | tpll | tphh */
		   c = fgetc( Pfile );		/* lecture de \n           */
	   	   fscanf( Pfile, "%d", &val );
		   c = fgetc( Pfile );		/* lecture de \n           */
                   pval = (int *) mbkalloc (sizeof(int));
                   *pval = val;
                   pTLGen->DATA = 
                       beh_addbegen(pTLGen->DATA,genNAME("%s_%s",aux,Name),
                                  namealloc("natural"),pval);

		   c = fgetc( Pfile );		/* lecture 1er car suivant  */
		   if ( feof(Pfile)) {
			fclose( Pfile );
			return (1);
			}
	  	   }
	        c = fgetc( Pfile );		/* lecture de \n           */
		c = fgetc( Pfile );		/* lecture 1er car suivant  */
		}


	c = fgetc( Pfile );			/* lecture de \n           */
	fclose( Pfile );
        return(0);
	}
else
   return(2);
}

