#include "genlib.h"
#include BEH_H
#include BVL_H
#include "c4_local.h"
#include "c4.h"
#include "c4_stretch.h"



/******************************************************************************
 ***  Version 1.0b02                                            14/06/1991  ***
 ******************************************************************************

 ******************************************************************************
 ******************************************************************************
 ***                                                                        ***
 ***                            c.c.c.c tools                               ***
 ***                    Complex Cmos Cells Compiler                         ***
 ***                                                                        ***
 ******************************************************************************
 ******************************************************************************

 ******************************************************************************
 ***                        GENLIB GENERATOR MODULE                         ***
 ******************************************************************************/

/*----------------------------------------------------------------------------
  -------- very low-level func -----------------------------------[genFiles]--
  ----------------------------------------------------------------------------
  SYNTAX : befig_list * genBehave(char *, chain_list*, char)
  ----------------------------------------------------------------------------
  EXEMPLE : genBehave(fName, expr, polar)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
  ----------------------------------------------------------------------------*/

befig_list * genBehave(fName, expr, polarity, area)
char *fName;
chain_list *expr;
char polarity;
{
  lofig_list *fig = getlofig(fName,'A');
  ptype_list *res;
  begen_list *beh_addbegen();
  int *pval;

  befig_list *bhCell;
  register short i = 0, ind = 0;
  befig_list *beh_addbefig();
  berin_list *beh_addberin();
  beout_list *beh_addbeout();
  bepor_list *beh_addbepor();
  berin_list *in;
  int numberI;

  bhCell = beh_addbefig(NULL,fName);

  numberI = numberAtomExpr(expr);
  bhCell->BEPOR = beh_addbepor(bhCell->BEPOR, "vss",'I','B');
  bhCell->BEPOR = beh_addbepor(bhCell->BEPOR, "vdd",'I','B');
  if (polarity == NEG)
     {
     bhCell->BEOUT = beh_addbeout(bhCell->BEOUT,N_OUT_SYMB,
                             notExpr(expr));
     bhCell->BEPOR = beh_addbepor(bhCell->BEPOR, N_OUT_SYMB,'O','B');
     }
  else
     {
     bhCell->BEOUT = beh_addbeout(bhCell->BEOUT, OUT_SYMB, expr);
     bhCell->BEPOR = beh_addbepor(bhCell->BEPOR, OUT_SYMB,'O','B');
     }
  for (i=0;i<numberI;i++)
    {
    bhCell->BERIN = beh_addberin(bhCell->BERIN, 
                             NAME("%s%d", IN_SYMB, numberI - i - 1));
    bhCell->BEPOR = beh_addbepor(bhCell->BEPOR, 
                             NAME("%s%d", IN_SYMB, numberI - i - 1),'I','B');
    }
  bhCell->BEPOR = (bepor_list *) reverse((chain_list *) bhCell->BEPOR);


		/* l'appel a la caracterisation */

  res = caracLofig(fName);

               /* ajout des generic(s) */
  bhCell->BEGEN = NULL;


  pval = (int *) mbkalloc (sizeof(int));
  *pval = area*252; 
  bhCell->BEGEN = (void *)beh_addbegen(bhCell->BEGEN,namealloc("area"),
                            namealloc("natural"),(void *)pval);

  in = bhCell->BERIN;
  while (in)
     {
     char *name = in->NAME;

     pval = (int *) mbkalloc (sizeof(int));
     *pval = getCaracInput(res,"cin",name);
     bhCell->BEGEN = (void *)beh_addbegen(bhCell->BEGEN,genNAME("cin_%s",name),
                               namealloc("natural"),(void *)pval);

     pval = (int *) mbkalloc (sizeof(int));
     *pval = getCaracInput(res,"rup",name);
     bhCell->BEGEN = (void *)beh_addbegen(bhCell->BEGEN,genNAME("rup_%s",name),
                               namealloc("natural"),(void *)pval);

     pval = (int *) mbkalloc (sizeof(int));
     *pval = getCaracInput(res,"rdown",name);
     bhCell->BEGEN = (void *)beh_addbegen(bhCell->BEGEN,genNAME("rdown_%s",name),
                               namealloc("natural"),(void *)pval);

     if (getCarac(res,"type"))
        {
        pval = (int *) mbkalloc (sizeof(int));
        *pval = getCaracInput(res,"tphh",name);
        bhCell->BEGEN = (void *)beh_addbegen(bhCell->BEGEN,genNAME("tphh_%s",name),
                                  namealloc("natural"),(void *)pval);

        pval = (int *) mbkalloc (sizeof(int));
        *pval = getCaracInput(res,"tpll",name);
        bhCell->BEGEN = (void *)beh_addbegen(bhCell->BEGEN,genNAME("tpll_%s",name),
                                  namealloc("natural"),(void *)pval);
        }
     else
        {
        pval = (int *) mbkalloc (sizeof(int));
        *pval = getCaracInput(res,"tplh",name);
        bhCell->BEGEN = (void *)beh_addbegen(bhCell->BEGEN,genNAME("tplh_%s",name),
                                  namealloc("natural"),(void *)pval);

        pval = (int *) mbkalloc (sizeof(int));
        *pval = getCaracInput(res,"tphl",name);
        bhCell->BEGEN = (void *)beh_addbegen(bhCell->BEGEN,genNAME("tphl_%s",name),
                                  namealloc("natural"),(void *)pval);
        }
     in = in->NEXT;
     }
 
  freeCarac(res);
  
  decompileVHDL(bhCell,NULL,0);
  return(bhCell);
}
/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : char *n1_p(char *, int, int, char *, char *)
  ----------------------------------------------------------------------------
  EXEMPLE : nameFig = n1_p("", 1, 1, "s", "i0")
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

char *n1_p(n1, dn, dp, out, in)
char *n1;
int dn, dp;
char *out;
char *in;
{
  int i;

  if (STRLEN_(n1) == 0)
    n1 = NAME("n1_%d_%d", dn, dp);
  dn *= 4;
  dp *= 4;
  (void)delphfig(n1);
  DEF_PHFIG(n1);
  DEF_AB(0, 0, 12, 42 + dn + dp);
  PHCON(ALU1, 8, "vss", WEST, 0, 2);
  PHCON(ALU1, 8, "vss", EAST, 12, 2);
  PHCON(ALU1, 8, "vdd", WEST, 0, 40 + dn + dp);
  PHCON(ALU1, 8, "vdd", EAST, 12, 40 + dn + dp);
  PHCON(ALU2, 2, in , NORTH, 9, 42 + dn + dp);
  PHCON(ALU2, 2, out, NORTH, 3, 42 + dn + dp);
  PHCON(ALU2, 2, in, SOUTH, 9, 0);
  PHCON(ALU2, 2, out, SOUTH, 3, 0);
  PHSEG(PTRANS, 1, "", 6, 22 + dn, 6, 37 + dn + dp);
  PHSEG(NTRANS, 1, "", 6, 8, 6, 17 + dn);
  PHSEG(NWELL, 26 + dp, "", 0, 36 + dn + dp / 2, 12, 36 + dn + dp / 2);
  PHSEG(ALU2, 2, "", 9, 0, 9, 42 + dn + dp);
  PHSEG(ALU2, 2, "", 3, 0, 3, 42 + dn + dp);
  PHSEG(NDIF, 3, "", 3, 10, 3, 15 + dn);
  PHSEG(NDIF, 3, "", 9, 10, 9, 15 + dn);
  PHSEG(PDIF, 3, "", 3, 24 + dn, 3, 35 + dn + dp);
  PHSEG(PDIF, 3, "", 9, 24 + dn, 9, 36 + dn + dp);
  PHSEG(NDIF, 2, "", 3, 42 + dn + dp, 9, 42 + dn + dp);
  PHSEG(PDIF, 2, "", 3, 0, 9, 0);
  PHSEG(POLY, 2, "", 6, 20 + dn, 8, 20 + dn);
  PHSEG(POLY, 1, "", 6, 17 + dn, 6, 22 + dn);
  PHSEG(ALU1, 8, "", 0, 40 + dn + dp, 12, 40 + dn + dp);
  PHSEG(ALU1, 8, "", 0, 2, 12, 2);
  PHSEG(ALU1, 2, "", 9, 30 + dn, 9, 40 + dn + dp);
  PHSEG(ALU1, 2, "", 9, 2, 9, 13 + dn);
  PHSEG(ALU1, 2, "", 3, 13, 3, 31 + dn + dp);
  PHSEG(ALU1, 2, "", 8, 20 + dn, 9, 20 + dn);
  PHSEG(ALU1, 1, "", 9, 20 + dn, 9, 25 + dn);
  PHVIA(CONT_BODY_P, 9, 0);
  PHVIA(CONT_BODY_P, 3, 0);
  PHVIA(CONT_BODY_N, 3, 42 + dn + dp);
  PHVIA(CONT_BODY_N, 9, 42 + dn + dp);
  PHVIA(CONT_VIA, 3, 18 + dn);
  PHVIA(CONT_VIA, 9, 25 + dn);
  PHVIA(CONT_POLY, 8, 20 + dn);
  PHVIA(CONT_DIF_N, 9, 13 + dn);
  PHVIA(CONT_DIF_N, 3, 13 + dn);
  PHVIA(CONT_DIF_P, 3, 25 + dn);
  PHVIA(CONT_DIF_P, 3, 31 + dn + dp);
  PHVIA(CONT_DIF_P, 9, 30 + dn);
  PHVIA(CONT_DIF_P, 9, 36 + dn + dp);
  for (i = 0; i < dn; i += 4) {
    PHVIA(CONT_DIF_N, 9, 13 + i);
    PHVIA(CONT_DIF_N, 3, 13 + i);
  }
  for (i = 0; i < dp; i += 4) {
    PHVIA(CONT_DIF_P, 3, 31 + dn + i);
    PHVIA(CONT_DIF_P, 9, 36 + dn + i);
  }
  SAVE_PHFIG();
  return n1;
}

/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : char *nt1_p(char *, int, int, char *, char *,char *, char *)
  ----------------------------------------------------------------------------
  EXEMPLE : nameFig = nt1_p("", 1, 1, "s", "i", "v0", "v1")
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

char *nt1_p(nt1, dn, dp, out, in1, in2, in3)
char *nt1;
int dn, dp;
char *out;
char *in1, *in2, *in3;
{
  int i;

  if (STRLEN_(nt1) == 0)
    nt1 = NAME("nt1_%d_%d", dn, dp);
  dn *= 4;
  dp *= 4;
  (void)delphfig(nt1);
  DEF_PHFIG(nt1);
  DEF_AB(5, 3, 29, 45 + dn + dp);
  PHCON(ALU1, 8, "vss", WEST, 5, 5);
  PHCON(ALU1, 8, "vss", EAST, 29, 5);
  PHCON(ALU1, 8, "vdd", WEST, 5, 43 + dn + dp);
  PHCON(ALU1, 8, "vdd", EAST, 29, 43 + dn + dp);
  PHCON(ALU2, 2, in1, NORTH, 8, 45 + dn + dp);
  PHCON(ALU2, 2, in2, NORTH, 14, 45 + dn + dp);
  PHCON(ALU2, 2, out, NORTH, 20, 45 + dn + dp);
  PHCON(ALU2, 2, in3, NORTH, 26, 45 + dn + dp);
  PHCON(ALU2, 2, in1, SOUTH, 8, 3);
  PHCON(ALU2, 2, in2, SOUTH, 14, 3);
  PHCON(ALU2, 2, out, SOUTH, 20, 3);
  PHCON(ALU2, 2, in3, SOUTH, 26, 3);
  PHSEG(PTRANS, 1, "", 11, 25 + dn, 11, 51 + dn + dp);
  PHSEG(PTRANS, 1, "", 17, 25 + dn, 17, 51 + dn + dp);
  PHSEG(NTRANS, 1, "", 11, 5, 11, 20 + dn);
  PHSEG(NTRANS, 1, "", 17, 5, 17, 20 + dn);
  PHSEG(NWELL, 26 + dp, "", 5, 39 + dn + dp / 2, 29, 39 + dn + dp / 2);
  PHSEG(ALU2, 2, "", 20, 3, 20, 45 + dn + dp);
  PHSEG(ALU2, 2, "", 14, 3, 14, 45 + dn + dp);
  PHSEG(ALU2, 2, "", 8, 3, 8, 45 + dn + dp);
  PHSEG(NDIF, 3, "", 14, 7, 14, 18 + dn);
  PHSEG(NDIF, 3, "", 20, 7, 20, 18 + dn);
  PHSEG(NDIF, 2, "", 26, 33 + dn, 26, 43 + dn + dp);
  PHSEG(NDIF, 3, "", 8, 7, 8, 18 + dn);
  PHSEG(PDIF, 2, "", 26, 5, 26, 15 + dn);
  PHSEG(PDIF, 3, "", 8, 27 + dn, 8, 49 + dn + dp);
  PHSEG(PDIF, 3, "", 14, 27 + dn, 14, 49 + dn + dp);
  PHSEG(PDIF, 3, "", 20, 27 + dn, 20, 49 + dn + dp);
  PHSEG(POLY, 1, "", 11, 20 + dn, 11, 25 + dn);
  PHSEG(POLY, 2, "", 9, 22 + dn, 11, 22 + dn);
  PHSEG(POLY, 1, "", 15, 25 + dn, 17, 25 + dn);
  PHSEG(POLY, 1, "", 15, 24 + dn, 15, 25 + dn);
  PHSEG(POLY, 1, "", 17, 20 + dn, 25, 20 + dn);
  PHSEG(ALU1, 2, "", 20, 13, 20, 33 + dn + dp);
  PHSEG(ALU1, 2, "", 8, 33 + dn, 8, 45 + dn + dp);
  PHSEG(ALU1, 8, "", 5, 43 + dn + dp, 29, 43 + dn + dp);
  PHSEG(ALU1, 2, "", 26, 33 + dn, 26, 43 + dn + dp);
  PHSEG(ALU1, 1, "", 26, 20 + dn, 26, 28 + dn);
  PHSEG(ALU1, 1, "", 25, 20 + dn, 26, 20 + dn);
  PHSEG(ALU1, 1, "", 14, 24 + dn, 14, 29 + dn);
  PHSEG(ALU1, 1, "", 14, 24 + dn, 15, 24 + dn);
  PHSEG(ALU1, 1, "", 8, 22 + dn, 8, 28 + dn);
  PHSEG(ALU1, 1, "", 8, 22 + dn, 9, 22 + dn);
  PHSEG(ALU1, 8, "", 5, 5, 29, 5);
  PHSEG(ALU1, 2, "", 8, 8, 8, 17 + dn);
  PHSEG(ALU1, 2, "", 26, 5, 26, 15 + dn);
  PHVIA(CONT_VIA, 26, 28 + dn);
  PHVIA(CONT_VIA, 20, 23 + dn);
  PHVIA(CONT_VIA, 14, 29 + dn);
  PHVIA(CONT_VIA, 8, 28 + dn);
  PHVIA(CONT_POLY, 25, 20 + dn);
  PHVIA(CONT_POLY, 15, 24 + dn);
  PHVIA(CONT_POLY, 9, 22 + dn);
  PHVIA(CONT_DIF_P, 20, 33 + dn + dp);
  PHVIA(CONT_DIF_P, 20, 28 + dn + dp);
  PHVIA(CONT_DIF_P, 8, 45 + dn + dp);
  PHVIA(CONT_DIF_P, 8, 33 + dn + dp);
  PHVIA(CONT_DIF_P, 8, 37 + dn + dp);
  PHVIA(CONT_DIF_P, 8, 41 + dn + dp);
  PHVIA(CONT_DIF_N, 20, 13);
  PHVIA(CONT_DIF_N, 20, 17);
  PHVIA(CONT_BODY_N, 26, 33 + dn + dp);
  PHVIA(CONT_BODY_N, 26, 36 + dn + dp);
  PHVIA(CONT_BODY_N, 26, 40 + dn + dp);
  PHVIA(CONT_BODY_N, 26, 43 + dn + dp);
  PHVIA(CONT_BODY_P, 26, 15);
  PHVIA(CONT_BODY_P, 26, 11);
  PHVIA(CONT_BODY_P, 26, 8);
  PHVIA(CONT_BODY_P, 26, 5);
  PHVIA(CONT_DIF_N, 8, 8);
  PHVIA(CONT_DIF_N, 8, 12);
  PHVIA(CONT_DIF_N, 8, 17);
  for (i = 0; i < dn; i += 4) {
    PHVIA(CONT_DIF_N, 8, 21 + i);
    PHVIA(CONT_DIF_N, 20, 21 + i);
    PHVIA(CONT_BODY_P, 26, 19 + i);
  }
  for (i = 0; i < dp; i += 4) {
    PHVIA(CONT_DIF_P, 8, 29 + dn + dp - i);
    PHVIA(CONT_DIF_P, 20, 25 + dn + dp - i);
    PHVIA(CONT_BODY_N, 26, 29 + dn + dp - i);
  }
  SAVE_PHFIG();
  return nt1;
}

/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : char *l1_p(char *, int, int, char *, char *, char *)
  ----------------------------------------------------------------------------
  EXEMPLE : nameFig = l1_p("", 1, 1, "s" "i", "l")
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

char *l1_p(l1, dn, dp,out, i1, i2)
char *l1;
int dn, dp;
char *out;
char *i1, *i2;
{
  int i;

  if (STRLEN_(l1) == 0)
    l1 = NAME("l1_%d_%d", dn, dp);
  dn *= 4;
  dp *= 4;
  (void)delphfig(l1);
  DEF_PHFIG(l1);
  DEF_AB(5, 4, 35, 46 + dn + dp);
  PHCON(ALU1, 8, "vss", WEST, 5, 6);
  PHCON(ALU1, 8, "vss", EAST, 35, 6);
  PHCON(ALU2, 2, out, SOUTH, 8, 4);
  PHCON(ALU2, 2, i1, SOUTH, 26, 4);
  PHCON(ALU2, 2, i2, SOUTH, 32, 4);
  PHSEG(ALU1, 8, "", 5, 6, 35, 6); /* seg vss */
  PHSEG(NTRANS, 7, "", 26, 2, 26, 8);
  PHSEG(NDIF, 3, "", 19, 5, 21, 5);
  PHSEG(POLY, 1, "", 23, 8, 26, 8);
  PHSEG(PDIF, 2, "", 8, 3, 14, 3);
  PHVIA(CONT_BODY_P, 14, 3);
  PHVIA(CONT_DIF_N, 20, 5);
  PHVIA(CONT_DIF_N, 14, 9);
  PHVIA(CONT_DIF_N, 14, 12);
  PHVIA(CONT_BODY_P, 8, 3);
  PHSEG(NTRANS, 1, "", 11, 6, 11, 21 + dn);
  PHSEG(NDIF, 3, "", 8, 8, 8, 19 + dn);
  PHSEG(NDIF, 3, "", 14, 8, 14, 19 + dn);
  PHSEG(NDIF, 3, "", 32, 4, 32, 19 + dn);
  PHSEG(POLY, 1, "", 23, 8, 23, 35 + dn);
  PHSEG(ALU1, 2, "", 14, 9, 14, 12 + dn);
  PHSEG(TALU2, 2, "", 20, 4, 20, 46 + dn + dp);
  PHSEG(TALU2, 2, "", 14, 3, 14, 46 + dn + dp);
  PHSEG(ALU2, 2, "", 8, 4, 8, 46 + dn + dp);
  PHSEG(ALU2, 2, "", 26, 4, 26, 46 + dn + dp);
  PHSEG(ALU2, 2, "", 32, 4, 32, 46 + dn + dp);
  PHSEG(NWELL, 26 + dp, "", 5, 40 + dn + dp / 2, 35, 40 + dn + dp / 2);
  PHCON(ALU1, 8, "vdd", EAST, 35, 44 + dn + dp);
  PHCON(ALU1, 8, "vdd", WEST, 5, 44 + dn + dp);
  PHSEG(ALU1, 8, "", 5, 44 + dn + dp, 35, 44 + dn + dp);
  PHCON(ALU2, 2, out, NORTH, 8, 46 + dn + dp);
  PHCON(ALU2, 2, i1, NORTH, 26, 46 + dn + dp);
  PHCON(ALU2, 2, i2, NORTH, 32, 46 + dn + dp);
  PHSEG(NDIF, 2, "", 20, 41 + dn, 20, 47 + dn + dp);
  PHSEG(ALU1, 2, "", 20, 41 + dn, 20, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 44 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 41 + dn + dp);
  PHSEG(NDIF, 2, "", 32, 41 + dn, 32, 47 + dn + dp);
  PHSEG(ALU1, 2, "", 32, 41 + dn, 32, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 32, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 32, 44 + dn + dp);
  PHVIA(CONT_BODY_N, 32, 41 + dn + dp);
  PHSEG(ALU1, 2, "", 14, 35 + dn, 14, 47 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 47 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 44 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 41 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 38 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 35 + dn + dp);
  PHSEG(PDIF, 3, "", 26, 38 + dn, 26, 45 + dn + dp);
  PHSEG(ALU1, 2, "", 26, 41 + dn, 26, 44 + dn + dp);
  PHVIA(CONT_DIF_P, 26, 41 + dn + dp);
  PHVIA(CONT_DIF_P, 26, 44 + dn + dp);
  PHSEG(PTRANS, 1, "", 11, 26 + dn, 11, 52 + dn + dp);
  PHSEG(PDIF, 3, "", 14, 28 + dn, 14, 50 + dn + dp);
  PHSEG(PDIF, 3, "", 8, 28 + dn, 8, 50 + dn + dp);
  PHSEG(ALU1, 2, "", 32, 14, 32, 24 + dn);
  PHSEG(ALU1, 1, "", 32, 29 + dn, 32, 34 + dn);
  PHSEG(ALU1, 1, "", 18, 23 + dn, 18, 24 + dn);
  PHSEG(ALU1, 1, "", 8, 17 + dn, 8, 29 + dn);
  PHSEG(POLY, 1, "", 17, 21 + dn, 17, 26 + dn);
  PHSEG(NDIF, 2, "", 26, 14 + dn, 26, 19 + dn);
  PHSEG(ALU1, 2, "", 26, 15 + dn, 26, 18 + dn);
  PHSEG(PDIF, 3, "", 26, 28 + dn, 26, 30 + dn);
  PHSEG(ALU1, 1, "", 14, 19 + dn, 14, 28 + dn);
  PHSEG(ALU1, 1, "", 20, 28 + dn, 20, 35 + dn);
  PHSEG(NDIF, 3, "", 26, 17 + dn, 26, 19 + dn);
  PHSEG(ALU1, 1, "", 26, 24 + dn, 26, 29 + dn);
  PHSEG(NDIF, 2, "", 20, 15 + dn, 20, 19 + dn);
  PHSEG(PDIF, 2, "", 20, 29 + dn, 20, 32 + dn);
  PHSEG(NTRANS, 1, "", 29, 12 + dn, 29, 21 + dn);
  PHSEG(NTRANS, 1, "", 17, 13 + dn, 17, 21 + dn);
  PHSEG(PTRANS, 1, "", 17, 26 + dn, 17, 34 + dn);
  PHSEG(POLY, 1, "", 32, 21 + dn, 32, 29 + dn);
  PHSEG(ALU1, 2, "", 8, 14, 8, 17 + dn);
  PHSEG(ALU1, 2, "", 8, 29 + dn, 8, 35 + dn + dp);
  PHSEG(POLY, 1, "", 29, 21 + dn, 32, 21 + dn);
  PHSEG(PTRANS, 4, "", 23, 34 + dn, 28, 34 + dn);
  PHSEG(ALU1, 1, "", 18, 24 + dn, 32, 24 + dn);
  PHSEG(POLY, 2, "", 21, 35 + dn, 23, 35 + dn);
  PHSEG(POLY, 1, "", 17, 23 + dn, 18, 23 + dn);
  PHSEG(ALU1, 1, "", 13, 23 + dn, 14, 23 + dn);
  PHSEG(ALU1, 1, "", 14, 19 + dn, 20, 19 + dn);
  PHSEG(ALU1, 1, "", 20, 35 + dn, 21, 35 + dn);
  PHSEG(ALU1, 1, "", 14, 28 + dn, 20, 28 + dn);
  PHSEG(POLY, 2, "", 11, 23 + dn, 13, 23 + dn);
  PHSEG(POLY, 1, "", 11, 21 + dn, 11, 26 + dn);
  PHVIA(CONT_POLY, 32, 29 + dn);
  PHVIA(CONT_VIA, 32, 34 + dn);
  PHVIA(CONT_DIF_N, 26, 15 + dn);
  PHVIA(CONT_DIF_N, 32, 14 + dn);
  PHVIA(CONT_DIF_N, 32, 18 + dn);
  PHVIA(CONT_DIF_P, 8, 35 + dn);
  PHVIA(CONT_DIF_P, 26, 29 + dn);
  PHVIA(CONT_POLY, 13, 23 + dn);
  PHVIA(CONT_POLY, 18, 23 + dn);
  PHVIA(CONT_DIF_P, 8, 32 + dn);
  PHVIA(CONT_VIA, 8, 23 + dn);
  PHVIA(CONT_VIA, 26, 18 + dn);
  PHVIA(CONT_POLY, 21, 35 + dn);
  PHVIA(CONT_DIF_P, 20, 29 + dn);
  PHVIA(CONT_DIF_P, 8, 29 + dn);
  PHVIA(CONT_DIF_N, 8, 17 + dn);
  PHVIA(CONT_DIF_N, 8, 14 + dn);
  PHVIA(CONT_DIF_N, 20, 18 + dn);
  if (dn != 0) {
    PHSEG(ALU1, 2, "", 20, 5, 20, 8 + dn);
    for (i = 0; i < dn;  i += 4)
      PHVIA(CONT_BODY_P, 20, 12 + i);
  }
  if (dn > 4)
    PHSEG(PDIF, 2, "", 20, 12, 20, 8 + dn);
  for (i = 0; i < dn; i += 4) {
    PHVIA(CONT_DIF_N, 14, 16 + i);
    PHVIA(CONT_DIF_N, 8, 14 + i);
    PHVIA(CONT_DIF_N, 32, 14 + i);
  }
  for (i = 0; i < dp; i += 4) {
    PHVIA(CONT_DIF_P, 14, 35 + dn + i);
    PHVIA(CONT_DIF_P, 8, 39 + dn + i);
    PHVIA(CONT_DIF_P, 26, 41 + dn + i);
    PHVIA(CONT_BODY_N, 20, 41 + dn + i);
    PHVIA(CONT_BODY_N, 32, 41 + dn + i);
  }
  SAVE_PHFIG();
  return l1;
}

/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : char *l1n_p(char *, int, int, char *, char *,char *)
  ----------------------------------------------------------------------------
  EXEMPLE : nameFig = l1_np("", 1, 1, "out", "i", "l")
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

char *l1n_p(l1n, dn, dp, out, i1, i2)
char *l1n;
int dn, dp;
char *out;
char *i1,*i2;
{
  int i;

  if (STRLEN_(l1n) == 0)
    l1n = NAME("l1n_%d_%d", dn, dp);
  dn *= 4;
  dp *= 4;
  (void)delphfig(l1n);
  DEF_PHFIG(l1n);
  DEF_AB(5, 3, 35, 45 + dn + dp);
  PHCON(ALU1, 8, "vss", WEST, 5, 5);
  PHCON(ALU1, 8, "vss", EAST, 35, 5);
  PHSEG(ALU1, 8, "", 5, 5, 35, 5);
  PHCON(ALU2, 2, out, SOUTH, 8, 3);
  PHCON(ALU2, 2, i2, SOUTH, 32, 3);
  PHCON(ALU2, 2, i1, SOUTH, 26, 3);
  PHSEG(PDIF, 2, "", 8, 3, 14, 3);
  PHVIA(CONT_BODY_P, 8, 3);
  PHVIA(CONT_BODY_P, 14, 3);
  PHSEG(NDIF, 2, "", 20, 4, 20, 6);
  PHVIA(CONT_DIF_N, 20, 5);
  PHSEG(NTRANS, 7, "", 26, 2, 26, 7);
  PHSEG(POLY, 1, "", 23, 7, 26, 7);
  PHVIA(CONT_BODY_P, 20, 11);
  PHSEG(NTRANS, 1, "", 11, 6, 11, 20 + dn);
  PHSEG(NDIF, 3, "", 8, 8, 8, 18 + dn);
  PHSEG(NDIF, 3, "", 14, 8, 14, 18 + dn);
  PHSEG(NDIF, 3, "", 32, 4, 32, 18 + dn);
  PHSEG(POLY, 1, "", 23, 7, 23, 34 + dn);
  PHSEG(ALU1, 2, "", 20, 5, 20, 11 + dn);
  PHSEG(TALU2, 2, "", 20, 3, 20, 45 + dn + dp);
  PHSEG(TALU2, 2, "", 14, 3, 14, 45 + dn + dp);
  PHSEG(ALU2, 2, "", 8, 3, 8, 45 + dn + dp);
  PHSEG(ALU2, 2, "", 26, 3, 26, 45 + dn + dp);
  PHSEG(ALU2, 2, "", 32, 3, 32, 45 + dn + dp);
  PHSEG(NWELL, 26 + dp, "", 5, 39 + dn + dp / 2, 35, 39 + dn + dp / 2);
  PHCON(ALU2, 2, out, NORTH, 8, 45 + dn + dp);
  PHCON(ALU2, 2, i1, NORTH, 26, 45 + dn + dp);
  PHCON(ALU2, 2, i2, NORTH, 32, 45 + dn + dp);
  PHCON(ALU1, 8, "vdd", EAST, 35, 43 + dn + dp);
  PHCON(ALU1, 8, "vdd", WEST, 5, 43 + dn + dp);
  PHSEG(ALU1, 8, "", 5, 43 + dn + dp, 35, 43 + dn + dp);
  PHSEG(NDIF, 2, "", 20, 40 + dn, 20, 43 + dn + dp);
  PHSEG(ALU1, 2, "", 20, 40 + dn, 20, 43 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 43 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 40 + dn + dp);
  PHVIA(CONT_DIF_P, 26, 43 + dn + dp);
  PHVIA(CONT_DIF_P, 26, 40 + dn + dp);
  PHVIA(CONT_BODY_N, 32, 45 + dn + dp);
  PHSEG(PTRANS, 1, "", 11, 25 + dn, 11, 40 + dn + dp);
  PHSEG(PDIF, 3, "", 14, 27 + dn, 14, 38 + dn + dp);
  PHSEG(PDIF, 3, "", 8, 27 + dn, 8, 38 + dn + dp);
  PHSEG(PDIF, 3, "", 26, 37 + dn, 26, 44 + dn + dp);
  PHSEG(ALU1, 2, "", 8, 28 + dn, 8, 34 + dn + dp);
  PHSEG(ALU1, 2, "", 8, 14, 8, 17 + dn);
  PHSEG(ALU1, 2, "", 26, 40 + dn, 26, 43 + dn + dp);
  PHSEG(ALU1, 2, "", 32, 14, 32, 22 + dn);
  PHSEG(ALU1, 2, "", 14, 5, 14, 14 + dn);
  PHSEG(ALU1, 2, "", 14, 31 + dn, 14, 43 + dn + dp);
  PHSEG(PDIF, 3, "", 26, 27 + dn, 26, 29 + dn);
  PHSEG(POLY, 1, "", 32, 20 + dn, 32, 28 + dn);
  PHSEG(ALU1, 1, "", 20, 17 + dn, 20, 18 + dn);
  PHSEG(ALU1, 1, "", 20, 27 + dn, 20, 34 + dn);
  PHSEG(ALU1, 1, "", 14, 18 + dn, 14, 27 + dn);
  PHSEG(ALU1, 1, "", 8, 17 + dn, 8, 28 + dn);
  PHSEG(ALU1, 2, "", 26, 14 + dn, 26, 17 + dn);
  PHSEG(POLY, 1, "", 17, 20 + dn, 17, 25 + dn);
  PHSEG(POLY, 1, "", 11, 20 + dn, 11, 25 + dn);
  PHSEG(PDIF, 2, "", 20, 27 + dn, 20, 29 + dn);
  PHSEG(NDIF, 2, "", 20, 16 + dn, 20, 18 + dn);
  PHSEG(NDIF, 2, "", 26, 13 + dn, 26, 18 + dn);
  PHSEG(NTRANS, 1, "", 29, 11 + dn, 29, 20 + dn);
  PHSEG(NTRANS, 1, "", 17, 14 + dn, 17, 20 + dn);
  PHSEG(PTRANS, 1, "", 17, 25 + dn, 17, 31 + dn);
  PHSEG(ALU1, 1, "", 26, 22 + dn, 26, 28 + dn);
  PHSEG(ALU1, 1, "", 32, 28 + dn, 32, 33 + dn);
  PHSEG(NDIF, 3, "", 26, 16 + dn, 26, 18 + dn);
  PHSEG(POLY, 1, "", 29, 20 + dn, 32, 20 + dn);
  PHSEG(POLY, 2, "", 21, 34 + dn, 23, 34 + dn);
  PHSEG(ALU1, 1, "", 20, 34 + dn, 21, 34 + dn);
  PHSEG(ALU1, 1, "", 14, 27 + dn, 20, 27 + dn);
  PHSEG(ALU1, 1, "", 14, 18 + dn, 20, 18 + dn);
  PHSEG(POLY, 1, "", 11, 22 + dn, 18, 22 + dn);
  PHSEG(PTRANS, 4, "", 23, 33 + dn, 28, 33 + dn);
  PHSEG(ALU1, 1, "", 18, 22 + dn, 32, 22 + dn);
  PHVIA(CONT_DIF_N, 32, 14 + dn);
  PHVIA(CONT_DIF_P, 14, 37 + dn);
  PHVIA(CONT_DIF_P, 14, 34 + dn);
  PHVIA(CONT_DIF_N, 14, 11 + dn);
  PHVIA(CONT_DIF_N, 8, 17 + dn);
  PHVIA(CONT_DIF_N, 8, 14 + dn);
  PHVIA(CONT_DIF_N, 14, 14 + dn);
  PHVIA(CONT_DIF_N, 20, 17 + dn);
  PHVIA(CONT_DIF_N, 32, 17 + dn);
  PHVIA(CONT_DIF_P, 8, 28 + dn);
  PHVIA(CONT_DIF_P, 14, 31 + dn);
  PHVIA(CONT_DIF_P, 26, 28 + dn);
  PHVIA(CONT_POLY, 18, 22 + dn);
  PHVIA(CONT_POLY, 32, 28 + dn);
  PHVIA(CONT_VIA, 32, 33 + dn);
  PHVIA(CONT_DIF_P, 8, 31 + dn);
  PHVIA(CONT_VIA, 8, 22 + dn);
  PHVIA(CONT_VIA, 26, 17 + dn);
  PHVIA(CONT_POLY, 21, 34 + dn);
  PHVIA(CONT_DIF_P, 20, 28 + dn);
  PHVIA(CONT_DIF_P, 8, 34 + dn);
  PHVIA(CONT_DIF_N, 26, 14 + dn);
  if (dn != 0)
    PHSEG(PDIF, 2, "", 20, 11, 20, 11 + dn);
  for (i = 0; i < dn; i+=4) {
    PHVIA(CONT_DIF_N, 8, 14 + i);
    PHVIA(CONT_DIF_N, 14, 12 + i);
    PHVIA(CONT_DIF_N, 32, 14 + i);
    PHVIA(CONT_BODY_P, 20, 15 + i);
  }
  for (i = 0; i < dp; i+=4) {
    PHVIA(CONT_DIF_P, 8, 34 + dp + dn - i);
    PHVIA(CONT_DIF_P, 14, 40 + dn + i);
    PHVIA(CONT_DIF_P, 26, 36 + dp + dn - i);
    PHVIA(CONT_BODY_N, 20, 40 + dn + i);
  }
  SAVE_PHFIG();
  return l1n;
}

/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : char *l2_p(char *, int, int, char *,char *,char *,char *,char *)
  ----------------------------------------------------------------------------
  EXEMPLE : nameFig = l2_p("", 1, 1,i, "out", "i1", "l1", "i2", "l2")
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

char *l2_p(l2, dn, dp, out, i1, i2, i3, i4)
char *l2;
int dn, dp;
char *out;
char *i1, *i2, *i3, *i4;
{
  int i;

  if (STRLEN_(l2) == 0)
    l2 = NAME("l2_%d_%d", dn, dp);
  dn *= 4;
  dp *= 4;
  (void)delphfig(l2);
  DEF_PHFIG(l2);
  DEF_AB(5, 4, 47, 46 + dn + dp);
  PHCON(ALU1, 8, "vss", WEST, 5, 6);
  PHCON(ALU1, 8, "vss", EAST, 47, 6);
  PHSEG(ALU1, 8, "", 5, 6, 47, 6); /* seg vss */
  PHCON(ALU2, 2, out, SOUTH, 8, 4);
  PHCON(ALU2, 2, i1, SOUTH, 26, 4);
  PHCON(ALU2, 2, i2, SOUTH, 32, 4);
  PHCON(ALU2, 2, i4, SOUTH, 38, 4);
  PHCON(ALU2, 2, i3, SOUTH, 44, 4);
  PHSEG(NTRANS, 7, "", 26, 2, 26, 8);
  PHSEG(NDIF, 3, "", 19, 5, 21, 5);
  PHSEG(POLY, 1, "", 23, 8, 26, 8);
  PHSEG(PDIF, 2, "", 8, 3, 14, 3);
  PHVIA(CONT_BODY_P, 14, 3);
  PHVIA(CONT_DIF_N, 20, 5);
  PHVIA(CONT_DIF_N, 14, 9);
  PHVIA(CONT_DIF_N, 14, 12);
  PHVIA(CONT_BODY_P, 8, 3);
  PHSEG(PDIF, 2, "", 38, 6, 45, 6);
  PHVIA(CONT_BODY_P, 44, 6);
  PHVIA(CONT_BODY_P, 38, 6);
  PHVIA(CONT_BODY_P, 41, 6);
  PHSEG(PDIF, 2, "", 44, 6, 44, 9 + dn);
  PHSEG(ALU1, 2, "", 44, 6, 44, 9 + dn);
  PHVIA(CONT_BODY_P, 44, 9);
  PHSEG(NTRANS, 1, "", 11, 6, 11, 21 + dn);
  PHSEG(NDIF, 3, "", 8, 8, 8, 19 + dn);
  PHSEG(NDIF, 3, "", 14, 8, 14, 19 + dn);
  PHSEG(NDIF, 3, "", 32, 4, 32, 19 + dn);
  PHSEG(POLY, 1, "", 23, 8, 23, 35 + dn);
  PHSEG(ALU1, 2, "", 14, 9, 14, 12 + dn);
  PHSEG(TALU2, 2, "", 20, 4, 20, 46 + dn + dp);
  PHSEG(TALU2, 2, "", 14, 3, 14, 46 + dn + dp);
  PHSEG(ALU2, 2, "", 8, 4, 8, 46 + dn + dp);
  PHSEG(ALU2, 2, "", 26, 4, 26, 46 + dn + dp);
  PHSEG(ALU2, 2, "", 32, 4, 32, 46 + dn + dp);
  PHSEG(ALU2, 2, "", 38, 4, 38, 46 + dn + dp);
  PHSEG(ALU2, 2, "", 44, 4, 44, 46 + dn + dp);
  PHSEG(NWELL, 26 + dp, "", 5, 40 + dn + dp / 2, 47, 40 + dn + dp / 2);
  PHCON(ALU1, 8, "vdd", WEST, 5, 44 + dn + dp);
  PHCON(ALU1, 8, "vdd", EAST, 47, 44 + dn + dp);
  PHSEG(ALU1, 8, "", 5, 44 + dn + dp, 47, 44 + dn + dp);
  PHCON(ALU2, 2, out, NORTH, 8, 46 + dn + dp);
  PHCON(ALU2, 2, i1, NORTH, 26, 46 + dn + dp);
  PHCON(ALU2, 2, i2, NORTH, 32, 46 + dn + dp);
  PHCON(ALU2, 2, i4, NORTH, 38, 46 + dn + dp);
  PHCON(ALU2, 2, i3, NORTH, 44, 46 + dn + dp);
  PHSEG(NDIF, 2, "", 20, 41 + dn, 20, 47 + dn + dp);
  PHSEG(ALU1, 2, "", 20, 41 + dn, 20, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 44 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 41 + dn + dp);
  PHSEG(NDIF, 2, "", 32, 41 + dn, 32, 47 + dn + dp);
  PHSEG(ALU1, 2, "", 32, 41 + dn, 32, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 32, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 32, 44 + dn + dp);
  PHVIA(CONT_BODY_N, 32, 41 + dn + dp);
  PHSEG(NDIF, 2, "", 38, 41 + dn, 38, 47 + dn + dp);
  PHSEG(ALU1, 2, "", 38, 41 + dn, 38, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 38, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 38, 44 + dn + dp);
  PHVIA(CONT_BODY_N, 38, 41 + dn + dp);
  PHSEG(NDIF, 2, "", 44, 41 + dn, 44, 47 + dn + dp);
  PHSEG(ALU1, 2, "", 44, 41 + dn, 44, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 44, 47 + dn + dp);
  PHVIA(CONT_BODY_N, 44, 44 + dn + dp);
  PHVIA(CONT_BODY_N, 44, 41 + dn + dp);
  PHSEG(ALU1, 2, "", 14, 35 + dn, 14, 47 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 47 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 44 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 41 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 38 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 35 + dn + dp);
  PHSEG(PDIF, 3, "", 26, 38 + dn, 26, 45 + dn + dp);
  PHSEG(ALU1, 2, "", 26, 41 + dn, 26, 44 + dn + dp);
  PHVIA(CONT_DIF_P, 26, 41 + dn + dp);
  PHVIA(CONT_DIF_P, 26, 44 + dn + dp);
  PHSEG(PTRANS, 1, "", 11, 26 + dn, 11, 52 + dn + dp);
  PHSEG(PDIF, 3, "", 14, 28 + dn, 14, 50 + dn + dp);
  PHSEG(PDIF, 3, "", 8, 28 + dn, 8, 50 + dn + dp);
  PHSEG(ALU1, 2, "", 32, 14, 32, 24 + dn);
  PHSEG(ALU1, 1, "", 32, 29 + dn, 32, 34 + dn);
  PHSEG(ALU1, 1, "", 18, 23 + dn, 18, 24 + dn);
  PHSEG(ALU1, 1, "", 8, 17 + dn, 8, 29 + dn);
  PHSEG(POLY, 1, "", 17, 21 + dn, 17, 26 + dn);
  PHSEG(NDIF, 2, "", 26, 14 + dn, 26, 19 + dn);
  PHSEG(ALU1, 2, "", 26, 15 + dn, 26, 18 + dn);
  PHSEG(PDIF, 3, "", 26, 28 + dn, 26, 30 + dn);
  PHSEG(ALU1, 1, "", 14, 19 + dn, 14, 28 + dn);
  PHSEG(ALU1, 1, "", 20, 28 + dn, 20, 35 + dn);
  PHSEG(NDIF, 3, "", 26, 17 + dn, 26, 19 + dn);
  PHSEG(ALU1, 1, "", 26, 24 + dn, 26, 29 + dn);
  PHSEG(NDIF, 2, "", 20, 15 + dn, 20, 19 + dn);
  PHSEG(PDIF, 2, "", 20, 29 + dn, 20, 32 + dn);
  PHSEG(NTRANS, 1, "", 29, 12 + dn, 29, 21 + dn);
  PHSEG(NTRANS, 1, "", 17, 13 + dn, 17, 21 + dn);
  PHSEG(PTRANS, 1, "", 17, 26 + dn, 17, 34 + dn);
  PHSEG(ALU1, 2, "", 8, 14, 8, 17 + dn);
  PHSEG(ALU1, 2, "", 8, 29 + dn, 8, 35 + dn + dp);
  PHSEG(POLY, 1, "", 29, 21 + dn, 29, 28 + dn);  
  PHSEG(POLY, 1, "", 29, 28 + dn, 32, 28 + dn);  
  PHSEG(POLY, 1, "", 32, 28 + dn, 32, 29 + dn);  
  PHSEG(PTRANS, 4, "", 23, 34 + dn, 28, 34 + dn);
  PHSEG(ALU1, 1, "", 18, 24 + dn, 32, 24 + dn);
  PHSEG(POLY, 2, "", 21, 35 + dn, 23, 35 + dn);
  PHSEG(POLY, 1, "", 17, 23 + dn, 18, 23 + dn);
  PHSEG(ALU1, 1, "", 13, 23 + dn, 14, 23 + dn);
  PHSEG(ALU1, 1, "", 14, 19 + dn, 20, 19 + dn);
  PHSEG(ALU1, 1, "", 20, 35 + dn, 21, 35 + dn);
  PHSEG(ALU1, 1, "", 14, 28 + dn, 20, 28 + dn);
  PHSEG(POLY, 2, "", 11, 23 + dn, 13, 23 + dn);
  PHSEG(POLY, 1, "", 11, 21 + dn, 11, 26 + dn);
  PHVIA(CONT_POLY, 32, 29 + dn);
  PHVIA(CONT_VIA, 32, 34 + dn);
  PHVIA(CONT_DIF_N, 26, 15 + dn);
  PHVIA(CONT_DIF_N, 32, 14 + dn);
  PHVIA(CONT_DIF_N, 32, 18 + dn);
  PHVIA(CONT_DIF_P, 8, 35 + dn);
  PHVIA(CONT_DIF_P, 26, 29 + dn);
  PHVIA(CONT_POLY, 13, 23 + dn);
  PHVIA(CONT_POLY, 18, 23 + dn);
  PHVIA(CONT_DIF_P, 8, 32 + dn);
  PHVIA(CONT_VIA, 8, 23 + dn);
  PHVIA(CONT_VIA, 26, 18 + dn);
  PHVIA(CONT_POLY, 21, 35 + dn);
  PHVIA(CONT_DIF_P, 20, 29 + dn);
  PHVIA(CONT_DIF_P, 8, 29 + dn);
  PHVIA(CONT_DIF_N, 8, 17 + dn);
  PHVIA(CONT_DIF_N, 8, 14 + dn);
  PHVIA(CONT_DIF_N, 20, 18 + dn);
  PHSEG(POLY, 1, "", 35, 21 + dn, 38, 21 + dn);
  PHSEG(POLY, 2, "", 38, 21 + dn, 38, 23 + dn);
  PHSEG(ALU1, 1, "", 38, 23 + dn, 38, 35 + dn);
  PHSEG(ALU1, 1, "", 38, 18 + dn, 44, 18 + dn);
  PHSEG(NDIF, 2, "", 38, 14 + dn, 38, 19 + dn);
  PHSEG(NTRANS, 1, "", 35, 12 + dn, 35, 21 + dn);
  PHVIA(CONT_DIF_N, 38, 18 + dn);
  PHVIA(CONT_POLY, 38, 23 + dn);
  PHVIA(CONT_VIA, 38, 35 + dn);
  PHVIA(CONT_VIA, 44, 18 + dn);
  if (dn != 0) {
    PHSEG(ALU1, 2, "", 20, 5, 20, 8 + dn);
    for (i = 0; i < dn; i += 4)
      PHVIA(CONT_BODY_P, 20, 12 + i);
  }
  if (dn > 4)
    PHSEG(PDIF, 2, "", 20, 12, 20, 8 + dn);
  for (i = 0; i < dn; i += 4) {
    PHVIA(CONT_DIF_N, 14, 16 + i);
    PHVIA(CONT_DIF_N, 8, 14 + i);
    PHVIA(CONT_DIF_N, 32, 14 + i);
    PHVIA(CONT_BODY_P, 44, 13 + i);
  }
  for (i = 0; i < dp; i += 4) {
    PHVIA(CONT_DIF_P, 14, 35 + dn + i);
    PHVIA(CONT_DIF_P, 8, 39 + dn + i);
    PHVIA(CONT_DIF_P, 26, 41 + dn + i);
    PHVIA(CONT_BODY_N, 20, 41 + dn + i);
    PHVIA(CONT_BODY_N, 32, 41 + dn + i);
    PHVIA(CONT_BODY_N, 38, 41 + dn + i);
    PHVIA(CONT_BODY_N, 44, 41 + dn + i);
  }
  SAVE_PHFIG();
  return l2;
}

/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : char *l2n_p(char *, int, int, char *, char *, char *, char *, char*)
  ----------------------------------------------------------------------------
  EXEMPLE : nameFig = l2n_p("", 1, 1, "out", "i1", "i2", "i3", "i4")
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

char *l2n_p(l2n, dn, dp, out, i1, i2, i3, i4)
char *l2n;
int dn, dp;
char *out;
char *i1, *i2, *i3, *i4;
{
  int i;

  if (STRLEN_(l2n) == 0)
    l2n = NAME("l2n_%d_%d", dn, dp);
  dn *= 4;
  dp *= 4;
  (void)delphfig(l2n);
  DEF_PHFIG(l2n);
  DEF_AB(5, 3, 47, 45 + dn + dp);
  PHCON(ALU1, 8, "vss", WEST, 5, 5);
  PHCON(ALU1, 8, "vss", EAST, 47, 5);
  PHSEG(ALU1, 8, "", 5, 5, 47, 5);
  PHCON(ALU2, 2, out, SOUTH, 8, 3);
  PHCON(ALU2, 2, i2, SOUTH, 32, 3);
  PHCON(ALU2, 2, i1, SOUTH, 26, 3);
  PHSEG(NDIF, 2, "", 20, 4, 20, 6);
  PHVIA(CONT_DIF_N, 20, 5);
  PHSEG(NTRANS, 7, "", 26, 2, 26, 7);
  PHSEG(POLY, 1, "", 23, 7, 26, 7);
  PHSEG(NTRANS, 1, "", 11, -6, 11, 20 + dn);
  PHSEG(NDIF, 3, "", 8, -4, 8, 18 + dn);
  PHSEG(NDIF, 3, "", 14, -4, 14, 18 + dn);
  PHSEG(NDIF, 3, "", 32, 4, 32, 18 + dn);
  PHSEG(POLY, 1, "", 23, 7, 23, 34 + dn);
  PHSEG(TALU2, 2, "", 20, 3, 20, 45 + dn + dp);
  PHSEG(TALU2, 2, "", 14, 3, 14, 45 + dn + dp);
  PHSEG(ALU2, 2, "", 8, 3, 8, 45 + dn + dp);
  PHSEG(ALU2, 2, "", 26, 3, 26, 45 + dn + dp);
  PHSEG(ALU2, 2, "", 32, 3, 32, 45 + dn + dp);
  PHSEG(NWELL, 26 + dp, "", 5, 39 + dn + dp / 2, 47, 39 + dn + dp / 2);
  PHCON(ALU2, 2, out, NORTH, 8, 45 + dn + dp);
  PHCON(ALU2, 2, i1, NORTH, 26, 45 + dn + dp);
  PHCON(ALU2, 2, i2, NORTH, 32, 45 + dn + dp);
  PHCON(ALU1, 8, "vdd", EAST, 47, 43 + dn + dp);
  PHCON(ALU1, 8, "vdd", WEST, 5, 43 + dn + dp);
  PHSEG(ALU1, 8, "", 5, 43 + dn + dp, 47, 43 + dn + dp);
  PHSEG(NDIF, 2, "", 20, 40 + dn, 20, 46 + dn + dp);
  PHSEG(ALU1, 2, "", 20, 40 + dn, 20, 46 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 40 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 43 + dn + dp);
  PHVIA(CONT_BODY_N, 20, 46 + dn + dp);
  PHVIA(CONT_DIF_P, 26, 40 + dn + dp);
  PHVIA(CONT_DIF_P, 26, 43 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 40 + dn + dp);
  PHVIA(CONT_DIF_P, 14, 43 + dn + dp);
  PHVIA(CONT_BODY_N, 32, 45 + dn + dp);
  PHSEG(PTRANS, 1, "", 11, 25 + dn, 11, 51 + dn + dp);
  PHSEG(PDIF, 3, "", 14, 27 + dn, 14, 49 + dn + dp);
  PHSEG(PDIF, 3, "", 8, 27 + dn, 8, 49 + dn + dp);
  PHSEG(PDIF, 3, "", 26, 37 + dn, 26, 44 + dn + dp);
  PHSEG(ALU1, 2, "", 8, 28 + dn, 8, 34 + dn + dp);
  PHSEG(ALU1, 2, "", 8, 14, 8, 17 + dn);
  PHSEG(ALU1, 2, "", 26, 40 + dn, 26, 43 + dn + dp);
  PHSEG(ALU1, 2, "", 32, 14, 32, 22 + dn);
  PHSEG(ALU1, 2, "", 14, 5, 14, 14 + dn);
  PHSEG(ALU1, 2, "", 14, 31 + dn, 14, 43 + dn + dp);
  PHSEG(PDIF, 3, "", 26, 27 + dn, 26, 29 + dn);
  PHSEG(ALU1, 1, "", 20, 17 + dn, 20, 18 + dn);
  PHSEG(ALU1, 1, "", 20, 27 + dn, 20, 34 + dn);
  PHSEG(ALU1, 1, "", 14, 18 + dn, 14, 27 + dn);
  PHSEG(ALU1, 1, "", 8, 17 + dn, 8, 28 + dn);
  PHSEG(ALU1, 2, "", 26, 14 + dn, 26, 17 + dn);
  PHSEG(POLY, 1, "", 17, 20 + dn, 17, 25 + dn);
  PHSEG(POLY, 1, "", 11, 20 + dn, 11, 25 + dn);
  PHSEG(PDIF, 2, "", 20, 27 + dn, 20, 29 + dn);
  PHSEG(NDIF, 2, "", 20, 16 + dn, 20, 18 + dn);
  PHSEG(NDIF, 2, "", 26, 13 + dn, 26, 18 + dn);
  PHSEG(NTRANS, 1, "", 29, 11 + dn, 29, 20 + dn);
  PHSEG(NTRANS, 1, "", 17, 14 + dn, 17, 20 + dn);
  PHSEG(PTRANS, 1, "", 17, 25 + dn, 17, 31 + dn);
  PHSEG(ALU1, 1, "", 26, 22 + dn, 26, 28 + dn);
  PHSEG(ALU1, 1, "", 32, 28 + dn, 32, 33 + dn);
  PHSEG(NDIF, 3, "", 26, 16 + dn, 26, 18 + dn);
  PHSEG(POLY, 1, "", 29, 20 + dn, 29, 27 + dn);
  PHSEG(POLY, 1, "", 29, 27 + dn, 32, 27 + dn);
  PHSEG(POLY, 1, "", 32, 27 + dn, 32, 28 + dn);
  PHSEG(ALU1, 1, "", 20, 34 + dn, 21, 34 + dn);
  PHSEG(ALU1, 1, "", 14, 27 + dn, 20, 27 + dn);
  PHSEG(ALU1, 1, "", 14, 18 + dn, 20, 18 + dn);
  PHSEG(POLY, 1, "", 11, 22 + dn, 18, 22 + dn);
  PHSEG(POLY, 2, "", 21, 34 + dn, 23, 34 + dn);
  PHSEG(PTRANS, 4, "", 23, 33 + dn, 28, 33 + dn);
  PHSEG(ALU1, 1, "", 18, 22 + dn, 32, 22 + dn);
  PHVIA(CONT_DIF_N, 32, 14 + dn);
  PHVIA(CONT_DIF_P, 14, 37 + dn);
  PHVIA(CONT_DIF_P, 14, 34 + dn);
  PHVIA(CONT_DIF_N, 8, 17 + dn);
  PHVIA(CONT_DIF_N, 8, 14 + dn);
  PHVIA(CONT_DIF_N, 14, 14 + dn);
  PHVIA(CONT_DIF_N, 14, 11 + dn);
  PHVIA(CONT_DIF_N, 14, 8 + dn);
  PHVIA(CONT_DIF_N, 14, 5 + dn);
  PHVIA(CONT_DIF_N, 20, 17 + dn);
  PHVIA(CONT_DIF_N, 32, 17 + dn);
  PHVIA(CONT_DIF_P, 8, 28 + dn);
  PHVIA(CONT_DIF_P, 14, 31 + dn);
  PHVIA(CONT_DIF_P, 26, 28 + dn);
  PHVIA(CONT_POLY, 18, 22 + dn);
  PHVIA(CONT_POLY, 32, 28 + dn);
  PHVIA(CONT_VIA, 32, 33 + dn);
  PHVIA(CONT_DIF_P, 8, 31 + dn);
  PHVIA(CONT_VIA, 8, 22 + dn);
  PHVIA(CONT_VIA, 26, 17 + dn);
  PHVIA(CONT_POLY, 21, 34 + dn);
  PHVIA(CONT_DIF_P, 20, 28 + dn);
  PHVIA(CONT_DIF_P, 8, 34 + dn);
  PHVIA(CONT_DIF_N, 26, 14 + dn);
  PHCON(ALU2, 2, i4, SOUTH, 38, 3);
  PHCON(ALU2, 2, i3, SOUTH, 44, 3);
  PHCON(ALU2, 2, i3, NORTH, 44, 45 + dn + dp);
  PHCON(ALU2, 2, i4, NORTH, 38, 45 + dn + dp);
  PHSEG(POLY, 1, "", 35, 20 + dn, 38, 20 + dn);
  PHSEG(POLY, 2, "", 38, 20 + dn, 38, 22 + dn);
  PHSEG(ALU1, 1, "", 38, 22 + dn, 38, 34 + dn);
  PHSEG(ALU1, 1, "", 38, 17 + dn, 44, 17 + dn);
  PHSEG(NDIF, 2, "", 38, 13 + dn, 38, 18 + dn);
  PHVIA(CONT_DIF_N, 38, 17 + dn);
  PHSEG(ALU2, 2, "", 38, 3, 38, 45 + dn + dp);
  PHSEG(ALU2, 2, "", 44, 3, 44, 45 + dn + dp);
  PHSEG(NTRANS, 1, "", 35, 11 + dn, 35, 20 + dn);
  PHSEG(PDIF, 2, "", 38, 5, 45, 5);
  PHVIA(CONT_BODY_P, 41, 5);
  PHVIA(CONT_BODY_P, 38, 5);
  PHVIA(CONT_BODY_P, 44, 5);
  PHSEG(PDIF, 2, "", 44, 5, 44, 8 + dn);
  PHSEG(ALU1, 2, "", 44, 5, 44, 8 + dn);
  PHVIA(CONT_BODY_P, 44, 8);
  PHVIA(CONT_POLY, 38, 22 + dn);
  PHVIA(CONT_VIA, 38, 34 + dn);
  PHVIA(CONT_VIA, 44, 17 + dn);
  PHSEG(NDIF, 2, "", 38, 40 + dn, 38, 46 + dn + dp);
  PHSEG(ALU1, 2, "", 38, 40 + dn, 38, 46 + dn + dp);
  PHVIA(CONT_BODY_N, 38, 40 + dn + dp);
  PHVIA(CONT_BODY_N, 38, 43 + dn + dp);
  PHVIA(CONT_BODY_N, 38, 46 + dn + dp);
  PHSEG(NDIF, 2, "", 44, 40 + dn, 44, 46 + dn + dp);
  PHSEG(ALU1, 2, "", 44, 40 + dn, 44, 46 + dn + dp);
  PHVIA(CONT_BODY_N, 44, 40 + dn + dp);
  PHVIA(CONT_BODY_N, 44, 43 + dn + dp);
  PHVIA(CONT_BODY_N, 44, 46 + dn + dp);
  if (dn != 0) {
    PHSEG(ALU1, 2, "", 20, 5, 20, 8 + dn);
    for (i = 0; i < dn; i += 4)
      PHVIA(CONT_BODY_P, 20, 12 + i);
  }
  if (dn > 4)
    PHSEG(PDIF, 2, "", 20, 12, 20, 8 + dn);
  for (i = 0; i < dn; i+=4) {
    PHVIA(CONT_DIF_N, 8, 14 + i);
    PHVIA(CONT_DIF_N, 14, 5 + i);
    PHVIA(CONT_DIF_N, 32, 14 + i);
    PHVIA(CONT_BODY_P, 44, 13 + i);
  }
  for (i = 0; i < dp; i+=4) {
    PHVIA(CONT_DIF_P, 8, 34 + dp + dn - i);
    PHVIA(CONT_DIF_P, 14, 40 + dn + i);
    PHVIA(CONT_DIF_P, 26, 36 + dp + dn - i);
    PHVIA(CONT_BODY_N, 20, 40 + dn + i);
    PHVIA(CONT_BODY_N, 38, 40 + dn + i);
    PHVIA(CONT_BODY_N, 44, 40 + dn + i);
  }
  SAVE_PHFIG();
  return l2n;
}

/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : char *tie_p(char *, int, int)
  ----------------------------------------------------------------------------
  EXEMPLE : nameFig = tie_p("", 1, 1)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

char *tie_p(tie, dn, dp)
char *tie;
int dn, dp;
{
  int i;

  if (STRLEN_(tie) == 0)
    tie = NAME("tie_%d_%d", dn, dp);
  dn *= 4;
  dp *= 4;
  (void)delphfig(tie);
  DEF_PHFIG(tie);
  DEF_AB(0, 0, 6, 42 + dn + dp);
  PHCON(ALU1, 8, "vdd", EAST, 6, 40 + dn + dp);
  PHCON(ALU1, 8, "vdd", WEST, 0, 40 + dn + dp);
  PHCON(ALU1, 8, "vss", EAST, 6, 2);
  PHCON(ALU1, 8, "vss", WEST, 0, 2);
  PHSEG(TALU2, 2, "", 3, 0, 3, 42 + dn + dp);
  PHSEG(PDIF, 2, "", 3, 1, 3, 13 + dn);
  PHSEG(NDIF, 2, "", 3, 26 + dn, 3, 41 + dn + dp);
  PHSEG(ALU1, 2, "", 3, 26 + dn, 3, 40 + dn + dp);
  PHSEG(ALU1, 8, "", 0, 40 + dn + dp, 6, 40 + dn + dp);
  PHSEG(ALU1, 2, "", 3, 2, 3, 13 + dn);
  PHSEG(ALU1, 8, "", 0, 2, 6, 2);
  PHSEG(NWELL, 26 + dp, "", 0, 36 + dn + dp / 2, 6, 36 + dn + dp / 2);
  PHVIA(CONT_BODY_N, 3, 38 + dn + dp);
  PHVIA(CONT_BODY_P, 3, 4);
  PHVIA(CONT_BODY_N, 3, 41 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 35 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 32 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 29 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 26 + dn + dp);
  PHVIA(CONT_BODY_P, 3, 1);
  PHVIA(CONT_BODY_P, 3, 7);
  PHVIA(CONT_BODY_P, 3, 10);
  PHVIA(CONT_BODY_P, 3, 13);
  for (i = 0; i < dn; i += 4)
    PHVIA(CONT_BODY_P, 3, 17 + i);
  for (i = 0; i < dp; i += 4)
    PHVIA(CONT_BODY_N, 3, dn + 26 + i);
  SAVE_PHFIG();
  return tie;
}

/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : char *low_p(char *, int, int, char *)
  ----------------------------------------------------------------------------
  EXEMPLE : nameFig = low_p("", 1, 1, "s")
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

char *low_p(low, dn, dp,out)
char *low;
int dn, dp;
char *out;
{
  int i;

  if (STRLEN_(low) == 0)
    low = NAME("low_%d_%d", dn, dp);
  dn *= 4;
  dp *= 4;
  (void)delphfig(low);
  DEF_PHFIG(low);
  DEF_AB(0, 0, 6, 42 + dn + dp);
  PHCON(ALU1, 8, "vdd", EAST, 6, 40 + dn + dp);
  PHCON(ALU1, 8, "vdd", WEST, 0, 40 + dn + dp);
  PHCON(ALU1, 8, "vss", EAST, 6, 2);
  PHCON(ALU1, 8, "vss", WEST, 0, 2);
  PHCON(ALU2, 2, out, NORTH, 3, 42 + dn + dp);
  PHCON(ALU2, 2, out, SOUTH, 3, 0);
  PHSEG(PDIF, 2, "", 3, 1, 3, 13 + dn);
  PHSEG(NDIF, 2, "", 3, 26 + dn, 3, 41 + dn + dp);
  PHSEG(ALU2, 2, "", 3, 0, 3, 42 + dn + dp);
  PHSEG(ALU1, 2, "", 3, 26 + dn, 3, 40 + dn + dp);
  PHSEG(ALU1, 8, "", 0, 40 + dn + dp, 6, 40 + dn + dp);
  PHSEG(ALU1, 2, "", 3, 2, 3, 16 + dn);
  PHSEG(ALU1, 8, "", 0, 2, 6, 2);
  PHSEG(NWELL, 26 + dp, "", 0, 36 + dn + dp / 2, 6, 36 + dn + dp /2);
  PHVIA(CONT_BODY_P, 3, 1);
  PHVIA(CONT_BODY_P, 3, 4);
  PHVIA(CONT_BODY_P, 3, 7);
  PHVIA(CONT_BODY_P, 3, 10);
  PHVIA(CONT_BODY_P, 3, 13);
  PHVIA(CONT_BODY_N, 3, 26 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 29 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 32 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 35 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 38 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 41 + dn + dp);
  PHVIA(CONT_VIA, 3, 16 + dn);
  for (i = 0; i < dn; i += 4)
    PHVIA(CONT_BODY_P, 3, 17 + i);
  for (i = 0; i < dp; i += 4)
    PHVIA(CONT_BODY_N, 3, dn + 26 + i);
  SAVE_PHFIG();
  return low;
}

/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : char *high_p(char *, int, int)
  ----------------------------------------------------------------------------
  EXEMPLE : nameFig = high_p("", 1, 1)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

char *high_p(high, dn, dp, out)
char *high;
int dn, dp;
char *out;
{
  int i;
  if (STRLEN_(high) == 0)
    high = NAME("high_%d_%d", dn, dp);
  dn *= 4;
  dp *= 4;
  (void)delphfig(high);
  DEF_PHFIG(high);
  DEF_AB(0, 0, 6, 42 + dn + dp);
  PHCON(ALU1, 8, "vdd", EAST, 6, 40 + dn + dp);
  PHCON(ALU1, 8, "vdd", WEST, 0, 40 + dn + dp);
  PHCON(ALU1, 8, "vss", EAST, 6, 2);
  PHCON(ALU1, 8, "vss", WEST, 0, 2);
  PHCON(ALU2, 2, out, NORTH, 3, 42 + dn + dp);
  PHCON(ALU2, 2, out, SOUTH, 3, 0);
  PHSEG(PDIF, 2, "", 3, 1, 3, 13 + dn);
  PHSEG(NDIF, 2, "", 3, 26 + dn, 3, 41 + dn + dp);
  PHSEG(ALU2, 2, "", 3, 0, 3, 42 + dn + dp);
  PHSEG(ALU1, 2, "", 3, 23 + dn, 3, 40 + dn + dp);
  PHSEG(ALU1, 8, "", 0, 40 + dn + dp, 6, 40 + dn + dp);
  PHSEG(ALU1, 2, "", 3, 2, 3, 13 + dn);
  PHSEG(ALU1, 8, "", 0, 2, 6, 2);
  PHSEG(NWELL, 26 + dp, "", 0, 36 + dn + dp / 2, 6, 36 + dn + dp / 2);
  PHVIA(CONT_BODY_N, 3, 38 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 35 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 32 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 29 + dn + dp);
  PHVIA(CONT_BODY_N, 3, 26 + dn + dp);
  PHVIA(CONT_BODY_P, 3, 1);
  PHVIA(CONT_BODY_P, 3, 4);
  PHVIA(CONT_BODY_P, 3, 7);
  PHVIA(CONT_BODY_P, 3, 10);
  PHVIA(CONT_BODY_P, 3, 13);
  PHVIA(CONT_BODY_N, 3, 41 + dn + dp);
  PHVIA(CONT_VIA, 3, 23 + dn);
  for (i = 0; i < dn; i += 4)
    PHVIA(CONT_BODY_P, 3, 17 + i);
  for (i = 0; i < dp; i += 4)
    PHVIA(CONT_BODY_N, 3, dn + 26  + i);
  SAVE_PHFIG();
  return high;
}

/*:::::::::::::::::::::::::::: start of genFiles :::::::::::::::::::::::::::::*/

/*----------------------------------------------------------------------------
  -------- very low-level func --------------------------[genFiles/genLogic]--
  ----------------------------------------------------------------------------
  SYNTAX : char *noEq2nameEq(short, char, char)
  ----------------------------------------------------------------------------
  EXEMPLE : eqName = noEq2nameEq(noEq, grTyp, polar)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
  ----------------------------------------------------------------------------*/

char *noEq2nameEq(noEq, graph, polarity)
short noEq;
char graph, polarity;
{
  if (noEq == ALIM)
    if (graph == P_GRAPH)
      return namealloc(VDD_SYMB);
    else
      return namealloc(VSS_SYMB);
  else
    if (noEq == OUTPUT)
      if (polarity == POS)
        return namealloc(NAME("%s%s", INT_EQ_SYMB, "out"));
      else
        return namealloc(N_OUT_SYMB);
    else
      if (graph == P_GRAPH)
         return namealloc(NAME("p%s%d", INT_EQ_SYMB, noEq));
      else
         return namealloc(NAME("n%s%d", INT_EQ_SYMB, noEq));
}

/*----------------------------------------------------------------------------
  -------- very low-level func -----------------------------------[genFiles]--
  ----------------------------------------------------------------------------
  SYNTAX : void genLogic(char *, TrGraph[MAX_H_PITCH] *, char, short[2])
  ----------------------------------------------------------------------------
  EXEMPLE : genLogic(fName, tGr, polar, nbCh)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
  ----------------------------------------------------------------------------*/

void genLogic(name, tGraph, polarity, nbCh)
TrGraph *tGraph[];
char *name, polarity;
short nbCh[];
{
  register short ind = 0, i = 0;
  short dn, dp;
  char *inName;

  dn = nbCh[N_GRAPH] - 2;
  dp = nbCh[P_GRAPH] - 2;
  DEF_LOFIG(name);
  while (tGraph[ind]) {
    if (tGraph[ind]->trName) {
      LOCON(NAME("%s%d", IN_SYMB, i), IN, NAME("%s%d", IN_SYMB, i));
      i++;
    }
    ind++;
  }
  if (polarity == NEG)
    LOCON(N_OUT_SYMB, OUT, N_OUT_SYMB);
  else
    LOCON(OUT_SYMB, OUT, OUT_SYMB);
  LOCON(VDD_SYMB, UNKNOWN, VDD_SYMB);
  LOCON(VSS_SYMB, UNKNOWN, VSS_SYMB);
  ind = i = 0;
  while (tGraph[ind]) {
    if (tGraph[ind]->trName) {
      inName = NAME("%s%d", IN_SYMB, i++);
      LOTRS(TRANSP, 14 +  4 * dp, 1,
             inName,
             noEq2nameEq(tGraph[ind]->hiPEq, P_GRAPH, polarity),
             noEq2nameEq(tGraph[ind]->loPEq, P_GRAPH, polarity));
      LOTRS(TRANSN, 12 +  4 * dn, 1,
             inName,
             noEq2nameEq(tGraph[ind]->hiNEq, N_GRAPH, polarity),
             noEq2nameEq(tGraph[ind]->loNEq, N_GRAPH, polarity));
    }
    else
      if (tGraph[ind]->blkType ==  INV_BLK) {
        LOTRS(TRANSP, 14 +  4 * dp, 1, noEq2nameEq(OUTPUT, P_GRAPH, polarity),
               VDD_SYMB, OUT_SYMB);
        LOTRS(TRANSN, 12 +  4 * dn, 1, noEq2nameEq(OUTPUT, P_GRAPH, polarity),
               VSS_SYMB, OUT_SYMB);
    }
    ind++;
  }
  SAVE_LOFIG();
}

/*----------------------------------------------------------------------------
  -------- very low-level func -------------------------[genFiles/genPhysic]--
  ----------------------------------------------------------------------------
  SYNTAX : void genLCellIn(short, short)
  ----------------------------------------------------------------------------
  EXEMPLE : genLCellIn(nbNCh, nbPCh)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
  ----------------------------------------------------------------------------*/


void genLCellIn(dn, dp)
short dn, dp;
{
  dn *= 4;
  dp *= 4;
				/* cut lines are y=14 and y=38 */
  DEF_PHFIG(L_CELL_IN);
  DEF_AB(6, 6, 12, 48 + dn + dp);
				/* doesn't move */
 /* PHSEG(ALU1, 8, "", 6, 8, 12, 8);*/
  PHVIA(CONT_BODY_P, 9, 5);
				/* cutted thru by first cut line */
  PHSEG(NTRANS, 1, "", 12, 8, 12, 23 + dn);
  PHSEG(NDIF, 2, "", 9, 10, 9, 21 + dn);
				/* cutted thru by both cut lines */
  PHSEG(ALU2, 2, "", 9, 6, 9, 48 + dn + dp);
				/* up the second cut line */
				/* special case for nwell */
  /*PHSEG(NWELL, 26 + dp, "", 6, 42 + dn + dp / 2, 17, 42 + dn + dp / 2);*/
  /*PHSEG(ALU1, 8, "", 6, 46 + dn + dp, 12, 46 + dn + dp);*/
  PHVIA(CONT_BODY_N, 9, 49 + dn + dp);
				/* thru up */
  PHSEG(PTRANS, 1, "", 12, 29 + dn, 12, 46 + dn + dp);
  PHSEG(PDIF, 2, "", 9, 31 + dn, 9, 44 + dn + dp);
				/* middle session */
  PHSEG(POLY, 2, "", 10, 25 + dn, 12, 25 + dn);
  PHSEG(POLY, 1, "", 12, 23 + dn, 12, 29 + dn);
  PHSEG(ALU1, 2, "", 10, 25 + dn, 10, 29 + dn);
  PHSEG(ALU1, 1, "", 9, 29 + dn, 10, 29 + dn);
  PHVIA(CONT_POLY, 10, 25 + dn);
  PHVIA(CONT_VIA, 9, 29 + dn);
}

/*----------------------------------------------------------------------------
  -------- very low-level func -------------------------[genFiles/genPhysic]--
  ----------------------------------------------------------------------------
  SYNTAX : void genLCellOut(short, short)
  ----------------------------------------------------------------------------
  EXEMPLE : genLCellOut(nbNCh, nbPCh)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
  ----------------------------------------------------------------------------*/

void genLCellOut(dn, dp)
short dn, dp;
{
  dn *= 4;
  dp *= 4;
				/* cut lines are y=14 and y=38 */
  DEF_PHFIG(L_CELL_OUT);
  DEF_AB(6, 6, 12, 48 + dn + dp);
				/* doesn't move */
  /*PHSEG(ALU1, 8, "", 6, 8, 12, 8);*/
  PHVIA(CONT_BODY_P, 9, 5);
				/* cutted thru by first cut line */
  PHSEG(NDIF, 2, "", 9, 10, 9, 21 + dn);
				/* cutted thru by both cut lines */
  PHSEG(ALU2, 2, "", 9, 6, 9, 48 + dn + dp);
				/* up the second cut line */
				/* special case for nwell */
  /*PHSEG(NWELL, 26 + dp, "", 6, 42 + dn + dp / 2, 12, 42 + dn + dp / 2);*/
  /*PHSEG(ALU1, 8, "", 6, 46 + dn + dp, 12, 46 + dn + dp);*/
  PHVIA(CONT_BODY_N, 9, 49 + dn + dp);
				/* thru up */
  PHSEG(PDIF, 2, "", 9, 31 + dn, 9, 44 + dn + dp);
				/* middle session */
  PHSEG(ALU1, 1, "", 9, 20 + dn, 9, 34 + dn);
  PHVIA(CONT_VIA, 9, 28 + dn);
}

/*----------------------------------------------------------------------------
  -------- very low-level func -------------------------[genFiles/genPhysic]--
  ----------------------------------------------------------------------------
  SYNTAX : void genLCellInv(short, short)
  ----------------------------------------------------------------------------
  EXEMPLE : genLCellInv(nbNCh, nbPCh)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
  ----------------------------------------------------------------------------*/

void genLCellInv(dn, dp)
short dn, dp;
{
  dn *= 4;
  dp *= 4;
				/* cut lines are y=14 and y=38 */
  DEF_PHFIG(L_CELL_INV);
  DEF_AB(6, 6, 12, 48 + dn + dp);
				/* doesn't move */
  /*PHSEG(ALU1, 8, "", 6, 8, 12, 8);*/
  PHVIA(CONT_BODY_P, 9, 5);
  PHVIA(CONT_DIF_N, 9, 11);
				/* cutted thru by first cut line */
  PHSEG(NTRANS, 1, "", 12, 8, 12, 23 + dn);
  PHSEG(NDIF, 2, "", 9, 10, 9, 21 + dn);
				/* cutted thru by both cut lines */
  PHSEG(TALU2, 2, "", 9, 6, 9, 48 + dn + dp);
				/* up the second cut line */
				/* special case for nwell */
  /*PHSEG(NWELL, 26 + dp, "", 6, 42 + dn + dp / 2, 17, 42 + dn + dp / 2);*/
  /*PHSEG(ALU1, 8, "", 6, 46 + dn + dp, 12, 46 + dn + dp);*/
  PHVIA(CONT_BODY_N, 9, 49 + dn + dp);
  PHVIA(CONT_DIF_P, 9, 43 + dn + dp);
				/* thru up */
  PHSEG(PTRANS, 1, "", 12, 29 + dn, 12, 46 + dn + dp);
  PHSEG(PDIF, 2, "", 9, 31 + dn, 9, 44 + dn + dp);
				/* middle session */
  PHSEG(POLY, 1, "", 12, 23 + dn, 12, 29 + dn);
  PHVIA(CONT_POLY, 10, 25 + dn);
  PHSEG(POLY, 2, "", 10, 25 + dn, 12, 25 + dn);
  PHSEG(ALU1, 1, "", 9, 25 + dn, 10, 25 + dn);
/*  PHSEG(ALU1, 1, "", 9, 20 + dn, 9, 34 + dn); */
  PHVIA(CONT_DIF_P, 15, 34 + dn);
  PHVIA(CONT_DIF_N, 15, 20 + dn);
}

/*----------------------------------------------------------------------------
  -------- very low-level func -------------------------[genFiles/genPhysic]--
  ----------------------------------------------------------------------------
  SYNTAX : void genLCellTrsp(short, short)
  ----------------------------------------------------------------------------
  EXEMPLE : genLCellTrsp(nbNCh, nbPCh)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
  ----------------------------------------------------------------------------*/

void genLCellTrsp(dn, dp)
short dn, dp;
{
  dn *= 4;
  dp *= 4;
				/* cut lines are y=14 and y=38 */
  DEF_PHFIG(L_CELL_TRSP);
  DEF_AB(6, 6, 12, 48 + dn + dp);
				/* doesn't move */
  /*PHSEG(ALU1, 8, "", 6, 8, 12, 8);*/
  PHVIA(CONT_BODY_P, 9, 5);
				/* cutted thru by first cut line */
  PHSEG(NDIF, 2, "", 9, 10, 9, 21 + dn);
				/* cutted thru by both cut lines */
  PHSEG(TALU2, 2, "", 9, 6, 9, 48 + dn + dp);
				/* up the second cut line */
				/* special case for nwell */
  /*PHSEG(NWELL, 26 + dp, "", 6, 42 + dn + dp / 2, 12, 42 + dn + dp / 2);*/
  /*PHSEG(ALU1, 8, "", 6, 46 + dn + dp, 12, 46 + dn + dp);*/
  PHVIA(CONT_BODY_N, 9, 49 + dn + dp);
				/* thru up */
  PHSEG(PDIF, 2, "", 9, 31 + dn, 9, 44 + dn + dp);
}

/*----------------------------------------------------------------------------
  -------- very low-level func -----------------------------------[genFiles]--
  ----------------------------------------------------------------------------
  SYNTAX : void genPhysic(char *, TrGraph[MAX_H_PITCH] *, MetalEq[2][MAX_EQ] *,
                    VertSeg *, VertSeg *, short[2], char)
  ----------------------------------------------------------------------------
  EXEMPLE : genPhysic(fName, tGr, mRou, segInv, segTrsp, nbCh, polar)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
  ----------------------------------------------------------------------------*/

void genPhysic(name, tGr, mRou, sInv, sTrsp, nbCh, polarity)
char *name;
TrGraph *tGr[];
MetalEq *mRou[][MAX_EQ];
VertSeg sInv, sTrsp;
short nbCh[];
char polarity;
{
  register short ind, i = 0;
  char *bloc;
  char sym = NOSYM;
  static short dltCh[2] = {-1, -1};
  short cp0ind, cplind, y;

  if ((dltCh[P_GRAPH] != (nbCh[P_GRAPH] - 2))
      && (dltCh[N_GRAPH] != (nbCh[N_GRAPH] - 2))) {
    dltCh[P_GRAPH] = nbCh[P_GRAPH] - 2;
    dltCh[N_GRAPH] = nbCh[N_GRAPH] - 2;
    (void)delphfig(L_CELL_IN);
    genLCellIn(dltCh[N_GRAPH], dltCh[P_GRAPH]);
    (void)delphfig(L_CELL_OUT);
    genLCellOut(dltCh[N_GRAPH], dltCh[P_GRAPH]);
    (void)delphfig(L_CELL_INV);
    genLCellInv(dltCh[N_GRAPH], dltCh[P_GRAPH]);
    (void)delphfig(L_CELL_TRSP);
    genLCellTrsp(dltCh[N_GRAPH], dltCh[P_GRAPH]);
  }
  DEF_PHFIG(name);
  ind = 0;
  while (tGr[ind]) {
    if (tGr[ind]->trName == NULL)
      switch (tGr[ind]->blkType) {
        case TRSP_BLK :
          bloc = L_CELL_TRSP;
          break;
        case OUT_BLK :
          bloc = L_CELL_OUT;
          sym = SYM_X;
          break;
        case INV_BLK :
          bloc = L_CELL_INV;
          break;
      }
    else
      bloc = L_CELL_IN;
    if (ind == 0)
      PLACE(bloc, NAME("%s%d", L_CELL_SYMB, ind), sym, 0, 0);
    else
      PLACE_RIGHT(bloc, NAME("%s%d", L_CELL_SYMB, ind), sym);
    ind++;
  }
  DEF_AB(0,0,0,0);
  ind = 0;
  while (tGr[ind]) {
    if ((tGr[ind]->trName == NULL) && (tGr[ind]->blkType == OUT_BLK))
      if (polarity == NEG) {
        PHCON(ALU2, 2, N_OUT_SYMB, NORTH, 3 + 6 * ind, HEIGHT(name));
        PHCON(ALU2, 2, N_OUT_SYMB, SOUTH, 3 + 6 * ind, 0 );
      }
      else {
        PHCON(ALU2, 2, OUT_SYMB, NORTH, 3 + 6 * ind, HEIGHT(name));
        PHCON(ALU2, 2, OUT_SYMB, SOUTH, 3 + 6 * ind, 0 );
      }
    if (tGr[ind]->trName) {
      PHCON(ALU2, 2, NAME("%s%d", IN_SYMB, i), NORTH,
            3 + 6 * ind, HEIGHT(name));
      PHCON(ALU2, 2, NAME("%s%d", IN_SYMB, i), SOUTH, 3+6*ind, 0 );
      i++;
    }
    ind++;
  }
  PHCON(ALU1, 8, "vdd", WEST, 0, HEIGHT(name) - 2);
  PHCON(ALU1, 8, "vdd", EAST, 6 * ind , HEIGHT(name) - 2);
  PHCON(ALU1, 8, "vss", WEST, 0, 2 );
  PHCON(ALU1, 8, "vss", EAST, 6 * ind ,2 );
  PHSEG(ALU1, 8, "", 0, 2, 6 * ind, 2); 
  PHSEG(ALU1, 8, "", 0, HEIGHT(name) - 2, 6 * ind, HEIGHT(name) - 2); 
  PHSEG(NWELL, 26 + 4*dltCh[P_GRAPH], "", 0,
        36 + 4*dltCh[N_GRAPH] + 4*dltCh[P_GRAPH] / 2, 6 * ind,
        36 + 4*dltCh[N_GRAPH] + (4*dltCh[P_GRAPH]) / 2);

  for (ind = --ind; ind>= 0; ind--)
    FLATTEN_PHFIG(NAME("%s%d", L_CELL_SYMB, ind), NO);
  ind = 0;
  while (mRou[N_GRAPH][ind]) {
    cp0ind = mRou[N_GRAPH][ind]->contPos[0];
    cplind = mRou[N_GRAPH][ind]->contPos[mRou[N_GRAPH][ind]->nbCont - 1];
    if (mRou[N_GRAPH][ind]->noCh == ALIM)
      for (i = 0; i < mRou[N_GRAPH][ind]->nbCont; i++)
        PHVIA(CONT_DIF_N, 3 + 6 * mRou[N_GRAPH][ind]->contPos[i], 5);
    else
      if (mRou[N_GRAPH][ind]->noCh != -1) {
        y = 6 + 4 * mRou[N_GRAPH][ind]->noCh;
        PHSEG(ALU1, 1, "",
              3 + 6 * (cp0ind < 0 ? - cp0ind - 1 : cp0ind), y,
              3 + 6 * (cplind < 0 ? - cplind - 1 : cplind), y);
        for (i = 0; i < mRou[N_GRAPH][ind]->nbCont; i++)
          if (mRou[N_GRAPH][ind]->contPos[i] >= 0)
            PHVIA(CONT_DIF_N, 3 + 6 * mRou[N_GRAPH][ind]->contPos[i], y);
      }
    ind++;
  }
  ind = 0;
  while (mRou[P_GRAPH][ind]) {
    cp0ind = mRou[P_GRAPH][ind]->contPos[0];
    cplind = mRou[P_GRAPH][ind]->contPos[mRou[P_GRAPH][ind]->nbCont - 1];
    if (mRou[P_GRAPH][ind]->noCh == ALIM) {
      y = 37 + 4 * (dltCh[P_GRAPH] + dltCh[N_GRAPH]);
      for (i = 0; i < mRou[P_GRAPH][ind]->nbCont; i++)
        PHVIA(CONT_DIF_P, 3 + 6 * mRou[P_GRAPH][ind]->contPos[i], y);
    }
    else
      if (mRou[P_GRAPH][ind]->noCh != -1) {
        y = 36 + 4 * (dltCh[P_GRAPH] + dltCh[N_GRAPH])
               - 4 * mRou[P_GRAPH][ind]->noCh;
        PHSEG(ALU1, 1, "",
              3 + 6 * (cp0ind < 0 ? - cp0ind - 1 : cp0ind), y,
              3 + 6 * (cplind < 0 ? - cplind - 1 : cplind), y);
        for (i = 0; i < mRou[P_GRAPH][ind]->nbCont; i++)
          if (mRou[P_GRAPH][ind]->contPos[i] >= 0)
            PHVIA(CONT_DIF_P, 3 + 6 * mRou[P_GRAPH][ind]->contPos[i], y);
      }
    ind++;
  }
  if (sTrsp.xPos != -1)
    PHSEG(ALU1, 1, "", 3 + 6 * sTrsp.xPos, 6 + 4 * sTrsp.y1, 3 + 6 * sTrsp.xPos,
          36 + 4 * (dltCh[P_GRAPH] + dltCh[N_GRAPH]) - 4 * sTrsp.y2);
  if (sInv.xPos != -1)
    PHSEG(ALU1, 1, "", 3 + 6 * sInv.xPos,
          (sInv.y1 == -1 ? 19 + 4 * dltCh[N_GRAPH] : 6 + 4 * sInv.y1),
          3 + 6 * sInv.xPos,
          (sInv.y2 == -1 ? 19 + 4 * dltCh[N_GRAPH] :
          36 + 4 * (dltCh[P_GRAPH] + dltCh[N_GRAPH]) - 4 * sInv.y2));
  SAVE_PHFIG();
}


/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  =-=-=-=- low-level func =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-[]=-
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  SYNTAX : void genFiles(MemFig *, char, char, char)
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  EXEMPLE : genFiles(cell, 1, 1, 1)
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  FONCTION : 
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  ERROR :
          if cell = NULL.						cont
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void genFiles(cell, bFlag, lFlag, pFlag)
MemFig *cell;
char bFlag, lFlag, pFlag;
{

  if (cell == NULL) {
    (void)fprintf(stderr, "\nc4_Warning : Input param of genFiles is ");
    (void)fprintf(stderr, "NULL. [genFiles]\n\n");
    return;
  }
  else
    if (!(cell->status.routTransOK)) {
      (void)fprintf(stderr, "\nc4_Warning : routTrans hasn't ");
      (void)fprintf(stderr, "successfully achieved. [genFiles]\n\n");
      return;
    }
  if (lFlag)
    genLogic(cell->fName, cell->tGraph, cell->result->polarity,
             cell->nbCh);

  if (pFlag)
    genPhysic(cell->fName, cell->tGraph, cell->mRout, cell->segInv,
              cell->segTrsp, cell->nbCh, cell->result->polarity);

  if (bFlag)
    cell->beh = genBehave(cell->fName,expr2Model(cell->trExprABL),
                          cell->result->polarity, C4_NBPITCH(cell));
  else
    cell->beh = NULL;

}

/*::::::::::::::::::::::::::::: end of genFiles ::::::::::::::::::::::::::::::*/
