
#define VHB_GENERIC namealloc("VHB_GENERIC")


	/* ###------------------------------------------------------### */
	/*    Data Structure Definitions				*/
	/* ###------------------------------------------------------### */

typedef struct befig		/* behaviour figure			*/
  {
  struct befig      *NEXT;	/* next figure				*/
  char              *NAME;	/* figure's name			*/
  struct bereg      *BEREG;	/* list of internal signals (REGISTER)	*/
  struct bemsg      *BEMSG;	/* list of assertions			*/
  struct berin      *BERIN;	/* list of inputs (registers and ports)	*/
  struct beout      *BEOUT;	/* list of output ports			*/
  struct bebus      *BEBUS;	/* list of output ports (BUS)		*/
  struct beaux      *BEAUX;	/* list of internal signals		*/
  struct bepor      *BEPOR;	/* list of figure's port built in the	*/
				/* same order as in the port clause	*/
  struct circuit    *CIRCUI;	/* Circuit pointer used during ABL to	*/
				/* BDD transformation			*/
  struct ptype      *USER;	/* reserved for user's application	*/
  }
befig_list;

typedef struct bereg		/* behaviour register			*/
  {
  struct bereg  *NEXT;		/* next figure				*/
  char          *NAME;		/* figure's name			*/
  struct biabl  *BIABL;		/* biabl list head			*/
  struct binode *BINODE;	/* binode list head			*/
  }
bereg_list;

typedef struct bemsg		/* behaviour message			*/
  {
  struct bemsg 	*NEXT;		/* next figure				*/
  char		 LEVEL;		/* severity level of the assertion	*/
  char		*LABEL;		/* instruction's label			*/
  char		*MESSAGE;	/* assertion's message			*/
  struct chain	*ABL;		/* assertion's condition (ABL)		*/
  struct node	*NODE;		/* assertion's condition (BDD)		*/
  }
bemsg_list;

typedef struct beout		/* behaviour simple output connector	*/
  {
  struct beout	*NEXT;		/* next figure				*/
  char		*NAME;		/* figure's name			*/
  struct chain	*ABL;		/* figure's ABL				*/
  struct node	*NODE;		/* figure's BDD				*/
  }
beout_list;

typedef struct bebus		/* behaviour bus output connector	*/
  {
  struct bebus	*NEXT;		/* next figure				*/
  char		*NAME;		/* figure's name			*/
  struct biabl	*BIABL;		/* figure's BIABL			*/
  struct binode	*BINODE;	/* figure's BIBDD			*/
  char		 TYPE;		/* connector's type : W or M		*/
  }
bebus_list;

typedef struct beaux		/* behaviour auxiliary signal		*/
  {	
  struct beaux	*NEXT;		/* next figure				*/
  char		*NAME;		/* figure's name			*/
  struct chain	*ABL;		/* figure's ABL				*/
  struct node	*NODE;		/* figure's BDD				*/
  }
beaux_list;

typedef struct bepor		/* figure's port			*/
  {
  struct bepor *NEXT;		/* next port				*/
  char         *NAME;		/* port's name				*/
  char          DIRECTION;	/* port's mode (same as LOCON)		*/
  char          TYPE;		/* port's type (B, M or W)		*/
  }
bepor_list;

typedef struct biabl		/* couple of ABL			*/
  {
  struct biabl	*NEXT;		/* next figure				*/
  struct chain	*CNDABL;	/* driver's condition of connection ABL	*/
  struct chain	*VALABL;	/* driver's value (ABL)			*/
  }
biabl_list;

typedef struct binode		/* couple of BDD			*/
  {
  struct binode	*NEXT;	 	/* next figure				*/
  struct node	*CNDNODE;	/* driver's condition of connection BDD	*/
  struct node	*VALNODE;	/* driver's value BDD			*/
  }
binode_list;

typedef struct berin		/* primary inputs			*/
  {
  struct berin *NEXT;
  char         *NAME;
  }
berin_list;

typedef struct
  {
  char 		*NAME;		/* identifier name */
  short  	 LEFT;		/* vector's left index */
  short 	 RIGHT;		/* vector's right index */
  }
vhb_name;

typedef struct begen            /* generic                              */
  {
  struct begen *NEXT;           /* next generic                         */
  char         *NAME;           /* generic`s name                       */
  char         *TYPE;           /* generic type`s name                  */
  void         *VALUE;          /* generic`s value                      */
  }
begen_list;
