/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  synthese FPGA                                              */
/*    Fichier :  cost.c                                                     */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  Eudes Prado Lopes                       le : 20 /10/1993 */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include MUT_H
#include LOG_H
#include BEH_H
#include "../compil/lax_param.h"
#include "../compil/sl_util.h"
#include "../bddorder/bdd_order.h"
#include "fp_type.h"
#include "fpga.h"

/*----------------------------------------------------------------------------
costIntFPGA	: fonction interne de cout des FPGA pour guider 
                  le re-odonnancement
------------------------------------------------------------------------------
retour		: un pointeur de liste chainee (support)
                  un cout (entier) -> par adresse
------------------------------------------------------------------------------*/
chain_list *costIntFPGA(pt,pCount)
pNode pt;
int *pCount;
{
chain_list *lstLow, *lstHigh;
chain_list *res;
int lenRes;
pNode pBdd, low, high;

if (pt->index < 2)	/* noeud terminal */
   return (NULL);

if ((pt->low)->index < 2 && (pt->high)->index < 2)	/* noeud atomique */
   {
   return(addchain(NULL,pt->index));
   }

			/* noeud deja traite */

if (pt->mark == 1)	/* CLB de fonction directe */
   {
   return(addchain(NULL,pt));
   }

if (pt->mark == 2)	/* CLB de fonction inverse */
   {
   return(addchain(NULL,notBdd(pt)));
   }

		/* simplifications eventuelles avant l'appel
                   recursif sur les fils */

if (1)
   {
   pBdd = applyBinBdd(AND,pt->high,pt->low);

   if (pBdd == pt->low)
      high = simplifDcOneBdd(pt->high,pt->low);
   else
      high = pt->high;

   if (pBdd == pt->high)
      low = simplifDcOneBdd(pt->low,pt->high);
   else
      low = pt->low;
   }
else
   {
   high = pt->high;
   low = pt->low;
   }

lstLow = costIntFPGA(low,pCount);
lstHigh = costIntFPGA(high,pCount);

while (1)
   {
   pNode ptInv;
   chain_list *toto;

	 /* fusion lexico-graphique des listes chainees */	

   res = (chain_list *) fusionLC(lstLow,lstHigh);

   lenRes = countChain_list(res);

   if (lenRes < SUPPORTMAX)
      {
      freechain(lstLow);
      freechain(lstHigh);
      return(addchain(res,pt->index));
      }
   if (lenRes == SUPPORTMAX)	/* CLB */
      {
      freechain(lstLow);
      freechain(lstHigh);
      freechain(res);
      pt->mark = 1;
      ptInv = notBdd(pt);
      ptInv->mark = 2; 
      *pCount = *pCount + 1;
      return(addchain(NULL,pt));
      }
   if (lenRes > SUPPORTMAX)	/* on coupe un fils */
      {
      int lenHigh, lenLow;

      lenLow  = countChain_list(lstLow);
      lenHigh = countChain_list(lstHigh);

      if (countChain_list(lstLow) > countChain_list(lstHigh))
         {
			/* on cree un CLB pour low */

         low->mark = 1;
         ptInv = notBdd(low);
         ptInv->mark = 2; 
         *pCount = *pCount + 1;
         freechain(lstLow);
         freechain(res);
         lstLow = addchain(NULL,low);
         }
      else
			/* on cree un CLB pour high */
         {
         high->mark = 1;
         ptInv = notBdd(high);
         ptInv->mark = 2; 
         *pCount = *pCount + 1;
         freechain(lstHigh);
         freechain(res);
         lstHigh = addchain(NULL,high);
         }
      }
   }
}
/*----------------------------------------------------------------------------
costFPGA	: fonction de cout des FPGA pour guider le re-odonnancement
------------------------------------------------------------------------------
retour		: un cout (entier)
------------------------------------------------------------------------------*/
int costFPGA(pt)
pNode pt;
{
chain_list *res;
pNode ptInv;
int count = 0;		/* nombre de CLB utilises */

res = costIntFPGA(pt,&count);
if (res == NULL || (res->NEXT == NULL && pt->mark != 2))
   {
   if (res) freechain(res);
   return(count);
   }
else
   {
   freechain(res);
   pt->mark = 1;
   ptInv = notBdd(pt);
   ptInv->mark = 2; 
   return(1 + count);
   }
}

/*-------------------------------------------------------------------------
costFpgaBeh 	: calcule le cout FPGA d'une befig 
---------------------------------------------------------------------------
retour		: un void.
---------------------------------------------------------------------------*/
void costFpgaBeh(beh,func,numCLB,depthCLB)
befig_list *beh;
int (*func)();
int *numCLB;
int *depthCLB;
{
beout_list *out;
beaux_list *aux;
bereg_list *reg;
bebus_list *bus;
bebux_list *bux;
binode_list *binode;
biabl_list *biabl;

*numCLB = 0;
*depthCLB = 0;

markAllBdd(0);

if (0)
   {
   aux = beh->BEAUX;
   while (aux) 
      {
      if (aux->NODE)
         {
         *numCLB = *numCLB + (int)(*func)(aux->NODE);
         }
      aux = aux->NEXT;
      }
   }

out = beh->BEOUT;
while (out) 
   {
   if (out->NODE)
      {
      *numCLB = *numCLB + (int)(*func)(out->NODE);
      }
   out = out->NEXT;
   }

reg = beh->BEREG;
while (reg) 
   {
   binode = reg->BINODE;
   while (binode)
      {
      if (binode->CNDNODE && binode->VALNODE)
         {
         *numCLB = *numCLB + (int)(*func)(binode->VALNODE);
         *numCLB = *numCLB + (int)(*func)(binode->CNDNODE);
         }
      binode = binode->NEXT;
      }
   reg = reg->NEXT;
   }
}

/*----------------------------------------------------------------------------
costIntX3000	: fonction interne de cout des X3000 pour guider 
                  le re-odonnancement
------------------------------------------------------------------------------
retour		: un pointeur de liste chainee (support)
                  un cout (entier) -> par adresse
------------------------------------------------------------------------------*/
chain_list *costIntX3000(pt,pCount,pLstCLB4)
pNode pt;
int *pCount;
chain_list **pLstCLB4;
{
chain_list *lstLow, *lstHigh;
chain_list *res;
int lenRes;
pNode pBdd, low, high;


if (pt->index < 2)	/* noeud terminal */
   return (NULL);

if ((pt->low)->index < 2 && (pt->high)->index < 2)	/* noeud atomique */
   {
   return(addchain(NULL,pt->index));
   }

			/* noeud deja traite */

if (pt->mark == 1)	/* CLB de fonction directe */
   {
   return(addchain(NULL,pt));
   }

if (pt->mark == 2)	/* CLB de fonction inverse */
   {
   return(addchain(NULL,notBdd(pt)));
   }

		/* simplifications eventuelles avant l'appel
                   recursif sur les fils */

if (1)
   {
   pBdd = applyBinBdd(AND,pt->high,pt->low);

   if (pBdd == pt->low)
      high = simplifDcOneBdd(pt->high,pt->low);
   else
      high = pt->high;

   if (pBdd == pt->high)
      low = simplifDcOneBdd(pt->low,pt->high);
   else
      low = pt->low;
   }
else
   {
   high = pt->high;
   low = pt->low;
   }

lstLow = costIntX3000(low,pCount,pLstCLB4);
lstHigh = costIntX3000(high,pCount,pLstCLB4);

while (1)
   {
   pNode ptInv;
   chain_list *toto;

	 /* fusion lexico-graphique des listes chainees */	

   res = (chain_list *) fusionLC(lstLow,lstHigh);

   lenRes = countChain_list(res);

   if (lenRes < SUPPORTMAX)
      {
      freechain(lstLow);
      freechain(lstHigh);
      return(addchain(res,pt->index));
      }
   if (lenRes == SUPPORTMAX)	/* CLB */
      {
      freechain(lstLow);
      freechain(lstHigh);
      freechain(res);
      pt->mark = 1;
      ptInv = notBdd(pt);
      ptInv->mark = 2; 
      *pCount = *pCount + 1;
      return(addchain(NULL,pt));
      }
   if (lenRes > SUPPORTMAX)	/* on coupe un fils */
      {
      int lenHigh, lenLow;

      lenLow  = countChain_list(lstLow);
      lenHigh = countChain_list(lstHigh);

      if (lenRes == SUPPORTMAX + 1)
         {
                        /* CLB 2 sorties */

         if (lenLow > 3 && lenHigh > 3)
            {
            low->mark = 1;
            ptInv = notBdd(low);
            ptInv->mark = 2; 

            high->mark = 1;
            ptInv = notBdd(high);
            ptInv->mark = 2; 

            *pCount = *pCount + 1;
            freechain(lstLow);
            freechain(lstHigh);
            freechain(res);
            res = addchain(NULL,high);
            res = addchain(res,low);
            res = addchain(res,pt->index);
            return(res);
            }
         }


                /* en cas d'egalite, on coupe celui qui a le plus
                   d'entrees primaires dans le support */
 
      if (lenLow == lenHigh)
         {
         chain_list *lc;
         int numInputLow = 0;
         int numInputHigh = 0;
            
         lc = lstLow;
         while (lc)
            {
            if (lc->DATA < 1000)
               numInputLow++;
            lc = lc->NEXT;
            }
         lc = lstHigh;
         while (lc)
            {
            if (lc->DATA < 1000)
               numInputHigh++;
            lc = lc->NEXT;
            }
         lenLow = numInputLow;
         lenHigh = numInputHigh;
         }  


      if (lenLow > lenHigh)
         {
			/* on cree un CLB pour low */

         if (regroupeCLB4(pLstCLB4,lstLow))
            *pCount = *pCount - 1;

         low->mark = 1;
         ptInv = notBdd(low);
         ptInv->mark = 2; 
         *pCount = *pCount + 1;
         freechain(res);
         lstLow = addchain(NULL,low);
         }
      else
			/* on cree un CLB pour high */
         {
         if (regroupeCLB4(pLstCLB4,lstHigh))
            *pCount = *pCount - 1;
	
         high->mark = 1;
         ptInv = notBdd(high);
         ptInv->mark = 2; 
         *pCount = *pCount + 1;
         freechain(res);
         lstHigh = addchain(NULL,high);
         }
      }
   }
}
/*----------------------------------------------------------------------------
costX3000	: fonction de cout des X3000 pour guider le re-ordonnancement
------------------------------------------------------------------------------
retour		: un cout (entier)
------------------------------------------------------------------------------*/
int costX3000(pt,pLstCLB4)
pNode pt;
chain_list **pLstCLB4;
{
chain_list *res;
pNode ptInv;
int count = 0;		/* nombre de CLB utilises */

res = costIntX3000(pt,&count,pLstCLB4);

if (res == NULL || (res->NEXT == NULL && pt->mark != 2))
   {
   if (res) freechain(res);
   return(count);
   }
else
   {
   if (countChain_list(res) < 5)
      {
      if (regroupeCLB4(pLstCLB4,res))
         count = count - 1;
      }

   pt->mark = 1;
   ptInv = notBdd(pt);
   ptInv->mark = 2; 
   return(1 + count);
   }
}

/*----------------------------------------------------------------------------
regroupeCLB4	: on regroupe les CLB 4 
                  Attention : res est desalloue si elle est fusionnee
------------------------------------------------------------------------------
retour		: 1 si possible, 0 sinon 
------------------------------------------------------------------------------*/
int regroupeCLB4(pLstCLB4,res)
chain_list **pLstCLB4;
chain_list *res;
{
int regroupe = 0;
chain_list *lst;
chain_list *lc;

lst = *pLstCLB4;
while (lst && (regroupe == 0))
   {
   chain_list *fusion;

   if (lst->DATA)
      {
      fusion = (chain_list *) fusionLC(res,lst->DATA);

			/* la fusion marche ... */

      if (countChain_list(fusion) < 6)
         {
         regroupe = 1;
         freechain(lst->DATA);
         freechain(res);
         lst->DATA = NULL;
         } 
      freechain(fusion);
      }
   lst = lst->NEXT;
   }
		/* pas de fusion possible, ... on ajoute */

if (regroupe == 0)
   {
   *pLstCLB4 = addchain(*pLstCLB4,res);
   }
return regroupe;
}

/*----------------------------------------------------------------------------
regroupeXMap	:  tries to match CLBs with support <= 4 from
                    a chain list             ------------------------------------------------------------------------------
retour		: one integer denoting the number of actual matchs 
------------------------------------------------------------------------------*/
int regroupeXMap(pLstCLB4)
chain_list *pLstCLB4;
{
int count = 0;
chain_list *plst = pLstCLB4;
 

while (plst)
   {
   chain_list *tete = plst->DATA;
   chain_list *suite = plst->NEXT;
   if (tete != NULL)
      {
      while (suite)
         {
          chain_list *fusion;
         if (suite->DATA)
            {
            fusion = (chain_list *) fusionLC(tete,suite->DATA); 
            if (countChain_list(fusion) < 6)
               {
/*d
                printf("J'announce le mariage de \n");
                printList(tete);
               printList(suite->DATA);
*/
                count++; 
                freechain(suite->DATA); 
               suite->DATA = NULL; 
               freechain(fusion);
               suite = NULL;
                }
             }
         if (suite != NULL)
            suite = suite->NEXT;
         }
      }
   plst = plst->NEXT;
   } 
return count;
}


/*-------------------------------------------------------------------------
costX3000Beh     : calcule le cout X3000 d'une befig 
---------------------------------------------------------------------------
retour          : un void.
---------------------------------------------------------------------------*/

void costX3000Beh(beh,numCLB,depthCLB)
befig_list *beh;
int *numCLB;
int *depthCLB;
{
beout_list *out;
beaux_list *aux;
bereg_list *reg;
bebus_list *bus;
bebux_list *bux;
binode_list *binode;
biabl_list *biabl;
chain_list *lstCLB4;
chain_list *tete;

*numCLB = 0;
*depthCLB = 0;
lstCLB4 = NULL;

markAllBdd(0);

if (0)
   {
   aux = beh->BEAUX;
   while (aux) 
      {
      if (aux->NODE)
         {
         *numCLB = *numCLB + costX3000(aux->NODE,&lstCLB4);
         }
      aux = aux->NEXT;
      }
   }

out = beh->BEOUT;
while (out) 
   {
   if (out->NODE)
      {
      *numCLB = *numCLB + costX3000(out->NODE,&lstCLB4);
      }
   out = out->NEXT;
   }
reg = beh->BEREG;
while (reg) 
   {
   binode = reg->BINODE;
   while (binode)
      {
      if (binode->CNDNODE && binode->VALNODE)
         {
         *numCLB = *numCLB + costX3000(binode->VALNODE,&lstCLB4);
         *numCLB = *numCLB + costX3000(binode->CNDNODE,&lstCLB4);
         }
      binode = binode->NEXT;
      }
   reg = reg->NEXT;
   }
		/* desallocation de lstCLB4 */

tete = lstCLB4;
while (lstCLB4)
   {
   if (lstCLB4->DATA)
      freechain(lstCLB4->DATA);
   lstCLB4 = lstCLB4->NEXT;
   }
freechain(tete);
}

#define TYPE_T 0
#define TYPE_A 1
#define TYPE_I 3
#define TYPE_G 5

/*----------------------------------------------------------------------------
costIntACT1	: fonction interne de cout des ACT1 pour guider 
                  le re-odonnancement
------------------------------------------------------------------------------
retour		: un pointeur de liste chainee (support)
                  un cout (entier) -> par adresse
------------------------------------------------------------------------------*/

/* ======================================================================

Tableau de codage   :  T = 0, A = 1, I = 3, G = 5

  TYPE(L)	TYPE(H)		Resultat	Coupure		Somme
  ----------------------------------------------------------------------
  T		T		A				0
			        I				0
  T		A		G				1
  T		I		G				3
  				A		x		3
  T		G		A		x		5
  ----------------------------------------------------------------------
  A		A		G				2
  A		I		A		x		4
  A		G		A		x		6
  ----------------------------------------------------------------------
  I		I		A		x		6
  I		G		A		x		8
  G		G		A		x		10
  ----------------------------------------------------------------------

  ====================================================================== */

int costIntACT1(pt,pCount,markOR)
pNode pt;
int *pCount;
int markOR;
{
int type_l, type_h;
int somme;
pNode ptInv, pBdd, low, high;

if (pt->index < 2)	/* noeud terminal */
   return (TYPE_T);

			/* noeud deja traite */

if (pt->mark == 1)	/* ACT1 de fonction directe */
   {
   return(TYPE_A);
   }

if (pt->mark == 2)	/* ACT1 de fonction inverse */
   {
   return(TYPE_I);
   }

		/* simplifications eventuelles avant l'appel
                   recursif sur les fils */

if (0)
   {
   pBdd = applyBinBdd(AND,pt->high,pt->low);

   if (pBdd == pt->low || pBdd == pt->high)
      {
      if (pBdd == pt->low)
         high = simplifDcOneBdd(pt->high,pt->low);
      else
         high = pt->high;

      if (pBdd == pt->high)
         low = simplifDcOneBdd(pt->low,pt->high);
      else
         low = pt->low;

		/* si un fils a ete simplifie ... */

      if (low != pt->low || high != pt->high)
         {
         *pCount = *pCount + costACT1(low);
         *pCount = *pCount + costACT1(high);

         pt->mark = 1;
         ptInv = notBdd(pt);
         ptInv->mark = 2;

         *pCount = *pCount + 1;

         return(TYPE_A);
         }
      }
   }


high = pt->high;
low = pt->low;

		/* specifique aux ACTEL 1 */
		/* detection du OU */

if (markOR)
   type_l = costIntACT1(low,pCount,0);
else
   {
   if (high == low->high)
      type_l = costIntACT1(low,pCount,1);
   else
      type_l = costIntACT1(low,pCount,0);
   }

type_h = costIntACT1(high,pCount,0);

/*
printf("index = %d L = %d  H = %d \n",pt->index,type_l,type_h);
*/

somme = type_l + type_h;

if (somme > 3)		/* coupure */
   {
		/* commande OU */

   if (markOR)
      return(TYPE_G);

   pt->mark = 1;
   ptInv = notBdd(pt);
   ptInv->mark = 2;

   *pCount = *pCount + 1;

   return(TYPE_A);
   }
else
   {
   if (somme == 0)		/* TYPE_T - TYPE_T  */
      {
      if (low == zero)
         return(TYPE_A);
      else
         return(TYPE_I);
      }

   if (somme == 3)		/* TYPE_T - TYPE_I */
      {
      if (high == zero || low == one)	/* coupure */
         {
			/* commande OU */

         if (markOR)
            return(TYPE_G);

         pt->mark = 1;
         ptInv = notBdd(pt);
         ptInv->mark = 2;

         *pCount = *pCount + 1;
         return(TYPE_A);
         }
      }

			/* Dans les autres cas :
				TYPE_T - TYPE_A
				TYPE_A - TYPE_A
			*/
   return(TYPE_G);
   }
}
/*----------------------------------------------------------------------------
costACT1	: fonction de cout des ACT1 pour guider le re-odonnancement
------------------------------------------------------------------------------
retour		: un cout (entier)
------------------------------------------------------------------------------*/
int costACT1(pt)
pNode pt;
{
int res;
pNode ptInv;
int count = 0;		/* nombre de ACT1 utilises */

res = costIntACT1(pt,&count,0);

if (res < TYPE_I)		/* TYPE_T ou TYPE_A */ 
   {
   return(count);
   }
else
   {
   pt->mark = 1;
   ptInv = notBdd(pt);
   ptInv->mark = 2; 

   return(1 + count);
   }
}
