/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : Synthetiseur logique                                        */
/*    Fichier : display.c                                                   */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :   DICTUS N.                           le : 15/10/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include MUT_H
#include LOG_H
#include BEH_H
#include "../compil/lax_param.h"
#include "../synthe/sl_type.h"
#include "types.h"
#include "display.h"

void displayChain_liste(liste)
chain_list *liste;
{
   while (liste)
   {
      printf("%s ",liste->DATA);
      liste = CDR(liste);
   }
printf("\n");
}

/******************************************************************************//******* displayArite : affiche l'expression et son arite *********************//******************************************************************************/void displayArite(exp)
chain_list *exp;
{
if (!exp) printf("Null");
if (ATOM(exp))
        printf(" %s",VALUE_ATOM(exp));
else
        {
        printf(" (%s",searchCharOper(OPER(exp)));
        if (ARITE(exp))
           printf(" %d",ARITE(exp));
        mapExpr(displayArite,exp);
        printf(")");
        }
}

/****************************************************************************/
/* --------------------------------------------------------------------
   displayBehMap : affiche les signaux d'une befig et leur ABL

   nb = 1 : befig comportementale
   nb = 0 : befig structurelle

 -------------------------------------------------------------------- */
void displayBehMap(befig,nb)
befig_list *befig;
short nb;
{
berin_list *i;
beout_list *o;
bereg_list *r;
bebus_list *b;
beaux_list *a;

fprintf(stderr,"----- display Befig (%s) -----\n",nb ? "comportementale" : "structurelle");
printf(" OUT :\n");
for(o = befig->BEOUT;o;o = o->NEXT)
	{
	printf("   => %s =",o->NAME);
	displayArite(o->ABL);printf("\n");
	}
printf(" AUX :\n");
for(a = befig->BEAUX;a;a = a->NEXT)
	{
	printf("   => %s =",a->NAME);
	displayArite(a->ABL);printf("\n");
	}
printf(" BUS :\n");
for(b = befig->BEBUS;b;b = b->NEXT)
	{
	biabl_list *bi;

	printf("   => %s\n",b->NAME);
	for(bi = b->BIABL;bi;bi = bi->NEXT)
	    {
	    printf("         = VAL :",b->NAME);
	    displayArite(bi->VALABL);printf("\n");
	    if (nb)
               {
	       printf("         = CND :");
	       displayArite(bi->CNDABL);printf("\n");
 	       }
	    }
	}
printf(" REG :\n");
for(r = befig->BEREG;r;r = r->NEXT)
	{
	biabl_list *bi;

	printf("   => %s =",r->NAME);
	if (!nb)
	    {
	    displayArite(r->BIABL->VALABL);
	    printf("\n");
	    }
	else
	for(bi = r->BIABL;bi;bi = bi->NEXT)
	    {
	    displayArite(bi->VALABL);printf("\n");
	    displayArite(bi->CNDABL);printf("\n");
	    }
	}
fprintf(stderr,"----- Fin displayBehMap -----\n");
}

void nbreRegles()
{
declenList *d;
regle_list *r;
short i = 0;

   for (d=mappSys->ptdecl;d;d=d->NEXT)
      for (r = d->regles;r;r=r->NEXT)
	  i++;
   PRINTF("%d rules generated\n",i);
}

/******************************************************************************/
/************** displayRegles : affiche les couples premisse-conclusion *******/
/******************************************************************************/
void displayRegles(name,liste)
char *name;
chain_list *liste;

{
chain_list *p;

printf("nom de la cellule : %s",name);
for(p = liste;p;p = p->NEXT)
	{
	printf("  \n--> premisse   = ");
	displayArite(CAR(CAR(p)));
	printf("  \n    conclusion = ");
	displayArite(CDR(CAR(p)));
	}
printf("\n");
}

void displayDeclencheurs()
{
declenList *p;

printf("\n***************************************************************");
printf("\n		Lecture de mappSys->ptdecl\n");
printf("***************************************************************\n");
for(p = mappSys->ptdecl;p;p =p->NEXT)
	{
	printf("===============================\n");
	printf("===> nom du declencheur : %s\n",p->name);
	printf("===============================\n");
	if (p->regles)
		{
		regle_list *r;

		for(r = p->regles;r;r=r->NEXT)
			{
			printf("---> ");
			displayArite(r->premisse);
			printf(" -->");
			displayArite(r->conclusion);
			printf("\n");
/*
			displayAlist(r->var);
			printf("\n");
			printf(" profondeur premisse = %d\n",r->prof_premi);
*/
			}
		}
	}
printf("\n");
}

/******************************************************************************/
/***** displayCell : affichage de chaque cellule logique et de ces champs *****/
/******************************************************************************/
void displayCell(c)
cellList *c;

{
ptype_list *pt;
begen_list *gen;
Alist		*in;
tabNumList	*dt,*ct;
ptype_list	*st;
chain_list	*out;
num_list	*d,*dtVal,*ctVal;
biabl_list	*i;

printf("\n*****************************************\n");
printf("Nom de la cellule logique : %s\n",c->nomlog);	
printf("Nom de la cellule par defaut : %s\n",c->nom);	
printf("*****************************************\n");
printf("   Type de la cellule : %c\n",c->type);	
if ((c->type == 'l') || (c->type == 't') || (c->type == 'c'))
	{
	printf("   Fonction logique de la cellule : ");	
        displayArite(c->val_abl->VALABL);printf("\n");
	}
else
	{
	for(i = c->val_abl;i;i = i->NEXT)
		{
		printf("   Fonction logique + commande : ");	
		displayArite(i->VALABL);
		displayArite(i->CNDABL);printf("\n");
		}
	}
printf("   Interface de la cellule : ");
for (in = c->interface;in;in = in->NEXT)
	printf("%s ",in->name); 
printf("\n   Entrees de la cellule : ");
for (in = c->entrees;in;in = in->NEXT)
	printf("%s ",in->name); 
printf("\n   Delais  de la cellule : ");
for (d = c->delais;d;d = d->NEXT)
	printf("%ld ",d->DATA);
printf("\n   Sorties de la cellule : ");
for (out = c->sorties;out;out = out->NEXT)
	printf("%s ",out->DATA); 
printf("\n   Surface de la cellule : %ld\n",c->surface);
printf("   Enveloppe de la cellule : ");
if (c->envel)
	    displayArite(c->envel);
printf("\n");
printf("     Delais_tech :");
	for (dt = c->delais_tech;dt;dt = dt->NEXT)
		{
		printf("\n     %s : ",dt->name); 
		for (dtVal = dt->ptNum;dtVal;dtVal = dtVal->NEXT)
		   printf(" %ld ",dtVal->DATA); 
		}
	printf("\n   Capa_tech :");
	for (ct = c->capa_tech;ct;ct = ct->NEXT)
		{
		printf("\n     %s : ",ct->name); 
		for (ctVal = ct->ptNum;ctVal;ctVal = ctVal->NEXT)
		   printf(" %ld ",ctVal->DATA); 
		}
	printf("\n   Surface_tech :");
	for (st = c->surface_tech;st;st = st->NEXT)
		printf("\n     %s = %ld",st->DATA,st->TYPE); 
	printf("\n   Resistance_tech :");
	for (st = c->resistance_tech;st;st = st->NEXT)
		printf("\n     %s = %ld",st->DATA,st->TYPE); 
	printf("\n");
        printf("   Generic :");
        for(pt = c->generic; pt; pt = pt->NEXT)
           {
           printf("\n     Porte %s\n",(char *)pt->DATA);
           for(gen = (begen_list *)pt->TYPE; gen; gen = gen->NEXT)
              printf("%s=%d ",gen->NAME, *(int *)gen->VALUE);
           }
        printf("\n");
}

void displayTHSignaux()
{
int i;
pElemTH pEl = mappSys->sig_hash->pElem; 

printf("=============================================\n");
printf("        Lecture de mappSys->sig_hash\n");
printf("=============================================\n");

printf("length = %d\t		count = %d\n",mappSys->sig_hash->length,mappSys->sig_hash->count);
printf("=============================================\n");
for (i=0;i<mappSys->sig_hash->length;i++)
    {
    if ((pEl->value != VIDETH) && (pEl->value != DELETETH))
	{
	chain_list *abl;

	printf("NOM du signal : %s\n",pEl->key);
	printf("\ttype\t\t= %d\n",((sig *)pEl->value)->type);
	printf("\tdelais\t\t= %d\n",((sig *)pEl->value)->delais);
	printf("\tcapa\t\t= %d\n",((sig *)pEl->value)->capa);
	printf("\tcout\t\t= %d\n",((sig *)pEl->value)->cout);
	for(abl = ((sig *)pEl->value)->ablList;abl;abl = abl->NEXT)
		{
		printf("\tABL = ");
		displayArite(CAR(abl));
		printf("\n");
		}
	printf("\n");
       }
    pEl++;
    }
}

void displayVirtuel()
{
ptype_list *i;
chain_list *v;

printf("-------------------------------------------------------------------\n");
printf("------------------------ display de mappSys->ref ------------------\n");
printf("-------------------------------------------------------------------\n");
for (i=mappSys->ref;i;i = CDR(i))
    {
    printf("==> NIVEAU = %d\n",i->TYPE);
    for(v = (chain_list *)(i->DATA);v;v = CDR(v))
	printVirtuel(v->DATA);
    }
}

void displayTHVirtuel()
{
int i;
pElemTH pEl = mappSys->virt_hash->pElem; 

printf("=============================================\n");
printf("        Lecture de mappSys->virt_hash\n");
printf("=============================================\n");

printf("length = %d\t		count = %d\n",mappSys->virt_hash->length,mappSys->virt_hash->count);
printf("=============================================\n");
fprintf(stderr,"%D cellules generees\n",mappSys->virt_hash->count);
for (i=0;i<mappSys->virt_hash->length;i++)
    {
    if ((pEl->value != VIDETH) && (pEl->value != DELETETH))
       printVirtuel(pEl->key);
    pEl++;
    }
}

void printVirtuel(nameVirt)
char *nameVirt;
{
	virtuelList *virt = (virtuelList *)testObj(nameVirt,'v');
	chain_list *sol = virt->solutions;
		
	printf(" -> printVirtuel : NOM = %s\n",nameVirt);
	printf("\tdelais\t\t= %d\n",virt->delais);
	printf("\tsurf_cone\t= %d\n",virt->surface_cone);
	printf("\tcapa\t\t= %d\n",virt->capa);
	printf("\tdel_rc\t\t= %d\n",virt->del_rc);
	printf("\tsolutions\t= ");
	displayArite(CAR(virt->solutions));
	for(sol = CDR(virt->solutions);sol;sol = CDR(sol))
	{
	   printf("\n\t\t\t  ");
	   displayArite(CAR(sol));
	}
	printf("\n\tfanout\t\t= ");
	displayChain_liste(virt->fanout);
	printf("\tcellule\t\t= %s\n",virt->cellule);
	if (virt->op_log)
	  printf("\top_log\t\t= %s\n",(virt->op_log)->nomlog);
}
