#include <stdio.h>
#include <sys/ioctl.h>
#include <sgtty.h>
#include <f_declars.h>

static struct sgttyb tty = { 0 };
static struct sgttyb otty = { 0 };
static char buf;

/*
 * Fonction qui retourne un code ascii de touche si une touche a ete frappee
 * ou -1 (sur 32 bits) si non
 *
 * Matthieu - Avril 89
 */
 
static int _getch()
{
    static struct sgttyb tty = {0};
    static struct sgttyb otty = {0};
    char buf;
    int n = 0;
    
    /* se mettre en mode cbreak */
    ioctl (fileno(stdin), TIOCGETP, &tty);      
    otty = tty;                 
    tty.sg_flags  |= CBREAK; /* mode cbreak */
    tty.sg_flags  &= ~(ECHO); /* mode cbreak */
    ioctl(fileno(stdin), TIOCSETN, &tty);
    /* tester si caractere disponible */
    ioctl(fileno(stdin), FIONREAD, &n);
    if (n > 0) {
        /* Lire un caractere */
        read(fileno(stdin), &buf, 1);
    }
    /* remet le terminal dans son etat precedent */
    ioctl(fileno(stdin), TIOCSETN, &otty);

    if (n > 0) 
        return((int)buf);
    else
        return(-1);
}

int getch()
{
int c;
	while ((c = _getch()) == -1) ;
	if (c == 0x0a) return 0x0d;
	if (c == 0x1b) {
		/* Escape */
		if ((c = _getch()) == -1)
			return HOME;
		if (c != 0x5b)
			return HOME;
		if ((c = _getch()) == -1)
			return HOME;
		if (c == 0x31) {
		   if ((c = _getch()) == -1)
			return HOME;
		   switch (c) {
			case 0x31 : c = F1 ; break;
			case 0x32 : c = F2 ; break;
			case 0x33 : c = F3 ; break;
			case 0x34 : c = F4 ; break;
			case 0x35 : c = F5 ; break;
			case 0x37 : c = F6 ; break;
			case 0x38 : c = F7 ; break;
			case 0x39 : c = F8 ; break;
			default : return HOME;
			}
	  	   }
		else {
		   if ((c = _getch()) == -1)
			return HOME;
		   switch (c) {
			case 0x30 : c = F9  ; break;
			case 0x31 : c = F10 ; break;
			case 0x33 : c = F11 ; break;
			case 0x34 : c = F12 ; break;
			}
		    }
		_getch();
		return c;
		}
	else return c;
}
