/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur Logique                                       */
/*    Fichier :  sl_main.c                                                  */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 08/01/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include MUT_H
#include LOG_H
#include BEH_H

#include "../menu/sl_corps.h"
#include "../ablorder/sl_order.h"
#include "../compil/lax_param.h"
#include "sl_type.h"
#include "sl_system.h"
#include "../compil/sl_util.h"

main(argc,argv)
int argc ;
char *argv[];
{
ptype_list *delayPI;
char *carint;
char *name;
int trace;

int myargc;
char *myargv [40];

for (myargc = 0; myargc < argc; myargc++) {
   myargv [myargc] = strdup (argv[myargc]);
}

myargc = argc;

VHB_HEDFIG = NULL;
sl_sys = initializeSLSystem();
majSystem(sl_sys);

		/* verification de la validite des arguments */

if (!verifArgs(sl_sys,myargc,myargv)) exit(-1);

initializeBdd(1);

		/* initialisation selon le mode (batch ou non) */

if (!strcmp(argv[1],"-o") || !strcmp(argv[1],"-l") ||!strcmp(argv[1],"-s") ||
    !strcmp(argv[1],"-c")) 
   {

		/* initialisation du systeme */

   addInfoSystem(sl_sys,1,myargc,myargv,"3.00");

   if (SL_BANN)
      displaySystem(sl_sys);
   trace = 1;
   if (SL_TRACE == 2)
      trace = 2;

   putenv((char *) genNAME("MBK_CATA_LIB=%s",SL_CATA_SAVE));
   mbkenv();

   if (SL_OPTION == 's' || SL_OPTION == 'c')
      {
      if (compileVHDL(SL_VHDL,SL_ORDERPI,SL_ORDER,SL_PAR,
                      SL_AUX,1,1,0,trace,nameInt,NULL) == NULL)
         {
         printf("*** Compilation aborted...\n");
         exit(-1);
         }
      }
   else
      {
      int vhb_reorder = 0;

      if (SL_OPTION == 'l')
         SL_AUX = 1;

      if (SL_MAKEORDER >= 1)
         vhb_reorder = 2;
       
      if (compileVHDL(SL_VHDL,SL_ORDERPI,SL_ORDER,SL_PAR,
                      SL_AUX,1,vhb_reorder,1,trace,nameInt,NULL) == NULL)
         {
         printf("*** Compilation aborted...\n");
         exit(-1);
         }
      }


   putenv((char *) genNAME("MBK_CATA_LIB=%s:%s",SL_CATA_LIB,SL_CCCC_LIB));
   mbkenv();

   SL_BEH = VHB_HEDFIG;
   carint = (char *) mbkalloc(strlen(SL_BEH->NAME) + 2);

		/* verification de la coherence */

   verifCohBeh(SL_BEH,SL_DELAYPI,SL_OPTIMPO);

   if (SL_TRACE)
      displayBeh(SL_BEH,1);

   if (SL_OPTION == 'o' || SL_OPTION == 'l')	/* OPTIMISATION */
      {
      if (SL_OPTION == 'l')
         SL_AUX = 1;

      anealingFOOD(SL_TRACE);

      decompileVHDL(SL_BEH,SL_FILEOUT,1);
      mbkfree(carint);
      }
   else 		/* PROJECTION OU DECOMPOSITION STRUCTURELLE */
      {
			/* elimination des DC */

      removeDCBeh(SL_BEH);
      mapCarExprBeh(SL_BEH,simplif10Expr);

      if (SL_OPTION == 's')
         mappingSC();
      else
         mappingC4();

      }
   }
else
   {
		/* version interactive */

   if (argc == 3) 
      {
      addInfoSystem(sl_sys,0,myargc,myargv,"Logic Synthesis - V 3.00");
      }
   else		/* avec fichier de parametres */
      addInfoSystem(sl_sys,2,myargc,myargv,"Logic Synthesis - V 3.00");

   BVL_LINNUM = 0;
   PRINCIPAL(1);
   }
printf("\n");
exit(0);
}
