
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbeout.c					*/
/* date		: Aug  28 1992						*/
/* version	: v102							*/
/* authors	: P. BAZARGAN						*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbeout						*/
/* description	: create a BEOUT structure at the top the list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_beout *syf_beh_addbeout (lastbeout, name, abl_expr, bdd_expr,type)

struct syf_beout *lastbeout;	/* pointer on the last beout structure	*/
char         *name;		/* port's name				*/
struct chain *abl_expr;		/* port's expression (ABL)		*/
struct node  *bdd_expr;		/* port's expression (BDD)		*/
unsigned char type;		/* port's type 				*/

  {
  struct syf_beout *ptout;

  name         = namealloc (name);

  ptout        = (struct syf_beout *) mbkalloc (sizeof(struct syf_beout));
  ptout->NAME  = name;
  ptout->ABL   = abl_expr;
  ptout->NODE  = bdd_expr;
  ptout->TYPE  = type;
  ptout->NEXT  = lastbeout;

  return (ptout);
  }
