
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbetyp.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbetyp						*/
/* description	: add an BETYP structure at the top of a list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_betyp *syf_beh_addbetyp (lastbetyp, name , left , right , value ,
                            size     , byte , base , index, resolv, class)

struct syf_betyp  *lastbetyp;	/* pointer on the last betyp		*/
char          *name;		/* type's name				*/
int            left;		/* left bound				*/
int            right;		/* right bound				*/
char         **value;		/* list of values			*/
unsigned int   size;		/* number of values			*/
unsigned int   byte;		/* number of bytes needed to code values*/
unsigned char  base;		/* the base type or element's type	*/
unsigned char  index;		/* the type of the index for an array	*/
unsigned char  resolv;		/* index of resolution function		*/
char           class;		/* type's class (E, I, A, S)		*/

  {
  struct syf_betyp *ptbetyp;

  name            = namealloc (name);

  ptbetyp         = (struct syf_betyp *) mbkalloc (sizeof(struct syf_betyp));

  ptbetyp->CLASS  = class;
  ptbetyp->NAME   = name;
  ptbetyp->LEFT   = left;
  ptbetyp->RIGHT  = right;
  ptbetyp->VALUE  = value;
  ptbetyp->SIZE   = size;
  ptbetyp->BYTE   = byte;
  ptbetyp->BASE   = base;
  ptbetyp->INDEX  = index;
  ptbetyp->RESOLV = resolv;

  ptbetyp->NEXT   = lastbetyp;

  return (ptbetyp);
  }
