
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebebus.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebebus						*/
/* description	: delete a list of BEBUS structures and all objects	*/
/*		  pointed by any os BEBUSs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebebus (listbebus)

struct syf_bebus *listbebus;	/* list of bebus to be deleted		*/

  {
  struct syf_bebus *ptbebus;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbebus != NULL)
    {
    syf_beh_frebiabl  (listbebus->BIABL);
    syf_beh_frebinode (listbebus->BINODE);

    ptbebus   = listbebus;
    listbebus = listbebus->NEXT;
    mbkfree (ptbebus);
    }

  }
