
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebebux.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebebux						*/
/* description	: delete a list of BEBUX structures and all objects	*/
/*		  pointed by any os BEBUXs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebebux (listbebux)

struct syf_bebux *listbebux;	/* list of bebux to be deleted		*/

  {
  struct syf_bebux *ptbebux;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbebux != NULL)
    {
    syf_beh_frebiabl  (listbebux->BIABL);
    syf_beh_frebinode (listbebux->BINODE);

    ptbebux   = listbebux;
    listbebux = listbebux->NEXT;
    mbkfree (ptbebux);
    }

  }
