
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebeout.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebeout						*/
/* description	: delete a list of BEOUT structures and all objects	*/
/*		  pointed by any os BEOUTs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebeout (listbeout)

struct syf_beout *listbeout;	/* list of beout to be deleted		*/

  {
  struct syf_beout *ptbeout;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbeout != NULL)
    {
    freeExpr (listbeout->ABL);

    ptbeout   = listbeout;
    listbeout = listbeout->NEXT;
    mbkfree (ptbeout);
    }

  }
